/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingRuntimeException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.ValidityException;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.util.Messages;

public final class FieldHandlerImpl
implements FieldHandler {
    private static final String ADD_PREFIX = "add";
    private final FieldHandler _handler;
    private final Field _field;
    private Method[] _getSequence;
    private Method[] _setSequence;
    private Method _addMethod;
    private Method _getMethod;
    private Method _setMethod;
    private Method _hasMethod;
    private Method _deleteMethod;
    private Method _createMethod;
    private final String _fieldName;
    private final Class _fieldType;
    private final boolean _immutable;
    private final Object _default;
    private boolean _required;
    private TypeConvertor _convertTo = null;
    private TypeConvertor _convertFrom = null;
    private final String _convertParam;
    private final CollectionHandler _colHandler;

    public FieldHandlerImpl(FieldHandler fieldHandler, TypeInfo typeInfo) throws MappingException {
        this._handler = fieldHandler;
        this._field = null;
        this._fieldName = fieldHandler.toString();
        this._fieldType = Types.typeFromPrimitive(typeInfo.getFieldType());
        this._immutable = typeInfo.isImmutable();
        this._required = typeInfo.isRequired();
        this._default = typeInfo.getDefaultValue();
        this._convertTo = typeInfo.getConvertorTo();
        this._convertFrom = typeInfo.getConvertorFrom();
        this._convertParam = typeInfo.getConvertorParam();
        this._colHandler = typeInfo.getCollectionHandler();
    }

    public FieldHandlerImpl(Field field, TypeInfo typeInfo) throws MappingException {
        if (field.getModifiers() != 1 && field.getModifiers() != 65) {
            throw new MappingException("mapping.fieldNotAccessible", field.getName(), field.getDeclaringClass().getName());
        }
        this._handler = null;
        this._field = field;
        this._fieldType = Types.typeFromPrimitive(typeInfo.getFieldType());
        this._fieldName = field.getName() + "(" + this._fieldType.getName() + ")";
        this._immutable = typeInfo.isImmutable();
        this._required = typeInfo.isRequired();
        this._default = this._field.getType().isPrimitive() ? typeInfo.getDefaultValue() : null;
        this._convertTo = typeInfo.getConvertorTo();
        this._convertFrom = typeInfo.getConvertorFrom();
        this._convertParam = typeInfo.getConvertorParam();
        this._colHandler = typeInfo.getCollectionHandler();
    }

    public FieldHandlerImpl(String string, Method[] methodArray, Method[] methodArray2, Method method, Method method2, TypeInfo typeInfo) throws MappingException {
        this._handler = null;
        this._field = null;
        if (string == null) {
            throw new IllegalArgumentException("Argument 'fieldName' is null");
        }
        this._getSequence = methodArray;
        this._setSequence = methodArray2;
        if (method2 != null) {
            if (method2.getName().startsWith(ADD_PREFIX)) {
                Class<?> clazz = method2.getParameterTypes()[0];
                if (clazz != typeInfo.getFieldType()) {
                    this.setAddMethod(method2);
                } else {
                    this.setWriteMethod(method2);
                }
            } else {
                this.setWriteMethod(method2);
            }
        }
        if (method != null) {
            this.setReadMethod(method);
        }
        this._fieldType = Types.typeFromPrimitive(typeInfo.getFieldType());
        this._fieldName = string + "(" + this._fieldType.getName() + ")";
        this._immutable = typeInfo.isImmutable();
        this._required = typeInfo.isRequired();
        this._default = method2 != null && method2.getParameterTypes()[0].isPrimitive() ? typeInfo.getDefaultValue() : null;
        this._convertTo = typeInfo.getConvertorTo();
        this._convertFrom = typeInfo.getConvertorFrom();
        this._convertParam = typeInfo.getConvertorParam();
        this._colHandler = typeInfo.getCollectionHandler();
    }

    public TypeConvertor getConvertFrom() {
        return this._convertFrom;
    }

    public TypeConvertor getConvertTo() {
        return this._convertTo;
    }

    public String getConvertParam() {
        return this._convertParam;
    }

    public Object getValue(Object object) {
        Object object2;
        try {
            if (this._handler != null) {
                object2 = this._handler.getValue(object);
            } else if (this._field != null) {
                object2 = this._field.get(object);
            } else if (this._getMethod != null) {
                if (this._getSequence != null) {
                    int n = 0;
                    while (n < this._getSequence.length) {
                        if ((object = this._getSequence[n].invoke(object, null)) == null) break;
                        ++n;
                    }
                }
                object2 = object == null || this._hasMethod != null && !((Boolean)this._hasMethod.invoke(object, null)).booleanValue() ? null : this._getMethod.invoke(object, null);
            } else {
                object2 = null;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(Messages.format("mapping.schemaChangeInvocation", this.toString(), invocationTargetException));
        }
        if (this._colHandler != null && this._convertFrom == null) {
            if (object2 == null) {
                return new CollectionHandlers.EmptyEnumerator();
            }
            return this._colHandler.elements(object2);
        }
        if (this._convertFrom == null || object2 == null) {
            return object2;
        }
        try {
            return this._convertFrom.convert(object2, this._convertParam);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(Messages.format("mapping.wrongConvertor", object2.getClass().getName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object object, Object object2) {
        if (this._colHandler == null || this._addMethod != null) {
            if (object2 != null && this._convertTo != null) {
                try {
                    object2 = this._convertTo.convert(object2, this._convertParam);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException(Messages.format("mapping.wrongConvertor", object2.getClass().getName()));
                }
            }
            try {
                if (this._handler != null) {
                    this._handler.setValue(object, object2);
                    return;
                }
                if (this._field != null) {
                    this._field.set(object, object2 == null ? this._default : object2);
                    return;
                }
                Method method = this.selectWriteMethod(object2);
                if (method == null) return;
                if (this._getSequence != null) {
                    int n = 0;
                    while (n < this._getSequence.length) {
                        Object object3 = object;
                        if ((object = this._getSequence[n].invoke(object, null)) == null) {
                            if (object2 == null || this._setSequence[n] == null) break;
                            object = Types.newInstance(this._getSequence[n].getReturnType());
                            this._setSequence[n].invoke(object3, object);
                        }
                        ++n;
                    }
                }
                if (object == null) return;
                if (object2 == null && this._deleteMethod != null) {
                    this._deleteMethod.invoke(object, null);
                    return;
                }
                method.invoke(object, object2 == null ? this._default : object2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (object2 != null) throw new IllegalArgumentException(Messages.format("mapping.typeConversion", this.toString(), object2.getClass().getName()));
                throw new IllegalArgumentException(Messages.format("mapping.typeConversionNull", this.toString()));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MappingRuntimeException(invocationTargetException.getTargetException());
            }
        }
        if (object2 == null) return;
        try {
            Class<?> clazz;
            if (this._handler != null) {
                Object object4 = this._handler.getValue(object);
                if ((object4 = this._colHandler.add(object4, object2)) == null) return;
                this._handler.setValue(object, object4);
                return;
            }
            if (this._field != null) {
                Class<?> clazz2;
                Object object5 = this._field.get(object);
                if (object5 == null && (clazz2 = this._field.getType()).isArray()) {
                    Class<?> clazz3 = clazz2.getComponentType();
                    Class<?> clazz4 = object2.getClass();
                    if (clazz3.isPrimitive() || !clazz4.isArray() && clazz4 != clazz3) {
                        try {
                            object5 = Array.newInstance(clazz3, 0);
                        }
                        catch (Exception exception) {
                            String string = "Unable to instantiate an array of '" + clazz3 + "' : " + exception;
                            throw new IllegalStateException(string);
                        }
                    }
                }
                if ((object5 = this._colHandler.add(object5, object2)) == null) return;
                this._field.set(object, object5);
                return;
            }
            if (this._getMethod == null) return;
            if (this._getSequence != null) {
                int n = 0;
                while (n < this._getSequence.length) {
                    object = this._getSequence[n].invoke(object, null);
                    ++n;
                }
            }
            Object object6 = this._getMethod.invoke(object, null);
            boolean bl = false;
            if (object6 == null) {
                clazz = this._getMethod.getReturnType();
                if (clazz.isArray()) {
                    Class<?> clazz5 = clazz.getComponentType();
                    Class<?> clazz6 = object2.getClass();
                    if (clazz5.isPrimitive() || !clazz6.isArray() && clazz6 != clazz5) {
                        try {
                            object6 = Array.newInstance(clazz5, 0);
                        }
                        catch (Exception exception) {
                            String string = "Unable to instantiate an array of '" + clazz5 + "' : " + exception;
                            throw new IllegalStateException(string);
                        }
                    }
                }
                bl = true;
            } else {
                bl = object6.getClass().isArray();
            }
            clazz = this._colHandler.add(object6, object2);
            if (clazz != null) {
                object6 = clazz;
            }
            if (!bl || this._setMethod == null) return;
            this._setMethod.invoke(object, object6);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MappingRuntimeException(invocationTargetException.getTargetException());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetValue(Object object) {
        if (this._colHandler == null) {
            try {
                if (this._handler != null) {
                    this._handler.resetValue(object);
                    return;
                }
                if (this._field != null) {
                    this._field.set(object, this._default);
                    return;
                }
                if (this._setMethod == null) return;
                if (this._getSequence != null) {
                    int n = 0;
                    while (n < this._getSequence.length) {
                        if ((object = this._getSequence[n].invoke(object, null)) == null) break;
                        ++n;
                    }
                }
                if (object == null) return;
                if (this._deleteMethod != null) {
                    this._deleteMethod.invoke(object, null);
                    return;
                }
                this._setMethod.invoke(object, this._default);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(Messages.format("mapping.typeConversionNull", this.toString()));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MappingRuntimeException(invocationTargetException.getTargetException());
            }
        }
        try {
            if (this._handler != null) {
                this._handler.resetValue(object);
                return;
            } else if (this._field != null) {
                Object object2 = this._field.get(object);
                if ((object2 = this._colHandler.clear(object2)) == null) return;
                this._field.set(object, object2);
                return;
            } else {
                if (this._getMethod == null) return;
                if (this._getSequence != null) {
                    int n = 0;
                    while (n < this._getSequence.length) {
                        object = this._getSequence[n].invoke(object, null);
                        ++n;
                    }
                }
                Object object3 = this._getMethod.invoke(object, null);
                if ((object3 = this._colHandler.clear(object3)) == null || this._setMethod == null) return;
                this._setMethod.invoke(object, object3);
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MappingRuntimeException(invocationTargetException.getTargetException());
        }
    }

    public void checkValidity(Object object) throws ValidityException {
    }

    public Object newInstance(Object object) throws IllegalStateException {
        if (this._fieldType.isInterface() && this._createMethod == null) {
            return null;
        }
        if (this._immutable) {
            throw new IllegalStateException(Messages.format("mapping.classNotConstructable", this._fieldType));
        }
        if (this._handler != null) {
            return this._handler.newInstance(object);
        }
        if (this._createMethod != null && object != null) {
            try {
                return this._createMethod.invoke(object, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MappingRuntimeException(invocationTargetException.getTargetException());
            }
        }
        return Types.newInstance(this._fieldType);
    }

    void setRequired(boolean bl) {
        this._required = bl;
    }

    public void setConvertFrom(TypeConvertor typeConvertor) {
        this._convertFrom = typeConvertor;
    }

    public void setConvertTo(TypeConvertor typeConvertor) {
        this._convertTo = typeConvertor;
    }

    public void setCreateMethod(Method method) throws MappingException {
        if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
            throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
        }
        if (method.getParameterTypes().length != 0) {
            throw new MappingException("mapping.createMethodNoParam", method, method.getDeclaringClass().getName());
        }
        this._createMethod = method;
    }

    public void setHasDeleteMethod(Method method, Method method2) throws MappingException {
        if (method != null) {
            if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
                throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
            }
            if (method.getParameterTypes().length != 0) {
                throw new MappingException("mapping.createMethodNoParam", method, method.getDeclaringClass().getName());
            }
            this._hasMethod = method;
        }
        if (method2 != null) {
            if ((method2.getModifiers() & 1) == 0 || (method2.getModifiers() & 8) != 0) {
                throw new MappingException("mapping.accessorNotAccessible", method2, method2.getDeclaringClass().getName());
            }
            if (method2.getParameterTypes().length != 0) {
                throw new MappingException("mapping.createMethodNoParam", method2, method2.getDeclaringClass().getName());
            }
            this._deleteMethod = method2;
        }
    }

    public void setReadMethod(Method method) throws MappingException {
        if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
            throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
        }
        if (method.getParameterTypes().length != 0) {
            throw new MappingException("mapping.readMethodHasParam", method, method.getDeclaringClass().getName());
        }
        this._getMethod = method;
    }

    public void setWriteMethod(Method method) throws MappingException {
        if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
            throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
        }
        if (method.getParameterTypes().length != 1) {
            throw new MappingException("mapping.writeMethodNoParam", method, method.getDeclaringClass().getName());
        }
        this._setMethod = method;
    }

    public void setAddMethod(Method method) throws MappingException {
        if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
            throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
        }
        if (method.getParameterTypes().length != 1) {
            throw new MappingException("mapping.writeMethodNoParam", method, method.getDeclaringClass().getName());
        }
        this._addMethod = method;
        if (this._addMethod == this._setMethod) {
            this._setMethod = null;
        }
    }

    private Method selectWriteMethod(Object object) {
        Object var2_2 = null;
        if (this._setMethod != null) {
            Class<?> clazz;
            if (this._addMethod == null) {
                return this._setMethod;
            }
            if (object == null) {
                if (this._default != null) {
                    object = this._default;
                } else {
                    return this._setMethod;
                }
            }
            if ((clazz = this._setMethod.getParameterTypes()[0]).isAssignableFrom(object.getClass())) {
                return this._setMethod;
            }
        }
        return this._addMethod;
    }

    public boolean isCollection() {
        return this._colHandler != null;
    }

    public String toString() {
        return this._fieldName;
    }
}

