/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.util.DefaultNaming;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class Configuration {
    static final String TRUE_VALUE = "true";
    static final String ON_VALUE = "on";
    private static Properties _jarProps = null;
    private static Properties _defaultProps;
    private static ConfigValues _defaultValues;
    static /* synthetic */ Class class$org$exolab$castor$util$Configuration;

    Configuration() {
    }

    public boolean debug() {
        return Configuration.getDefaultDebug();
    }

    public static boolean getDefaultDebug() {
        Configuration.getDefault();
        return Configuration._defaultValues.debug;
    }

    public boolean strictElements() {
        return Configuration.getDefaultStrictElements();
    }

    public static boolean getDefaultStrictElements() {
        Configuration.getDefault();
        return Configuration._defaultValues.strictElements;
    }

    public boolean marshallingValidation() {
        return Configuration.getDefaultMarshallingValidation();
    }

    public static boolean getDefaultMarshallingValidation() {
        Configuration.getDefault();
        return Configuration._defaultValues.marshallingValidation;
    }

    public Properties getProperties() {
        return Configuration.getDefault();
    }

    public static synchronized Properties getDefault() {
        if (_defaultProps == null) {
            Configuration.loadDefaults();
        }
        return _defaultProps;
    }

    public String getProperty(String string, String string2) {
        return this.getProperties().getProperty(string, string2);
    }

    public static String getDefaultProperty(String string, String string2) {
        return Configuration.getDefault().getProperty(string, string2);
    }

    public XMLNaming getXMLNaming() {
        return Configuration.getDefaultXMLNaming();
    }

    public static XMLNaming getDefaultXMLNaming() {
        if (Configuration._defaultValues.naming != null) {
            return Configuration._defaultValues.naming;
        }
        String string = Configuration.getDefaultProperty("org.exolab.castor.xml.naming", null);
        if (string == null || string.equalsIgnoreCase("lower")) {
            Configuration._defaultValues.naming = new DefaultNaming();
        } else if (string.equalsIgnoreCase("mixed")) {
            DefaultNaming defaultNaming = new DefaultNaming();
            defaultNaming.setStyle((short)1);
            Configuration._defaultValues.naming = defaultNaming;
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                Configuration._defaultValues.naming = (XMLNaming)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to load XMLNaming: " + exception);
            }
        }
        return Configuration._defaultValues.naming;
    }

    public Parser getParser() {
        return Configuration.getDefaultParser();
    }

    public static Parser getDefaultParser() {
        return Configuration.getDefaultParser(null);
    }

    public static Parser getDefaultParser(String string) {
        Parser parser;
        Object object;
        String string2 = Configuration.getDefault().getProperty("org.exolab.castor.parser");
        if (string2 == null || string2.equalsIgnoreCase("xerces")) {
            string2 = "org.apache.xerces.parsers.SAXParser";
        }
        try {
            object = Class.forName(string2);
            parser = (Parser)((Class)object).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateParser", string2, exception));
        }
        if (parser instanceof XMLReader) {
            string2 = Configuration.getDefault().getProperty("org.exolab.castor.parser.validation", "false");
            boolean bl = string2.equalsIgnoreCase(TRUE_VALUE) || string2.equalsIgnoreCase(ON_VALUE);
            try {
                ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/validation", bl);
            }
            catch (SAXException sAXException) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", sAXException));
            }
            string2 = Configuration.getDefault().getProperty("org.exolab.castor.parser.namespaces", "false");
            bl = string2.equalsIgnoreCase(TRUE_VALUE) || string2.equalsIgnoreCase(ON_VALUE);
            try {
                ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/namespaces", bl);
            }
            catch (SAXException sAXException) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", sAXException));
            }
            string = Configuration.getDefault().getProperty("org.exolab.castor.sax.features", string);
            if (string != null) {
                object = new StringTokenizer(string, ", ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        ((XMLReader)((Object)parser)).setFeature(((StringTokenizer)object).nextToken(), true);
                    }
                    catch (SAXException sAXException) {
                        Logger.getSystemLogger().println(Messages.format("conf.configurationError", sAXException));
                    }
                }
            }
        }
        return parser;
    }

    public NodeType getPrimitiveNodeType() {
        return Configuration.getDefaultPrimitiveNodeType();
    }

    public static NodeType getDefaultPrimitiveNodeType() {
        if (Configuration._defaultValues.primitiveNodeType != null) {
            return Configuration._defaultValues.primitiveNodeType;
        }
        String string = Configuration.getDefaultProperty("org.exolab.castor.xml.introspector.primitive.nodetype", null);
        if (string == null) {
            return null;
        }
        Configuration._defaultValues.primitiveNodeType = NodeType.getNodeType(string);
        return Configuration._defaultValues.primitiveNodeType;
    }

    public RegExpEvaluator getRegExpEvaluator() {
        return Configuration.getDefaultRegExpEvaluator();
    }

    public static RegExpEvaluator getDefaultRegExpEvaluator() {
        String string = Configuration.getDefault().getProperty("org.exolab.castor.regexp");
        RegExpEvaluator regExpEvaluator = null;
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = Configuration._defaultValues.regExpEvalClass;
            if (clazz == null) {
                clazz = Class.forName(string);
            }
            regExpEvaluator = (RegExpEvaluator)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateRegExp", string, exception));
        }
        return regExpEvaluator;
    }

    public abstract Serializer getSerializer();

    public static Serializer getDefaultSerializer() {
        Serializer serializer;
        String string = Configuration.getDefault().getProperty("org.exolab.castor.serializer");
        if (string == null || string.equalsIgnoreCase("xerces")) {
            serializer = new XMLSerializer();
        } else {
            try {
                serializer = (Serializer)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(Messages.format("conf.failedInstantiateSerializer", string, exception));
            }
        }
        serializer.setOutputFormat(Configuration.getDefaultOutputFormat());
        return serializer;
    }

    public abstract OutputFormat getOutputFormat();

    public static OutputFormat getDefaultOutputFormat() {
        boolean bl = false;
        String string = Configuration.getDefault().getProperty("org.exolab.castor.indent", "");
        bl = string.equalsIgnoreCase(TRUE_VALUE) || string.equalsIgnoreCase(ON_VALUE);
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setMethod("xml");
        outputFormat.setIndenting(bl);
        if (!bl) {
            outputFormat.setPreserveSpace(true);
        }
        return outputFormat;
    }

    public abstract DocumentHandler getSerializer(OutputStream var1) throws IOException;

    public static DocumentHandler getDefaultSerializer(OutputStream outputStream) throws IOException {
        Serializer serializer = Configuration.getDefaultSerializer();
        serializer.setOutputByteStream(outputStream);
        DocumentHandler documentHandler = serializer.asDocumentHandler();
        if (documentHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return documentHandler;
    }

    public abstract DocumentHandler getSerializer(Writer var1) throws IOException;

    public static DocumentHandler getDefaultSerializer(Writer writer) throws IOException {
        Serializer serializer = Configuration.getDefaultSerializer();
        serializer.setOutputCharStream(writer);
        DocumentHandler documentHandler = serializer.asDocumentHandler();
        if (documentHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return documentHandler;
    }

    protected static void loadDefaults() {
        _defaultProps = Configuration.loadProperties("/org/exolab/castor/castor.properties", "castor.properties");
        String string = _defaultProps.getProperty("org.exolab.castor.debug", "");
        if (string.equalsIgnoreCase(TRUE_VALUE) || string.equalsIgnoreCase(ON_VALUE)) {
            Configuration._defaultValues.debug = true;
        }
        if ((string = _defaultProps.getProperty("org.exolab.castor.marshalling.validation", "")).equalsIgnoreCase("false") || string.equalsIgnoreCase("off")) {
            Configuration._defaultValues.marshallingValidation = false;
        }
        Configuration._defaultValues.strictElements = !(string = _defaultProps.getProperty("org.exolab.castor.xml.strictelements", "")).equalsIgnoreCase("false") && !string.equalsIgnoreCase("off");
        string = _defaultProps.getProperty("org.exolab.castor.xml.JavaNaming.upperCaseAfterUnderscore", null);
        if (string != null) {
            JavaNaming.upperCaseAfterUnderscore = Boolean.valueOf(string);
        }
        string = null;
    }

    public static Properties loadProperties(String string, String string2) {
        Properties properties = new Properties();
        boolean bl = false;
        try {
            properties.load((class$org$exolab$castor$util$Configuration == null ? (class$org$exolab$castor$util$Configuration = Configuration.class$("org.exolab.castor.util.Configuration")) : class$org$exolab$castor$util$Configuration).getResourceAsStream(string));
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = null;
        try {
            string3 = System.getProperty("java.home");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            try {
                File file = new File(string3, "lib");
                file = new File(file, string2);
                if (file.exists()) {
                    properties = new Properties(properties);
                    properties.load(new FileInputStream(file));
                    bl = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl) {
            throw new RuntimeException(Messages.format("conf.noDefaultConfigurationFile", string2));
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _defaultValues = new ConfigValues();
    }

    static class ConfigValues {
        boolean debug = false;
        boolean strictElements = false;
        boolean marshallingValidation = true;
        XMLNaming naming = null;
        NodeType primitiveNodeType = null;
        Class regExpEvalClass = null;

        ConfigValues() {
        }
    }

    static class Features {
        public static final String Validation = "http://xml.org/sax/features/validation";
        public static final String Namespaces = "http://xml.org/sax/features/namespaces";

        Features() {
        }
    }

    public static class Property {
        public static final String Serializer = "org.exolab.castor.serializer";
        public static final String PrimitiveNodeType = "org.exolab.castor.xml.introspector.primitive.nodetype";
        public static final String Parser = "org.exolab.castor.parser";
        public static final String ParserValidation = "org.exolab.castor.parser.validation";
        public static final String Namespaces = "org.exolab.castor.parser.namespaces";
        public static final String Naming = "org.exolab.castor.xml.naming";
        public static final String MarshallingValidation = "org.exolab.castor.marshalling.validation";
        public static final String Indent = "org.exolab.castor.indent";
        public static final String ParserFeatures = "org.exolab.castor.sax.features";
        public static final String ParserFeatureSeparator = ",";
        public static final String RegExp = "org.exolab.castor.regexp";
        public static final String Debug = "org.exolab.castor.debug";
        public static final String StrictElements = "org.exolab.castor.xml.strictelements";
        public static final String FileName = "castor.properties";
        static final String ResourceName = "/org/exolab/castor/castor.properties";
    }
}

