/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.ScopableResolver;
import org.exolab.castor.xml.schema.Wildcard;

class ContentModelGroupImpl
implements ContentModelGroup,
Serializable {
    private Vector _contentModel = new Vector();
    private transient ScopableResolver _resolver = new ScopableResolver();

    public void addWildcard(Wildcard wildcard) throws SchemaException {
        if (wildcard.isAttributeWildcard()) {
            throw new SchemaException("only <any> should be add in a group.");
        }
        this._contentModel.addElement(wildcard);
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        if (elementDecl == null) {
            return;
        }
        String string = elementDecl.getName();
        String string2 = "element:" + string;
        if (this._resolver.resolve(string2) != null) {
            String string3 = "An element declaration with the given name, ";
            string3 = string3 + string + ", already exists in this scope.";
            throw new SchemaException(string3);
        }
        this._resolver.addResolvable(string2, elementDecl);
        this._contentModel.addElement(elementDecl);
    }

    public boolean removeElementDecl(ElementDecl elementDecl) {
        if (elementDecl == null) {
            return false;
        }
        int n = this._contentModel.indexOf(elementDecl);
        if (n >= 0) {
            this._contentModel.removeElementAt(n);
            String string = "element:" + elementDecl.getName();
            this._resolver.removeResolvable(string);
            return true;
        }
        return false;
    }

    public void addGroup(Group group) throws SchemaException {
        if (group == null) {
            return;
        }
        String string = group.getName();
        if (string != null) {
            String string2 = "group:" + string;
            if (this._resolver.resolve(string2) != null) {
                String string3 = "An element declaration with the given name, ";
                string3 = string3 + string + ", already exists in this scope.";
                throw new SchemaException(string3);
            }
            this._resolver.addResolvable(string2, group);
        }
        this._contentModel.addElement(group);
    }

    public boolean removeGroup(Group group) {
        if (group == null) {
            return false;
        }
        int n = this._contentModel.indexOf(group);
        if (n >= 0) {
            String string = group.getName();
            if (string != null) {
                String string2 = "group:" + string;
                this._resolver.removeResolvable(string2);
            }
            this._contentModel.removeElementAt(n);
            return true;
        }
        return false;
    }

    public void addGroup(ModelGroup modelGroup) throws SchemaException {
        if (modelGroup == null) {
            return;
        }
        String string = modelGroup.getName();
        if (string != null) {
            String string2 = "group:" + string;
            if (this._resolver.resolve(string2) != null) {
                String string3 = "An element declaration with the given name, ";
                string3 = string3 + string + ", already exists in this scope.";
                throw new SchemaException(string3);
            }
            this._resolver.addResolvable(string2, modelGroup);
        }
        this._contentModel.addElement(modelGroup);
    }

    public boolean removeGroup(ModelGroup modelGroup) {
        if (modelGroup == null) {
            return false;
        }
        int n = this._contentModel.indexOf(modelGroup);
        if (n >= 0) {
            String string = modelGroup.getName();
            if (string != null) {
                String string2 = "group:" + string;
                this._resolver.removeResolvable(string2);
            }
            this._contentModel.removeElementAt(n);
            return true;
        }
        return false;
    }

    public boolean removeWildcard(Wildcard wildcard) {
        if (wildcard == null) {
            return false;
        }
        int n = this._contentModel.indexOf(wildcard);
        if (n >= 0) {
            this._contentModel.removeElementAt(n);
            return true;
        }
        return false;
    }

    public Enumeration enumerate() {
        return this._contentModel.elements();
    }

    public ElementDecl getElementDecl(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        ElementDecl elementDecl = null;
        if (this._resolver != null && (elementDecl = (ElementDecl)this._resolver.resolve(string2 = "element:" + string)) != null) {
            return elementDecl;
        }
        int n = 0;
        while (n < this._contentModel.size()) {
            Particle particle = (Particle)this._contentModel.elementAt(n);
            switch (particle.getStructureType()) {
                case 8: {
                    ElementDecl elementDecl2 = (ElementDecl)particle;
                    if (!string.equals(elementDecl2.getName())) break;
                    elementDecl = elementDecl2;
                    break;
                }
                case 10: 
                case 16: {
                    elementDecl = ((ContentModelGroup)((Object)particle)).getElementDecl(string);
                    break;
                }
            }
            if (elementDecl != null) break;
            ++n;
        }
        return elementDecl;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public int getMinOccurs() {
        return 1;
    }

    public Particle getParticle(int n) {
        return (Particle)this._contentModel.elementAt(n);
    }

    public int getParticleCount() {
        return this._contentModel.size();
    }
}

