/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;

public class ModelGroupUnmarshaller
extends ComponentReader {
    private static final int MODEL_GROUP = 1;
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ModelGroup _group = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;

    public ModelGroupUnmarshaller(Schema schema, AttributeSet attributeSet, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._group = new ModelGroup(this._schema);
        String string = null;
        this._group.setName(attributeSet.getValue("name"));
        string = attributeSet.getValue("maxOccurs");
        if (string != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + "'maxOccurs' cannot appear in a named <group>");
            }
            if (MAX_OCCURS_WILDCARD.equals(string)) {
                string = "-1";
            }
            int n = ComponentReader.toInt(string);
            this._group.setMaxOccurs(n);
        }
        if ((string = attributeSet.getValue("minOccurs")) != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + ", 'minOccurs' cannot appear in a named <group>");
            }
            this._group.setMinOccurs(ComponentReader.toInt(string));
        }
        if ((string = attributeSet.getValue("ref")) != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + ", 'ref' cannot appear in a named <group>");
            }
            this._group.setReference(string);
        }
        string = attributeSet.getValue("id");
        this._group.setId(string);
    }

    public ModelGroup getGroup() {
        return this._group;
    }

    public Object getObject() {
        return this.getGroup();
    }

    public String elementName() {
        return "group";
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) 'annotation' is allowed as a child of element definitions.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else if (SchemaNames.isGroupName(string)) {
            this.unmarshaller = new GroupUnmarshaller(this._schema, string, attributeSet, this.getResolver());
        } else {
            StringBuffer stringBuffer = new StringBuffer("illegal element <");
            stringBuffer.append(string);
            stringBuffer.append("> found in <group>.");
            throw new SchemaException(stringBuffer.toString());
        }
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && !string.equals(this.unmarshaller.elementName())) {
            String string3 = "missing end element for ";
            string3 = string3 + this.unmarshaller.elementName();
            throw new SchemaException(string3);
        }
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._group.addAnnotation(annotation);
        } else if (SchemaNames.isGroupName(string)) {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._group.addGroup(group);
        }
        this.unmarshaller.finish();
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

