/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;
import org.exolab.javasource.JType;

public class JClass
extends JStructure {
    private Vector _constructors = null;
    private JNamedMap _fields = null;
    private Vector _innerClasses = null;
    private Vector _methods = null;
    private String _superClass = null;
    private JSourceCode _staticInitializer = new JSourceCode();

    public JClass(String string) throws IllegalArgumentException {
        super(string);
        this._constructors = new Vector();
        this._fields = new JNamedMap();
        this._methods = new Vector();
        this._innerClasses = new Vector();
        this.getJDocComment().appendComment("Class " + this.getLocalName() + ".");
    }

    public void addConstructor(JConstructor jConstructor) throws IllegalArgumentException {
        if (jConstructor == null) {
            throw new IllegalArgumentException("Constructors cannot be null");
        }
        if (jConstructor.getDeclaringClass() == this) {
            if (!this._constructors.contains(jConstructor)) {
                this._constructors.addElement(jConstructor);
            }
        } else {
            String string = "The given JConstructor was not created ";
            string = string + "by this JClass";
            throw new IllegalArgumentException(string);
        }
    }

    public void addField(JField jField) throws IllegalArgumentException {
        if (jField == null) {
            throw new IllegalArgumentException("Class members cannot be null");
        }
        String string = jField.getName();
        if (this._fields.get(string) != null) {
            String string2 = "duplicate name found: " + string;
            throw new IllegalArgumentException(string2);
        }
        this._fields.put(string, jField);
        JType jType = jField.getType();
        while (jType.isArray()) {
            jType = jType.getComponentType();
        }
        if (!jType.isPrimitive()) {
            this.addImport(((JClass)jType).getName());
        }
    }

    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (jMember instanceof JField) {
            this.addField((JField)jMember);
        } else if (jMember instanceof JMethod) {
            this.addMethod((JMethod)jMember);
        } else {
            String string = null;
            string = jMember == null ? "the argument 'jMember' must not be null." : "Cannot add JMember '" + jMember.getClass().getName() + "' to JClass, unrecognized type.";
            throw new IllegalArgumentException(string);
        }
    }

    public void addMethod(JMethod jMethod) {
        this.addMethod(jMethod, true);
    }

    public void addMethod(JMethod jMethod, boolean bl) throws IllegalArgumentException {
        Object object;
        if (jMethod == null) {
            throw new IllegalArgumentException("Class methods cannot be null");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        JModifiers jModifiers = jMethod.getModifiers();
        if (jModifiers.isAbstract()) {
            this.getModifiers().setAbstract(true);
        }
        int n = 0;
        while (n < this._methods.size()) {
            object = (JMethod)this._methods.elementAt(n);
            if (((JMethod)object).getModifiers().isPrivate() && !jModifiers.isPrivate()) {
                this._methods.insertElementAt(jMethod, n);
                bl2 = true;
                break;
            }
            if (jMethod.getName().compareTo(((JMethod)object).getName()) < 0) {
                this._methods.insertElementAt(jMethod, n);
                bl2 = true;
                break;
            }
            ++n;
        }
        if (!bl2) {
            this._methods.addElement(jMethod);
        }
        object = jMethod.getParameterClassNames();
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            this.addImport((String)object[n2]);
            ++n2;
        }
        JType jType = jMethod.getReturnType();
        if (jType != null) {
            while (jType.isArray()) {
                jType = jType.getComponentType();
            }
            if (bl && !jType.isPrimitive()) {
                this.addImport(((JClass)jType).getName());
            }
        }
        JClass[] jClassArray = jMethod.getExceptions();
        int n3 = 0;
        while (n3 < jClassArray.length) {
            this.addImport(jClassArray[n3].getName());
            ++n3;
        }
    }

    public void addMethods(JMethod[] jMethodArray) throws IllegalArgumentException {
        int n = 0;
        while (n < jMethodArray.length) {
            this.addMethod(jMethodArray[n]);
            ++n;
        }
    }

    public JConstructor createConstructor() {
        return this.createConstructor(null);
    }

    public JConstructor createConstructor(JParameter[] jParameterArray) {
        JConstructor jConstructor = new JConstructor(this);
        if (jParameterArray != null) {
            int n = 0;
            while (n < jParameterArray.length) {
                jConstructor.addParameter(jParameterArray[n]);
                ++n;
            }
        }
        this.addConstructor(jConstructor);
        return jConstructor;
    }

    public JClass createInnerClass(String string) {
        if (string == null) {
            String string2 = "argument 'localname' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        if (string.indexOf(46) >= 0) {
            String string3 = "The name of an inner-class must not contain a package name.";
            throw new IllegalArgumentException(string3);
        }
        String string4 = this.getPackageName();
        string4 = string4 != null ? string4 + "." + string : string;
        JInnerClass jInnerClass = new JInnerClass(string4);
        this._innerClasses.addElement(jInnerClass);
        return jInnerClass;
    }

    public JConstructor getConstructor(int n) {
        return (JConstructor)this._constructors.elementAt(n);
    }

    public JConstructor[] getConstructors() {
        int n = this._constructors.size();
        JConstructor[] jConstructorArray = new JConstructor[n];
        int n2 = 0;
        while (n2 < this._constructors.size()) {
            jConstructorArray[n2] = (JConstructor)this._constructors.elementAt(n2);
            ++n2;
        }
        return jConstructorArray;
    }

    public JField getField(String string) {
        return (JField)this._fields.get(string);
    }

    public JField[] getFields() {
        int n = this._fields.size();
        JField[] jFieldArray = new JField[n];
        int n2 = 0;
        while (n2 < n) {
            jFieldArray[n2] = (JField)this._fields.get(n2);
            ++n2;
        }
        return jFieldArray;
    }

    public JClass[] getInnerClasses() {
        int n = this._innerClasses.size();
        Object[] objectArray = new JClass[n];
        this._innerClasses.copyInto(objectArray);
        return objectArray;
    }

    public JMethod[] getMethods() {
        int n = this._methods.size();
        JMethod[] jMethodArray = new JMethod[n];
        int n2 = 0;
        while (n2 < this._methods.size()) {
            jMethodArray[n2] = (JMethod)this._methods.elementAt(n2);
            ++n2;
        }
        return jMethodArray;
    }

    public JMethod getMethod(String string, int n) {
        int n2 = n;
        while (n2 < this._methods.size()) {
            JMethod jMethod = (JMethod)this._methods.elementAt(n2);
            if (jMethod.getName().equals(string)) {
                return jMethod;
            }
            ++n2;
        }
        return null;
    }

    public JMethod getMethod(int n) {
        return (JMethod)this._methods.elementAt(n);
    }

    public JSourceCode getStaticInitializationCode() {
        return this._staticInitializer;
    }

    public String getSuperClass() {
        return this._superClass;
    }

    public void print(JSourceWriter jSourceWriter) {
        this.print(jSourceWriter, false);
    }

    public void print(JSourceWriter jSourceWriter, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        if (jSourceWriter == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            this.printHeader(jSourceWriter);
            this.printPackageDeclaration(jSourceWriter);
            object5 = null;
            if (this._innerClasses.size() > 0) {
                object5 = new Vector();
                n = 0;
                while (n < this._innerClasses.size()) {
                    object4 = (JClass)this._innerClasses.elementAt(n);
                    object3 = ((JStructure)object4).getImports();
                    while (object3.hasMoreElements()) {
                        object2 = (String)object3.nextElement();
                        if (this.hasImport((String)object2)) continue;
                        this.addImport((String)object2);
                        ((Vector)object5).addElement(object2);
                    }
                    ++n;
                }
            }
            this.printImportDeclarations(jSourceWriter);
            if (object5 != null) {
                n = 0;
                while (n < ((Vector)object5).size()) {
                    this.removeImport((String)((Vector)object5).elementAt(n));
                    ++n;
                }
            }
        }
        this.getJDocComment().print(jSourceWriter);
        stringBuffer.setLength(0);
        object5 = this.getModifiers();
        if (((JModifiers)object5).isPrivate()) {
            stringBuffer.append("private ");
        } else if (((JModifiers)object5).isPublic()) {
            stringBuffer.append("public ");
        }
        if (((JModifiers)object5).isAbstract()) {
            stringBuffer.append("abstract ");
        }
        stringBuffer.append("class ");
        stringBuffer.append(this.getLocalName());
        stringBuffer.append(' ');
        if (this._superClass != null) {
            stringBuffer.append("extends ");
            stringBuffer.append(this._superClass);
            stringBuffer.append(' ');
        }
        if (this.getInterfaceCount() > 0) {
            n = 0;
            if (this.getInterfaceCount() > 1 || this._superClass != null) {
                jSourceWriter.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
                n = 1;
            }
            stringBuffer.append("implements ");
            object4 = this.getInterfaces();
            while (object4.hasMoreElements()) {
                stringBuffer.append(object4.nextElement());
                if (!object4.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
            if (n != 0) {
                jSourceWriter.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
            } else {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append('{');
        jSourceWriter.writeln(stringBuffer.toString());
        stringBuffer.setLength(0);
        jSourceWriter.writeln();
        jSourceWriter.indent();
        if (this._fields.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //--------------------------/");
            jSourceWriter.writeln(" //- Class/Member Variables -/");
            jSourceWriter.writeln("//--------------------------/");
            jSourceWriter.writeln();
        }
        n = 0;
        while (n < this._fields.size()) {
            object4 = (JField)this._fields.get(n);
            object3 = ((JField)object4).getComment();
            if (object3 != null) {
                ((JDocComment)object3).print(jSourceWriter);
            }
            jSourceWriter.write(((JField)object4).getModifiers().toString());
            jSourceWriter.write(32);
            object2 = ((JField)object4).getType();
            object = ((JType)object2).toString();
            if (((String)object).equals(this.toString())) {
                object = ((JType)object2).getLocalName();
            }
            jSourceWriter.write((String)object);
            jSourceWriter.write(32);
            jSourceWriter.write(((JField)object4).getName());
            String string = ((JField)object4).getInitString();
            if (string != null) {
                jSourceWriter.write(" = ");
                jSourceWriter.write(string);
            }
            jSourceWriter.writeln(';');
            jSourceWriter.writeln();
            ++n;
        }
        if (!this._staticInitializer.isEmpty()) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("static {");
            jSourceWriter.writeln(this._staticInitializer.toString());
            jSourceWriter.writeln("};");
            jSourceWriter.writeln();
        }
        if (this._constructors.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //----------------/");
            jSourceWriter.writeln(" //- Constructors -/");
            jSourceWriter.writeln("//----------------/");
            jSourceWriter.writeln();
        }
        int n2 = 0;
        while (n2 < this._constructors.size()) {
            object3 = (JConstructor)this._constructors.elementAt(n2);
            ((JConstructor)object3).print(jSourceWriter);
            jSourceWriter.writeln();
            ++n2;
        }
        if (this._methods.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //-----------/");
            jSourceWriter.writeln(" //- Methods -/");
            jSourceWriter.writeln("//-----------/");
            jSourceWriter.writeln();
        }
        int n3 = 0;
        while (n3 < this._methods.size()) {
            object2 = (JMethod)this._methods.elementAt(n3);
            ((JMethod)object2).print(jSourceWriter);
            jSourceWriter.writeln();
            ++n3;
        }
        if (this._innerClasses.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //-----------------/");
            jSourceWriter.writeln(" //- Inner Classes -/");
            jSourceWriter.writeln("//-----------------/");
            jSourceWriter.writeln();
        }
        int n4 = 0;
        while (n4 < this._innerClasses.size()) {
            object = (JClass)this._innerClasses.elementAt(n4);
            ((JClass)object).print(jSourceWriter, true);
            jSourceWriter.writeln();
            ++n4;
        }
        jSourceWriter.unindent();
        jSourceWriter.writeln('}');
        jSourceWriter.flush();
    }

    public boolean removeConstructor(JConstructor jConstructor) {
        return this._constructors.removeElement(jConstructor);
    }

    public JField removeField(String string) {
        if (string == null) {
            return null;
        }
        JField jField = (JField)this._fields.remove(string);
        return jField;
    }

    public boolean removeField(JField jField) {
        if (jField == null) {
            return false;
        }
        Object object = this._fields.get(jField.getName());
        if (object == jField) {
            this._fields.remove(jField.getName());
            return true;
        }
        return false;
    }

    public boolean removeInnerClass(JClass jClass) {
        return this._innerClasses.removeElement(jClass);
    }

    public void setSuperClass(String string) {
        this._superClass = string;
    }

    public static void main(String[] stringArray) {
        JClass jClass = new JClass("org.acme.Test");
        jClass.addImport("java.util.Vector");
        jClass.addMember(new JField(JType.Int, "x"));
        JClass jClass2 = new JClass("String");
        JField jField = null;
        jField = new JField(JType.Int, "_z");
        jField.getModifiers().setStatic(true);
        jClass.addField(jField);
        jClass.getStaticInitializationCode().add("_z = 75;");
        jField = new JField(jClass2, "myString");
        jField.getModifiers().makePrivate();
        jClass.addMember(jField);
        JConstructor jConstructor = jClass.createConstructor();
        jConstructor.getSourceCode().add("this.x = 6;");
        JMethod jMethod = new JMethod(JType.Int, "getX");
        jMethod.setSourceCode("return this.x;");
        jClass.addMethod(jMethod);
        JClass jClass3 = jClass.createInnerClass("Foo");
        jClass3.addImport("java.util.Hashtable");
        jClass3.addMember(new JField(JType.Int, "_type"));
        jField = new JField(jClass2, "_name");
        jField.getModifiers().makePrivate();
        jClass3.addMember(jField);
        jConstructor = jClass3.createConstructor();
        jConstructor.getSourceCode().add("_name = \"foo\";");
        jMethod = new JMethod(jClass2, "getName");
        jMethod.setSourceCode("return _name;");
        jClass3.addMethod(jMethod);
        jClass.print();
    }

    final class JInnerClass
    extends JClass {
        JInnerClass(String string) {
            super(string);
        }

        public void setPackageName(String string) {
            throw new IllegalStateException("Cannot change the package of an inner-class");
        }
    }
}

