/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethodSignature;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;
import org.exolab.javasource.JType;

public final class JInterface
extends JStructure {
    private JNamedMap fields = null;
    private Vector methods = new Vector();

    public JInterface(String string) throws IllegalArgumentException {
        super(string);
        this.getJDocComment().appendComment("Interface " + this.getLocalName() + ".");
    }

    public void addField(JField jField) throws IllegalArgumentException {
        if (jField == null) {
            throw new IllegalArgumentException("argument 'jField' cannot be null");
        }
        String string = jField.getName();
        if (this.fields != null && this.fields.get(string) != null) {
            String string2 = "duplicate name found: " + string;
            throw new IllegalArgumentException(string2);
        }
        JModifiers jModifiers = jField.getModifiers();
        if (!jModifiers.isStatic()) {
            throw new IllegalArgumentException("Fields added to a JInterface must be static.");
        }
        if (jModifiers.isPrivate()) {
            throw new IllegalArgumentException("Fields added to a JInterface must not be private.");
        }
        if (this.fields == null) {
            this.fields = new JNamedMap(3);
        }
        this.fields.put(string, jField);
        JType jType = jField.getType();
        while (jType.isArray()) {
            jType = jType.getComponentType();
        }
        if (!jType.isPrimitive()) {
            this.addImport(((JClass)jType).getName());
        }
    }

    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (jMember == null) {
            throw new IllegalArgumentException("argument 'jMember' may not be null.");
        }
        if (!(jMember instanceof JField)) {
            throw new IllegalArgumentException("invalid member for JInterface: " + jMember.toString());
        }
        this.addField((JField)jMember);
    }

    public void addMethod(JMethodSignature jMethodSignature) throws IllegalArgumentException {
        Object object;
        if (jMethodSignature == null) {
            String string = "The JMethodSignature cannot be null.";
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        JModifiers jModifiers = jMethodSignature.getModifiers();
        int n = 0;
        while (n < this.methods.size()) {
            object = (JMethodSignature)this.methods.elementAt(n);
            if (((JMethodSignature)object).getModifiers().isProtected() && !jModifiers.isProtected()) {
                this.methods.insertElementAt(jMethodSignature, n);
                bl = true;
                break;
            }
            if (jMethodSignature.getName().compareTo(((JMethodSignature)object).getName()) < 0) {
                this.methods.insertElementAt(jMethodSignature, n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.methods.addElement(jMethodSignature);
        }
        object = jMethodSignature.getParameterClassNames();
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            this.addImport((String)object[n2]);
            ++n2;
        }
        JType jType = jMethodSignature.getReturnType();
        if (jType != null) {
            while (jType.isArray()) {
                jType = jType.getComponentType();
            }
            if (!jType.isPrimitive()) {
                this.addImport(jType.getName());
            }
        }
        JClass[] jClassArray = jMethodSignature.getExceptions();
        int n3 = 0;
        while (n3 < jClassArray.length) {
            this.addImport(jClassArray[n3].getName());
            ++n3;
        }
    }

    public JField getField(String string) {
        if (this.fields == null) {
            return null;
        }
        return (JField)this.fields.get(string);
    }

    public JField[] getFields() {
        if (this.fields == null) {
            return new JField[0];
        }
        int n = this.fields.size();
        JField[] jFieldArray = new JField[n];
        int n2 = 0;
        while (n2 < n) {
            jFieldArray[n2] = (JField)this.fields.get(n2);
            ++n2;
        }
        return jFieldArray;
    }

    public JMethodSignature[] getMethods() {
        Object[] objectArray = new JMethodSignature[this.methods.size()];
        this.methods.copyInto(objectArray);
        return objectArray;
    }

    public JMethodSignature getMethod(String string, int n) {
        int n2 = n;
        while (n2 < this.methods.size()) {
            JMethodSignature jMethodSignature = (JMethodSignature)this.methods.elementAt(n2);
            if (jMethodSignature.getName().equals(string)) {
                return jMethodSignature;
            }
            ++n2;
        }
        return null;
    }

    public JMethodSignature getMethod(int n) {
        return (JMethodSignature)this.methods.elementAt(n);
    }

    public void print(JSourceWriter jSourceWriter) {
        this.print(jSourceWriter, false);
    }

    public void print(JSourceWriter jSourceWriter, boolean bl) {
        if (jSourceWriter == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            this.printHeader(jSourceWriter);
            this.printPackageDeclaration(jSourceWriter);
            this.printImportDeclarations(jSourceWriter);
        }
        this.getJDocComment().print(jSourceWriter);
        stringBuffer.setLength(0);
        JModifiers jModifiers = this.getModifiers();
        if (jModifiers.isPrivate()) {
            stringBuffer.append("private ");
        } else if (jModifiers.isPublic()) {
            stringBuffer.append("public ");
        }
        if (jModifiers.isAbstract()) {
            stringBuffer.append("abstract ");
        }
        stringBuffer.append("interface ");
        stringBuffer.append(this.getLocalName());
        stringBuffer.append(' ');
        if (this.getInterfaceCount() > 0) {
            Enumeration enumeration = this.getInterfaces();
            boolean bl2 = false;
            if (this.getInterfaceCount() > 1) {
                jSourceWriter.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
                bl2 = true;
            }
            stringBuffer.append("extends ");
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
            if (bl2) {
                jSourceWriter.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
            } else {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append('{');
        jSourceWriter.writeln(stringBuffer.toString());
        stringBuffer.setLength(0);
        jSourceWriter.writeln();
        jSourceWriter.indent();
        if (this.fields != null) {
            if (this.fields.size() > 0) {
                jSourceWriter.writeln();
                jSourceWriter.writeln("  //--------------------------/");
                jSourceWriter.writeln(" //- Class/Member Variables -/");
                jSourceWriter.writeln("//--------------------------/");
                jSourceWriter.writeln();
            }
            int n = 0;
            while (n < this.fields.size()) {
                JField jField = (JField)this.fields.get(n);
                JDocComment jDocComment = jField.getComment();
                if (jDocComment != null) {
                    jDocComment.print(jSourceWriter);
                }
                jSourceWriter.write(jField.getModifiers().toString());
                jSourceWriter.write(32);
                JType jType = jField.getType();
                String string = jType.toString();
                if (string.equals(this.toString())) {
                    string = jType.getLocalName();
                }
                jSourceWriter.write(string);
                jSourceWriter.write(32);
                jSourceWriter.write(jField.getName());
                String string2 = jField.getInitString();
                if (string2 != null) {
                    jSourceWriter.write(" = ");
                    jSourceWriter.write(string2);
                }
                jSourceWriter.writeln(';');
                jSourceWriter.writeln();
                ++n;
            }
        }
        if (this.methods.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //-----------/");
            jSourceWriter.writeln(" //- Methods -/");
            jSourceWriter.writeln("//-----------/");
            jSourceWriter.writeln();
        }
        int n = 0;
        while (n < this.methods.size()) {
            JMethodSignature jMethodSignature = (JMethodSignature)this.methods.elementAt(n);
            jMethodSignature.print(jSourceWriter);
            jSourceWriter.writeln(';');
            ++n;
        }
        jSourceWriter.unindent();
        jSourceWriter.writeln('}');
        jSourceWriter.flush();
        jSourceWriter.close();
    }
}

