/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethodSignature;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JMethod
implements JMember {
    private Vector _classes = null;
    private JDocComment jdc = null;
    private JSourceCode source = null;
    private JMethodSignature _signature = null;

    public JMethod(String string) {
        this(null, string);
    }

    public JMethod(JType jType, String string) {
        if (string == null || string.length() == 0) {
            String string2 = "The method name must not be null or zero-length";
            throw new IllegalArgumentException(string2);
        }
        this._classes = new Vector(1);
        this.source = new JSourceCode();
        this._signature = new JMethodSignature(string, jType);
        this.jdc = this._signature.getJDocComment();
        this.jdc.appendComment("Method " + string);
    }

    public void addException(JClass jClass) {
        this._signature.addException(jClass);
    }

    public void addParameter(JParameter jParameter) throws IllegalArgumentException {
        this._signature.addParameter(jParameter);
        JType jType = jParameter.getType();
        while (jType.isArray()) {
            jType = jType.getComponentType();
        }
        if (!jType.isPrimitive()) {
            JClass jClass = (JClass)jType;
            int n = 0;
            while (n < this._classes.size()) {
                ((JClass)this._classes.elementAt(n)).addImport(jClass.getName());
                ++n;
            }
        }
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JClass[] getExceptions() {
        return this._signature.getExceptions();
    }

    public JModifiers getModifiers() {
        return this._signature.getModifiers();
    }

    public String getName() {
        return this._signature.getName();
    }

    public JParameter getParameter(int n) {
        return this._signature.getParameter(n);
    }

    public JParameter[] getParameters() {
        return this._signature.getParameters();
    }

    public JType getReturnType() {
        return this._signature.getReturnType();
    }

    public JMethodSignature getSignature() {
        return this._signature;
    }

    public JSourceCode getSourceCode() {
        return this.source;
    }

    public void setComment(String string) {
        this.jdc.setComment(string);
    }

    public void setModifiers(JModifiers jModifiers) {
        this._signature.setModifiers(jModifiers);
    }

    public void setSourceCode(String string) {
        this.source = new JSourceCode(string);
    }

    public void setSourceCode(JSourceCode jSourceCode) {
        this.source = jSourceCode;
    }

    public void print(JSourceWriter jSourceWriter) {
        this.jdc.print(jSourceWriter);
        this._signature.print(jSourceWriter, false);
        if (this._signature.getModifiers().isAbstract()) {
            jSourceWriter.writeln(";");
        } else {
            jSourceWriter.writeln();
            jSourceWriter.writeln("{");
            this.source.print(jSourceWriter);
            jSourceWriter.write("} //-- ");
            jSourceWriter.writeln(this.toString());
        }
    }

    public String toString() {
        return this._signature.toString();
    }

    protected void addDeclaringClass(JClass jClass) {
        this._classes.addElement(jClass);
    }

    protected void removeDeclaringClass(JClass jClass) {
        this._classes.removeElement(jClass);
    }

    protected String[] getParameterClassNames() {
        return this._signature.getParameterClassNames();
    }
}

