/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.Selector;

public abstract class IdentityConstraint {
    public static final short UNIQUE = 0;
    public static final short KEY = 1;
    public static final short KEYREF = 2;
    protected String fIdentityConstraintName;
    protected String fElementName;
    protected Selector fSelector;
    protected int fFieldCount;
    protected Field[] fFields;

    protected IdentityConstraint(String string, String string2) {
        this.fIdentityConstraintName = string;
        this.fElementName = string2;
    }

    public void addField(Field field) {
        try {
            this.fFields[this.fFieldCount] = null;
        }
        catch (NullPointerException nullPointerException) {
            this.fFields = new Field[4];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Field[] fieldArray = new Field[this.fFields.length * 2];
            System.arraycopy(this.fFields, 0, fieldArray, 0, this.fFields.length);
            this.fFields = fieldArray;
        }
        this.fFields[this.fFieldCount++] = field;
    }

    public String getElementName() {
        return this.fElementName;
    }

    public Field getFieldAt(int n) {
        return this.fFields[n];
    }

    public int getFieldCount() {
        return this.fFieldCount;
    }

    public String getIdentityConstraintName() {
        return this.fIdentityConstraintName;
    }

    public Selector getSelector() {
        return this.fSelector;
    }

    public abstract short getType();

    public void setSelector(Selector selector) {
        this.fSelector = selector;
    }

    public String toString() {
        String string = super.toString();
        int n = string.lastIndexOf(36);
        if (n != -1) {
            return string.substring(n + 1);
        }
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }
}

