/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.event.KeyEvent;

class KeyNavEventHandler
extends ZFilteredEventHandler {
    ImagePane imagePane;
    ZCanvas canvas;
    boolean spaceBarDown = false;

    public KeyNavEventHandler(ImagePane imagePane, ZSceneGraphObject zSceneGraphObject, ZCanvas zCanvas) {
        super(zSceneGraphObject, zCanvas);
        this.imagePane = imagePane;
        this.canvas = zCanvas;
    }

    public void filteredMousePressed(ZMouseEvent zMouseEvent) {
        this.canvas.requestFocus();
    }

    public void filteredKeyPressed(KeyEvent keyEvent) {
        PhotoMesa photoMesa = this.imagePane.photomesa;
        int n = keyEvent.getKeyCode();
        block0 : switch (n) {
            case 10: {
                this.imagePane.stopPreview();
                if (this.imagePane.hiresImageLoaded) {
                    ZBounds zBounds = this.imagePane.hiresImageItem.getThumb().getGlobalBounds();
                    ZBounds zBounds2 = this.imagePane.getCamera().getViewBounds();
                    double d = this.imagePane.hiresImageItem.imageWidth;
                    double d2 = this.imagePane.hiresImageItem.imageHeight;
                    double d3 = this.imagePane.getCamera().getBoundsReference().getWidth();
                    double d4 = this.imagePane.getCamera().getBoundsReference().getHeight();
                    if (zBounds2.getWidth() >= zBounds.getWidth() && zBounds2.getHeight() >= zBounds.getHeight()) {
                        this.imagePane.unloadHiResImage();
                    }
                }
                this.imagePane.zoomOutStep();
                if (this.imagePane.eventHandlers.getEventMode() == 1) break;
                this.imagePane.eventHandlers.panHandler.getMouseFilter().rejectAllEventTypes();
                break;
            }
            case 32: {
                this.spaceBarDown = true;
                if (this.imagePane.eventHandlers.getEventMode() == 1) break;
                this.imagePane.eventHandlers.panHandler.getMouseFilter().acceptAllEventTypes();
                if (this.imagePane.eventHandlers.prevCursor != null) break;
                this.imagePane.eventHandlers.prevCursor = this.canvas.getCursor();
                this.canvas.setCursor(PhotoMesa.handCursor);
                break;
            }
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (keyEvent.isAltDown()) {
                    if (n == 37) {
                        this.imagePane.historyBack();
                        break;
                    }
                    if (n != 39) break;
                    this.imagePane.historyForward();
                    break;
                }
                switch (n) {
                    case 37: {
                        this.imagePane.goLeft();
                        break block0;
                    }
                    case 39: {
                        this.imagePane.goRight();
                        break block0;
                    }
                    case 33: 
                    case 38: {
                        this.imagePane.goUp();
                        break block0;
                    }
                    case 34: 
                    case 40: {
                        this.imagePane.goDown();
                    }
                }
            }
        }
    }

    public void filteredKeyReleased(KeyEvent keyEvent) {
        PhotoMesa photoMesa = this.imagePane.photomesa;
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 32: {
                this.spaceBarDown = false;
                if (this.imagePane.eventHandlers.getEventMode() == 1 || this.imagePane.eventHandlers.prevCursor == null || this.imagePane.eventHandlers.isDragging()) break;
                this.imagePane.eventHandlers.panHandler.getMouseFilter().rejectAllEventTypes();
                this.canvas.setCursor(this.imagePane.eventHandlers.prevCursor);
                this.imagePane.eventHandlers.prevCursor = null;
            }
        }
    }

    boolean isSpaceBarDown() {
        return this.spaceBarDown;
    }
}

