/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.component.ZImage;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class PMImage
extends ZImage {
    Color penColor = null;
    Stroke stroke = null;
    Rectangle2D border;
    double penWidth;
    ImageItem imageItem = null;
    int width = -1;
    int height = -1;
    static final Color DEFAULT_COLOR = Color.black;

    public PMImage(Image image, ImageItem imageItem) {
        this(image, imageItem, 0);
    }

    public PMImage(Image image, ImageItem imageItem, int n, int n2) {
        this(image, imageItem, 0);
        this.width = n;
        this.height = n2;
    }

    public PMImage(Image image, ImageItem imageItem, int n) {
        super(image);
        this.setImageItem(imageItem);
        this.setPenColor(DEFAULT_COLOR);
        double d = imageItem.photomesa.getImagePane().getCamera().getMagnification();
        this.setPenWidth((double)imageItem.photomesa.state.getThumbPenWidth() * PhotoMesa.THUMB_MAGS[n] / d);
    }

    public void setImageItem(ImageItem imageItem) {
        this.imageItem = imageItem;
    }

    public ImageItem getImageItem() {
        return this.imageItem;
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.repaint();
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenWidth(double d) {
        this.penWidth = d;
        this.stroke = new BasicStroke((float)d, 0, 0);
        this.reshape();
    }

    protected void computeBounds() {
        super.computeBounds();
        ZBounds zBounds = this.bounds;
        double d = this.penWidth;
        double d2 = 0.5 * d;
        this.border = new Rectangle2D.Double(zBounds.getX() + d2, zBounds.getY() + d2, zBounds.getWidth() - d, zBounds.getHeight() - d);
    }

    public ZBounds getGlobalBounds() {
        return this.getParents()[0].getGlobalBounds();
    }

    public double getMagnification() {
        double d = 1.0;
        ZGroup zGroup = this.getParents()[0].editor().getTop().getParent();
        while (zGroup != null) {
            if (zGroup instanceof ZTransformGroup) {
                d *= ((ZTransformGroup)zGroup).getScale();
            }
            zGroup = zGroup.getParent();
        }
        return d;
    }

    public void render(ZRenderContext zRenderContext) {
        super.render(zRenderContext);
        if (this.penColor != null && this.penWidth != 0.0) {
            Graphics2D graphics2D = zRenderContext.getGraphics2D();
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(this.penColor);
            graphics2D.draw(this.border);
        }
    }
}

