/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;

public class QuantumStripTreemap {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int HORIZONTAL_OR_VERTICAL = 3;
    public static final double MINIMUM_STRIP_LENGTH = 0.85;
    public static final double ASPECT_ALLOWENCE = 1.05;
    public static boolean debug = false;
    int orientation = 1;
    int[] origSizes;
    Rectangle origBox;
    double origiar;
    Rectangle[] resultRects = null;

    public QuantumStripTreemap(int[] nArray, double d, Rectangle rectangle) {
        this.origSizes = nArray;
        this.origBox = rectangle;
        this.origiar = d;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public Rectangle[] quantumStripLayout() {
        int n = this.computeSize(this.origSizes, 0, this.origSizes.length);
        double d = this.computeAspectRatio(this.origBox) / this.origiar;
        int n2 = (int)Math.round(Math.sqrt((double)n / d));
        int n3 = (int)Math.ceil((double)n / (double)n2);
        Rectangle rectangle = new Rectangle(this.origBox.x, this.origBox.y, n3, n2);
        this.debug("ar = " + d);
        this.debug("totalSize = " + n + ", origBox=" + this.origBox + ", box=" + rectangle);
        this.resultRects = this.quantumStripLayout(this.origSizes, rectangle);
        return this.resultRects;
    }

    public double computeAspectRatio(Rectangle rectangle) {
        return (double)rectangle.width / (double)rectangle.height;
    }

    public Rectangle[] getResult() {
        return this.resultRects;
    }

    public Rectangle getResultBox() {
        return this.computeUnion(this.resultRects);
    }

    public void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public void printStatistics() {
        if (this.resultRects == null) {
            System.out.println("Layout hasn't been computed yet");
        } else {
            System.out.print("Sizes: ");
            int n = 0;
            while (n < this.origSizes.length) {
                System.out.print(this.origSizes[n] + " ");
                ++n;
            }
            System.out.println("");
            System.out.println("Average aspect ratio: " + this.getAverageAspectRatio());
            System.out.println("Wasted Space: " + this.getWastedSpace() + "%");
        }
    }

    public double getAverageAspectRatio() {
        double d = 0.0;
        if (this.resultRects == null) {
            System.out.println("Layout hasn't been computed yet");
        } else {
            d = this.computeAverageAspectRatio(this.resultRects);
        }
        return d;
    }

    public double getWastedSpace() {
        double d = 0.0;
        if (this.resultRects == null) {
            System.out.println("Layout hasn't been computed yet");
        } else {
            int n;
            double d2;
            Rectangle rectangle = this.computeUnion(this.resultRects);
            double d3 = this.computeAspectRatio(rectangle);
            if (d3 > (d2 = this.computeAspectRatio(this.origBox) / this.origiar)) {
                rectangle.height = n = (int)((double)rectangle.width / d2);
            } else {
                rectangle.width = n = (int)((double)rectangle.height * d2);
            }
            double d4 = this.computeArea(rectangle);
            double d5 = this.computeSize(this.origSizes, 0, this.origSizes.length);
            d = 100.0 * (d4 - d5) / d4;
        }
        return d;
    }

    int computeArea(Rectangle rectangle) {
        return rectangle.width * rectangle.height;
    }

    int computeSize(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += nArray[n4 + n];
            ++n4;
        }
        return n3;
    }

    double computeAverageAspectRatio(Rectangle[] rectangleArray) {
        return this.computeAverageAspectRatio(rectangleArray, rectangleArray.length);
    }

    double computeAverageAspectRatio(Rectangle[] rectangleArray, int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = rectangleArray[n2].width;
            double d3 = rectangleArray[n2].height;
            double d4 = Math.max(d2 / d3, d3 / d2);
            d += d4;
            ++n2;
        }
        return d /= (double)n;
    }

    double computeWeightedAverageAspectRatio(Rectangle[] rectangleArray, int n) {
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d2 = rectangleArray[n4].width;
            double d3 = rectangleArray[n4].height;
            double d4 = Math.max(d2 / d3, d3 / d2);
            n2 = rectangleArray[n4].width * rectangleArray[n4].height;
            d += (double)n2 * d4;
            n3 += n2;
            ++n4;
        }
        return d /= (double)(n * n3);
    }

    protected Rectangle computeUnion(Rectangle[] rectangleArray) {
        Rectangle rectangle = new Rectangle(rectangleArray[0]);
        int n = 1;
        while (n < rectangleArray.length) {
            int n2 = Math.min(rectangle.x, rectangleArray[n].x);
            int n3 = Math.max(rectangle.x + rectangle.width, rectangleArray[n].x + rectangleArray[n].width);
            int n4 = Math.min(rectangle.y, rectangleArray[n].y);
            int n5 = Math.max(rectangle.y + rectangle.height, rectangleArray[n].y + rectangleArray[n].height);
            rectangle.setRect(n2, n4, n3 - n2, n5 - n4);
            ++n;
        }
        return rectangle;
    }

    protected Rectangle[] quantumStripLayout(int[] nArray, Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Rectangle[] rectangleArray = new Rectangle[nArray.length];
        Rectangle[] rectangleArray2 = new Rectangle[nArray.length];
        Rectangle rectangle2 = new Rectangle();
        int n9 = 0;
        while (n9 < nArray.length) {
            rectangleArray[n9] = new Rectangle();
            rectangleArray2[n9] = new Rectangle();
            ++n9;
        }
        while (n < nArray.length) {
            this.debug("A: finishedIndex = " + n + ", box=" + rectangle);
            n2 = 0;
            d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            n3 = 0;
            n4 = 0;
            int n10 = this.computeOrientation();
            do {
                try {
                    d = d2;
                    ++n2;
                    if (n10 == 1) {
                        n5 = 0;
                        n6 = this.computeHorizontalBoxLayout(nArray, rectangle, n, n2, rectangleArray, true);
                    } else {
                        n5 = this.computeVerticalBoxLayout(nArray, rectangle, n, n2, rectangleArray, true);
                        n6 = 0;
                    }
                    d2 = this.computeAverageAspectRatio(rectangleArray, n2);
                    if (d2 <= d3 * 1.05) {
                        d3 = d2;
                        n3 = n2;
                    }
                    this.debug("B: numRects=" + n2 + ", height=" + n6 + ", prevAR=" + d + ", ar=" + d2);
                }
                catch (TooSmallException tooSmallException) {
                    this.debug("B.1: too small exception on numRects=" + n2);
                }
                catch (TooBigException tooBigException) {
                    this.debug("B.2: too big exception on numRects=" + n2);
                    if (n4 != 0) continue;
                    n4 = n2 - 1;
                    this.debug("B.3: setting altNumRects = " + n4);
                }
            } while (n + n2 < nArray.length);
            this.debug("C.1: backup: numRects=" + n2 + ", bestNumRects=" + n3 + ", altNumRects=" + n4);
            if (n3 == 0) {
                n3 = n4;
            }
            n2 = n3;
            this.debug("C.2: backup: numRects=" + n2);
            if (n2 > 0) {
                if (n10 == 1) {
                    n5 = 0;
                    n6 = this.computeHorizontalBoxLayout(nArray, rectangle, n, n2, rectangleArray, false);
                } else {
                    n5 = this.computeVerticalBoxLayout(nArray, rectangle, n, n2, rectangleArray, false);
                    n6 = 0;
                }
            } else {
                n2 = nArray.length - n;
                this.debug("D: backup: numRects=" + n2);
                if (n10 == 1) {
                    n5 = 0;
                    n6 = this.computeHorizontalBoxLayout(nArray, rectangle, n, n2, rectangleArray, false);
                } else {
                    n5 = this.computeVerticalBoxLayout(nArray, rectangle, n, n2, rectangleArray, false);
                    n6 = 0;
                }
            }
            n9 = 0;
            while (n9 < n2) {
                rectangleArray2[n9 + n].setRect(rectangleArray[n9].x + n7, rectangleArray[n9].y + n8, rectangleArray[n9].width, rectangleArray[n9].height);
                ++n9;
            }
            n7 += n5;
            n8 += n6;
            rectangle2.setRect(rectangle.x + n5, rectangle.y + n6, rectangle.width - n5, rectangle.height - n6);
            rectangle = rectangle2;
            n += n2;
        }
        return rectangleArray2;
    }

    protected int computeHorizontalBoxLayout(int[] nArray, Rectangle rectangle, int n, int n2, Rectangle[] rectangleArray, boolean bl) {
        int n3 = this.computeSize(nArray, n, n2);
        int n4 = (int)Math.max(1.0, Math.ceil((double)n3 / (double)rectangle.width));
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = (int)Math.ceil((double)nArray[n6 + n] / (double)n4);
            rectangleArray[n6].setRect(n5, 0.0, n7, n4);
            n5 += n7;
            ++n6;
        }
        if (bl) {
            if ((double)n5 < (double)rectangle.width * 0.85) {
                throw new TooSmallException();
            }
            if (n5 > rectangle.width) {
                throw new TooBigException();
            }
        }
        rectangleArray[n2 - 1].width += rectangle.width - n5;
        return n4;
    }

    protected int computeVerticalBoxLayout(int[] nArray, Rectangle rectangle, int n, int n2, Rectangle[] rectangleArray, boolean bl) {
        int n3 = this.computeSize(nArray, n, n2);
        int n4 = (int)Math.max(1.0, Math.ceil((double)n3 / (double)rectangle.height));
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = (int)Math.ceil((double)nArray[n6 + n] / (double)n4);
            rectangleArray[n6].setRect(0.0, n5, n4, n7);
            n5 += n7;
            ++n6;
        }
        if (bl) {
            if ((double)n5 < (double)rectangle.height * 0.85) {
                throw new TooSmallException();
            }
            if (n5 > rectangle.height) {
                throw new TooBigException();
            }
        }
        rectangleArray[n2 - 1].height += rectangle.height - n5;
        return n4;
    }

    protected int computeOrientation() {
        int n = 1;
        switch (this.orientation) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = this.origBox.getWidth() > this.origBox.getHeight() ? 2 : 1;
            }
        }
        return n;
    }
}

