/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZRectangle;
import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.component.ZText;
import edu.umd.cs.jazz.util.ZBounds;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class Region {
    static Color LABEL_PEN = new Color(0.65f, 0.65f, 0.65f);
    static Color LABEL_BACKGROUND = Color.white;
    static Color LABEL_SELECTED_PEN = Color.black;
    static Color LABEL_SELECTED_BACKGROUND = new Color(1.0f, 1.0f, 0.4f);
    static final int LABELS_ON_BOTTOM = 1;
    static final int LABELS_IN_CENTER = 2;
    PhotoMesa photomesa;
    Vector imageItems;
    ImageItem[][] imageItemsGrid = null;
    int numRows;
    int numCols;
    ZGroup group;
    ZShape border;
    String directory;
    String name;
    ZVisualLeaf labelLeaf = null;
    ZText labelText = null;
    ZRectangle labelRect = null;
    long date;
    Color color = null;
    double colorBalance = 0.0;
    int labelPosition = 1;
    boolean removing = false;

    Region(PhotoMesa photoMesa, Vector vector) {
        this.photomesa = photoMesa;
        this.imageItems = vector;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((ImageItem)iterator.next()).setRegion(this);
        }
        this.sort(photoMesa.state.getSortType());
    }

    public Object clone() {
        Region region = new Region(this.photomesa, this.imageItems);
        region.setName(this.name);
        region.setDirectory(this.directory);
        region.setDate(this.date);
        return region;
    }

    void clear() {
        this.removeLabel();
    }

    Point2D getCenterOfMass() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            while (n3 < this.numCols) {
                PMImage pMImage;
                if (this.imageItemsGrid[n2][n3] != null && (pMImage = this.imageItemsGrid[n2][n3].getThumb()) != null) {
                    ZBounds zBounds = pMImage.getGlobalBounds();
                    d += zBounds.getX() + 0.5 * zBounds.getWidth();
                    d2 += zBounds.getY() + 0.5 * zBounds.getHeight();
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return new Point2D.Double(d /= (double)n, d2 /= (double)n);
    }

    Point getGridPt(Point2D point2D) {
        int n = 0;
        int n2 = 0;
        n = 0;
        block0: while (n < this.numCols) {
            n2 = 0;
            while (n2 < this.numRows) {
                ImageItem imageItem;
                ZBounds zBounds;
                if (this.imageItemsGrid[n2][n] != null && (zBounds = (imageItem = this.imageItemsGrid[n2][n]).getThumb().getGlobalBounds()).getX() + zBounds.getWidth() > point2D.getX() && zBounds.getY() + zBounds.getHeight() > point2D.getY()) break block0;
                ++n2;
            }
            ++n;
        }
        return new Point(n, n2);
    }

    void setColor(Color color) {
        this.color = color;
        if (this.border != null) {
            if (color == null) {
                this.border.setFillPaint(null);
            } else {
                Color color2 = this.getBalancedColor(color);
                this.border.setFillPaint(color2);
            }
        }
    }

    Color getColor() {
        return this.color;
    }

    void updateColor() {
        if (this.border != null) {
            if (this.color == null) {
                this.border.setFillPaint(null);
            } else {
                Color color = this.getBalancedColor(this.color);
                this.border.setFillPaint(color);
            }
        }
    }

    Color getBalancedColor(Color color) {
        int n;
        int n2;
        int n3;
        double d = 1.0 - this.photomesa.state.getColorBalance();
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        if (d < 0.5) {
            double d2 = 2.0 * d;
            n3 = (int)(0.0 + d2 * (double)(n4 - 0));
            n2 = (int)(0.0 + d2 * (double)(n5 - 0));
            n = (int)(0.0 + d2 * (double)(n6 - 0));
        } else {
            double d3 = 2.0 * (d - 0.5);
            n3 = (int)((double)n4 + d3 * (double)(255 - n4));
            n2 = (int)((double)n5 + d3 * (double)(255 - n5));
            n = (int)((double)n6 + d3 * (double)(255 - n6));
        }
        if (n4 == 255) {
            n3 = n4;
        }
        if (n5 == 255) {
            n2 = n5;
        }
        if (n6 == 255) {
            n = n6;
        }
        Color color2 = new Color(n3, n2, n);
        return color2;
    }

    void setLabelPosition(int n) {
        this.labelPosition = n;
    }

    int getLabelPosition() {
        return this.labelPosition;
    }

    void setActive(boolean bl) {
        if (bl) {
            this.setBorderColor(PhotoMesa.HILITE_PEN_COLOR);
            if (this.border != null) {
                this.border.getParents()[0].raise();
            }
            this.updateLabel(true);
        } else {
            this.setBorderColor(PhotoMesa.BORDER_COLOR);
            this.updateLabel(false);
        }
        if (this.photomesa.state.getLayoutType() == 3) {
            this.setBorderColor(null);
        }
    }

    int getNumImages() {
        return this.imageItems.size();
    }

    void remove(ImageItem imageItem) {
        this.imageItems.remove(imageItem);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                if (this.imageItemsGrid[n][n2] == imageItem) {
                    this.imageItemsGrid[n][n2] = null;
                }
                ++n2;
            }
            ++n;
        }
    }

    void setGroup(ZGroup zGroup) {
        this.group = zGroup;
    }

    ZGroup getGroup() {
        return this.group;
    }

    void setDate(long l) {
        this.date = l;
    }

    long getDate() {
        return this.date;
    }

    void setBorder(ZShape zShape) {
        this.border = zShape;
        this.setColor(this.color);
    }

    ZShape getBorder() {
        return this.border;
    }

    void setBorderColor(Color color) {
        if (this.border != null) {
            this.border.setPenPaint(color);
        }
    }

    void setName(String string) {
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    void setDirectory(String string) {
        this.directory = string;
    }

    String getDirectory() {
        return this.directory;
    }

    void updateLabel() {
        this.updateLabel(false);
    }

    void updateLabel(boolean bl) {
        String string;
        int n;
        ImagePane imagePane = this.photomesa.getImagePane();
        if (this.border == null) {
            return;
        }
        if (!this.photomesa.state.getShowLabels()) {
            this.removeLabel();
            return;
        }
        if (this.removing) {
            return;
        }
        if (this.labelLeaf == null) {
            this.createLabel();
        }
        this.labelLeaf.editor().getFadeGroup().setAlpha(1.0);
        double d = 1.0 / imagePane.getCamera().getMagnification();
        this.labelText.setText(this.name);
        ZBounds zBounds = this.labelText.getBounds();
        double d2 = d * zBounds.getWidth();
        if (this.border.getHeight() / (d * zBounds.getHeight()) < 1.0 && !bl) {
            this.hideLabel();
        }
        if ((n = (int)(this.border.getWidth() / d2 * (double)this.name.length())) < this.name.length() && !bl) {
            if (n > 0) {
                --n;
            }
            if (n <= 3) {
                this.hideLabel();
            }
            string = this.name.substring(0, n);
        } else {
            string = this.name;
        }
        this.labelText.setText(string);
        this.labelRect.setRect(this.labelText.getBounds());
        if (bl) {
            this.labelRect.setFillPaint(LABEL_SELECTED_BACKGROUND);
            this.labelRect.setPenPaint(LABEL_SELECTED_PEN);
        } else {
            this.labelRect.setFillPaint(LABEL_BACKGROUND);
            this.labelRect.setPenPaint(LABEL_PEN);
        }
        this.labelRect.setAbsPenWidth(1.0);
        ZDrawingSurface zDrawingSurface = imagePane.getDrawingSurface();
        ZTransformGroup zTransformGroup = this.labelLeaf.editor().getTransformGroup();
        zTransformGroup.setScale(d);
        switch (this.labelPosition) {
            case 1: {
                zTransformGroup.position((Point2D)new Point2D.Double(0.5, 1.0), (Point2D)new Point2D.Double(0.5, 1.0), this.border.getParents()[0].getGlobalBounds(), 0, zDrawingSurface);
                zTransformGroup.translate(0.0, -2.0 / d);
                break;
            }
            case 2: {
                Point2D point2D = this.getCenterOfMass();
                zBounds = new ZBounds(point2D.getX(), point2D.getY(), 1.0, 1.0);
                zTransformGroup.position((Point2D)new Point2D.Double(0.5, 0.5), (Point2D)new Point2D.Double(0.5, 0.5), zBounds, 0, zDrawingSurface);
            }
        }
        if (bl) {
            ZBounds zBounds2 = imagePane.getCamera().getViewBounds();
            double d3 = zTransformGroup.getScale();
            zBounds = this.labelLeaf.getGlobalBounds();
            if (zBounds.getX() < zBounds2.getX()) {
                zTransformGroup.translate((zBounds2.getX() - zBounds.getX()) / d3, 0.0);
            }
            if (zBounds.getY() < zBounds2.getY()) {
                zTransformGroup.translate(0.0, (zBounds2.getY() - zBounds.getY()) / d3);
            }
            if (zBounds.getX() + zBounds.getWidth() > zBounds2.getX() + zBounds2.getWidth()) {
                zTransformGroup.translate((zBounds2.getX() + zBounds2.getWidth() - (zBounds.getX() + zBounds.getWidth())) / d3, 0.0);
            }
            if (zBounds.getY() + zBounds.getHeight() > zBounds2.getY() + zBounds2.getHeight()) {
                zTransformGroup.translate(0.0, (zBounds2.getY() + zBounds2.getHeight() - (zBounds.getY() + zBounds.getHeight())) / d3);
            }
        }
        this.labelLeaf.editor().getTop().raise();
    }

    void hideLabel() {
        if (this.labelLeaf != null) {
            this.labelLeaf.editor().getFadeGroup().setAlpha(0.0);
        }
    }

    void removeLabel() {
        if (this.labelLeaf != null) {
            try {
                ZNode zNode = this.labelLeaf.editor().getTop();
                zNode.getParent().removeChild(zNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.labelLeaf = null;
            this.labelText = null;
            this.labelRect = null;
        }
    }

    void createLabel() {
        if (!this.photomesa.state.getShowLabels()) {
            return;
        }
        ImagePane imagePane = this.photomesa.getImagePane();
        this.labelLeaf = new ZVisualLeaf();
        this.labelLeaf.setFindable(false);
        this.labelLeaf.setPickable(false);
        this.labelText = new ZText();
        this.labelText.setFont(PhotoMesa.font);
        this.labelRect = new ZRectangle();
        this.labelLeaf.addVisualComponent(this.labelRect);
        this.labelLeaf.addVisualComponent(this.labelText);
        imagePane.getTopLayer().addChild(this.labelLeaf);
    }

    Vector getImageItems() {
        return this.imageItems;
    }

    void setImageItems(Vector vector) {
        this.imageItems = vector;
    }

    void sort(int n) {
        Object[] objectArray = this.imageItems.toArray();
        switch (n) {
            case 1: {
                Arrays.sort(objectArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        long l;
                        long l2 = ((ImageItem)object).getFile().lastModified();
                        int n = l2 < (l = ((ImageItem)object2).getFile().lastModified()) ? -1 : (l2 == l ? 0 : 1);
                        return n;
                    }
                });
                break;
            }
            case 2: {
                Arrays.sort(objectArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        String string = ((ImageItem)object).getFile().getName();
                        String string2 = ((ImageItem)object2).getFile().getName();
                        return string.compareToIgnoreCase(string2);
                    }
                });
                break;
            }
        }
        this.imageItems.clear();
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.imageItems.add(objectArray[n2]);
            ++n2;
        }
    }

    void sortByName() {
    }

    void sortByColor() {
    }

    public String toString() {
        return this.name;
    }
}

