/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZLayoutManager;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZVisualGroup;
import edu.umd.cs.jazz.event.ZGroupEvent;
import edu.umd.cs.jazz.event.ZGroupListener;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZNodeNotFoundException;
import edu.umd.cs.jazz.util.ZObjectReferenceTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class ZLayoutGroup
extends ZVisualGroup
implements ZSerializable,
Serializable {
    private static ArrayList invalidatedNodes = new ArrayList();
    private static ArrayList validatedInvalidNodes = new ArrayList();
    private static boolean revalidating = false;
    private ZLayoutManager layoutManager = null;
    private ZGroup layoutChild = null;
    private boolean validated = true;
    private transient ZGroupListener layoutUpdateManager;

    public ZLayoutGroup() {
        this.setLayoutChild(this);
    }

    public ZLayoutGroup(ZNode child) {
        super(child);
    }

    public ZLayoutGroup(ZNode child, ZGroup layoutChild) {
        super(child);
        this.setLayoutChild(layoutChild);
    }

    protected Object duplicateObject() {
        ZLayoutGroup newGroup = (ZLayoutGroup)super.duplicateObject();
        if (this.layoutManager != null) {
            newGroup.layoutManager = (ZLayoutManager)this.layoutManager.clone();
            newGroup.layoutUpdateManager = null;
        }
        newGroup.validated = false;
        return newGroup;
    }

    protected void updateObjectReferences(ZObjectReferenceTable objRefTable) {
        super.updateObjectReferences(objRefTable);
        if (this.layoutChild != null) {
            ZGroup duplicatedLayoutChild = (ZGroup)objRefTable.getNewObjectReference(this.layoutChild);
            this.setLayoutChild(duplicatedLayoutChild);
            if (this.layoutChild == null) {
                throw new RuntimeException("Problem in updateObjectReferences: " + this);
            }
        }
    }

    public void setLayoutManager(ZLayoutManager manager) {
        this.layoutManager = manager;
        this.invalidate();
    }

    public final ZLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutChild(ZGroup child) {
        if (child != this && !child.isDescendentOf(this)) {
            throw new ZNodeNotFoundException("Node " + child + " is not a descendant of " + this);
        }
        if (this.layoutChild != null) {
            this.layoutChild.removeGroupListener(this.layoutUpdateManager);
        }
        this.layoutChild = child;
        if (this.layoutChild != null) {
            this.layoutUpdateManager = new ZGroupListener(){

                public void nodeAdded(ZGroupEvent e) {
                    ZLayoutGroup.this.invalidate();
                }

                public void nodeRemoved(ZGroupEvent e) {
                    ZLayoutGroup.this.invalidate();
                }
            };
            this.layoutChild.addGroupListener(this.layoutUpdateManager);
        }
    }

    public final ZGroup getLayoutChild() {
        return this.layoutChild;
    }

    public void invalidate() {
        ZLayoutGroup layout;
        if (revalidating) {
            return;
        }
        this.validated = false;
        ArrayList<ZLayoutGroup> removeList = new ArrayList<ZLayoutGroup>();
        Iterator i = invalidatedNodes.iterator();
        while (i.hasNext()) {
            layout = (ZLayoutGroup)i.next();
            if (layout == this) {
                return;
            }
            if (layout.isAncestorOf(this)) {
                return;
            }
            if (!this.isAncestorOf(layout)) continue;
            removeList.add(layout);
        }
        invalidatedNodes.add(this);
        Iterator i2 = removeList.iterator();
        while (i2.hasNext()) {
            layout = (ZLayoutGroup)i2.next();
            invalidatedNodes.remove(layout);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                revalidating = true;
                Iterator i = invalidatedNodes.iterator();
                while (i.hasNext()) {
                    ZLayoutGroup l = (ZLayoutGroup)i.next();
                    l.doLayout();
                    validatedInvalidNodes.add(l);
                }
                revalidating = false;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Iterator<E> i = ZLayoutGroup.access$200().iterator();
                        while (i.hasNext()) {
                            ZLayoutGroup layout = (ZLayoutGroup)i.next();
                            ZLayoutGroup.access$100().remove(layout);
                        }
                    }
                });
            }
        });
    }

    static void invalidateChildren(ZNode aNode) {
        if (aNode instanceof ZGroup) {
            ZNode[] children = ((ZGroup)aNode).getChildren();
            int i = 0;
            while (i < children.length) {
                ZLayoutGroup.invalidateChildren(children[i]);
                ++i;
            }
            if (aNode instanceof ZLayoutGroup) {
                ((ZLayoutGroup)aNode).validated = false;
            }
        }
    }

    public void validate() {
        invalidatedNodes.remove(this);
        this.doLayout();
    }

    public void doLayout() {
        ZLayoutManager manager = this.getLayoutManager();
        if (!this.validated) {
            ZGroup layoutNode = this.layoutChild;
            if (layoutNode == null) {
                layoutNode = this;
            }
            if (manager != null) {
                manager.preLayout(layoutNode);
            }
            ZNode[] children = layoutNode.getChildren();
            int i = 0;
            while (i < children.length) {
                this.doLayoutInternal(children[i]);
                ++i;
            }
            if (manager != null) {
                manager.doLayout(layoutNode);
                manager.postLayout(layoutNode);
            }
            this.validated = true;
        }
    }

    protected void doLayoutInternal(ZNode node) {
        if (node instanceof ZLayoutGroup) {
            ZLayoutGroup layout = (ZLayoutGroup)node;
            if (!layout.validated) {
                layout.doLayout();
            }
        } else if (node instanceof ZGroup) {
            ZNode[] children = ((ZGroup)node).getChildren();
            int i = 0;
            while (i < children.length) {
                this.doLayoutInternal(children[i]);
                ++i;
            }
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.layoutManager != null) {
            out.writeState("ZLayoutManager", "layoutManager", this.layoutManager);
        }
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
        if (this.layoutManager != null) {
            out.addObject(this.layoutManager);
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("layoutManager") == 0) {
            this.setLayoutManager((ZLayoutManager)fieldValue);
        }
        if (this.layoutChild != null) {
            this.setLayoutChild(this.layoutChild);
        } else {
            this.setLayoutChild(this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.layoutChild != null) {
            this.setLayoutChild(this.layoutChild);
        } else {
            this.setLayoutChild(this);
        }
    }
}

