/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSelectionManager;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.ZVisualGroup;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class ZSelectionGroup
extends ZVisualGroup
implements ZSerializable,
Serializable {
    public static final Color penColor_DEFAULT = Color.magenta;
    private static SelectionComponentFactory componentFactory = new SelectionComponentFactory(){

        public ZVisualComponent createSelectionComponent() {
            return new SelectionRect();
        }
    };
    private Color penColor = penColor_DEFAULT;
    private ZList.ZVisualComponentList visualComponents = ZListImpl.NullList;

    public ZSelectionGroup() {
        this.setFrontVisualComponentPickable(false);
        this.setFrontVisualComponent(componentFactory.createSelectionComponent());
    }

    public ZSelectionGroup(ZNode child) {
        this();
        this.addChild(child);
    }

    public void addAuxiliaryVisualComponent(ZVisualComponent visualComponent) {
        if (visualComponent == null) {
            return;
        }
        if (this.visualComponents.isNull()) {
            this.visualComponents = new ZListImpl.ZVisualComponentListImpl(1);
        }
        if (this.visualComponents.contains(visualComponent)) {
            return;
        }
        this.visualComponents.add(visualComponent);
        visualComponent.addParent(this);
        this.updateVolatility();
        this.reshape();
    }

    public void removeAuxiliaryVisualComponent(ZVisualComponent visualComponent) {
        if (visualComponent == null) {
            return;
        }
        int index = this.visualComponents.indexOf(visualComponent);
        if (index == -1) {
            return;
        }
        this.visualComponents.remove(visualComponent);
        visualComponent.removeParent(this);
        this.updateVolatility();
        this.reshape();
    }

    public void setAuxiliaryVisualComponent(ZVisualComponent visualComponent) {
        this.clearAuxiliaryVisualComponents();
        this.addAuxiliaryVisualComponent(visualComponent);
    }

    public final ZVisualComponent[] getAuxiliaryVisualComponents() {
        return this.visualComponents.getVisualComponentsReference();
    }

    public void clearAuxiliaryVisualComponents() {
        ZVisualComponent[] visualComponentsRef = this.visualComponents.getVisualComponentsReference();
        int i = 0;
        while (i < this.visualComponents.size()) {
            this.repaint();
            visualComponentsRef[i].removeParent(this);
            ++i;
        }
        this.visualComponents.clear();
        this.updateVolatility();
    }

    protected void computeVolatileBounds() {
        super.computeVolatileBounds();
        if (!this.volatileBounds) {
            this.volatileBounds = this.visualComponents.collectiveHasVolatileBounds();
        }
    }

    public static ArrayList getSelectedNodes(ZNode node) {
        return ZSelectionManager.getSelectedNodes(node);
    }

    public static ArrayList getSelectedNodes(ZCamera camera) {
        return ZSelectionManager.getSelectedNodes(camera);
    }

    public static ZSelectionGroup select(ZNode node) {
        return ZSelectionManager.select(node);
    }

    public static void unselect(ZNode node) {
        ZSelectionManager.unselect(node);
    }

    public static void unselectAll(ZNode node) {
        ZSelectionManager.unselectAll(node);
    }

    public static void unselectAll(ZCamera camera) {
        ZSelectionManager.unselectAll(camera);
    }

    public static boolean isSelected(ZNode node) {
        return ZSelectionManager.isSelected(node);
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.repaint();
    }

    public void render(ZRenderContext renderContext) {
        ZVisualComponent frontVisualComponent = this.getFrontVisualComponent();
        ZVisualComponent backVisualComponent = this.getBackVisualComponent();
        if (backVisualComponent != null) {
            backVisualComponent.render(renderContext);
        }
        super.render(renderContext);
        ZVisualComponent[] visualComponentsRef = this.visualComponents.getVisualComponentsReference();
        int i = this.visualComponents.size() - 1;
        while (i >= 0) {
            visualComponentsRef[i].render(renderContext);
            --i;
        }
        if (frontVisualComponent != null) {
            frontVisualComponent.render(renderContext);
        }
        if (frontVisualComponent != null) {
            ZDebug.incPaintCount();
        }
        if (backVisualComponent != null) {
            ZDebug.incPaintCount();
        }
        int i2 = 0;
        while (i2 < this.visualComponents.size()) {
            ZDebug.incPaintCount();
            ++i2;
        }
        if (ZDebug.showBounds) {
            Graphics2D g2 = renderContext.getGraphics2D();
            g2.setColor(new Color(60, 60, 60));
            g2.setStroke(new BasicStroke((float)(1.0 / renderContext.getCompositeMagnification()), 0, 0));
            if (frontVisualComponent != null) {
                g2.draw(frontVisualComponent.getBoundsReference());
            }
            if (backVisualComponent != null) {
                g2.draw(backVisualComponent.getBoundsReference());
            }
            int i3 = 0;
            while (i3 < this.visualComponents.size()) {
                g2.draw(visualComponentsRef[i3].getBoundsReference());
                ++i3;
            }
        }
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.isPickable() && this.visualComponents.size() > 0) {
            ZNode node = this.editor().getNode();
            ZNode group = this;
            while (group != node) {
                path.push(group);
                group = ((ZGroup)group).getChildrenReference()[0];
            }
            path.push(node);
            ZVisualComponent picked = (ZVisualComponent)this.visualComponents.collectivePick(rect, path);
            if (picked != null) {
                if (!(picked instanceof ZCamera)) {
                    path.setObject(picked);
                }
                return true;
            }
            path.pop(this);
        }
        return super.pick(rect, path);
    }

    public static void setSelectionComponentFactory(SelectionComponentFactory newFactory) {
        componentFactory = newFactory;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        ZVisualComponent vc = this.getFrontVisualComponent();
        this.setFrontVisualComponent(null);
        super.writeObject(out);
        this.setFrontVisualComponent(vc);
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        ZVisualComponent vc = this.getFrontVisualComponent();
        this.setFrontVisualComponent(null);
        super.writeObjectRecurse(out);
        this.setFrontVisualComponent(vc);
    }

    public void trimToSize() {
        super.trimToSize();
        this.visualComponents.trimToSize();
    }

    static class SelectionRect
    extends ZVisualComponent {
        public boolean pick(Rectangle2D pickRect, ZSceneGraphPath path) {
            return false;
        }

        public void render(ZRenderContext ctx) {
            Graphics2D g2 = ctx.getGraphics2D();
            double mag = ctx.getCompositeMagnification();
            double sz = 1.0 / mag;
            ZNode p = (ZNode)this.parents.get(0);
            if (p instanceof ZSelectionGroup) {
                ZSelectionGroup g = (ZSelectionGroup)p;
                ZBounds r = g.getBounds();
                double x = ((RectangularShape)r).getX();
                double y = ((RectangularShape)r).getY();
                double w = ((RectangularShape)r).getWidth();
                double h = ((RectangularShape)r).getHeight();
                if (w * mag < 2.0 || h * mag < 2.0) {
                    return;
                }
                ((Rectangle2D)r).setRect(x + sz, y + sz, w - sz * 2.0, h - sz * 2.0);
                g2.setStroke(new BasicStroke((float)sz));
                g2.setColor(g.getPenColor());
                g2.draw(r);
            }
        }

        protected void computeBounds() {
        }
    }

    public static interface SelectionComponentFactory {
        public ZVisualComponent createSelectionComponent();
    }
}

