/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import edu.umd.cs.jazz.util.ZObjectReferenceTable;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ZVisualComponent
extends ZSceneGraphObject
implements ZSerializable,
Serializable {
    ZList.ZNodeList parents = ZListImpl.NullList;

    protected Object duplicateObject() {
        ZVisualComponent newComponent = (ZVisualComponent)super.duplicateObject();
        if (!this.parents.isNull()) {
            newComponent.parents = (ZList.ZNodeList)this.parents.clone();
        }
        return newComponent;
    }

    protected void updateObjectReferences(ZObjectReferenceTable objRefTable) {
        super.updateObjectReferences(objRefTable);
        if (!this.parents.isNull()) {
            int n = 0;
            ZNode[] parentsRef = this.parents.getNodesReference();
            int i = 0;
            while (i < this.parents.size()) {
                ZNode newParent = (ZNode)objRefTable.getNewObjectReference(parentsRef[i]);
                if (newParent != null) {
                    parentsRef[n++] = newParent;
                }
                ++i;
            }
            this.parents.setSize(n);
        }
    }

    public void trimToSize() {
        this.parents.trimToSize();
    }

    public ZRoot getRoot() {
        return this.parents.size() > 0 ? this.parents.getNodesReference()[0].getRoot() : null;
    }

    public ZNode[] getParents() {
        return (ZNode[])this.parents.toArray();
    }

    public int getNumParents() {
        return this.parents.size();
    }

    public ZNode[] getParentsReference() {
        return this.parents.getNodesReference();
    }

    public void addParent(ZNode parent) {
        if (this.parents.isNull()) {
            this.parents = new ZListImpl.ZNodeListImpl(1);
        }
        this.parents.add(parent);
    }

    public void removeParent(ZNode parent) {
        this.parents.remove(parent);
        if (this.parents.size() == 0) {
            this.parents = ZListImpl.NullList;
        }
    }

    public boolean pickBounds(Rectangle2D rect) {
        return this.getBoundsReference().intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        return this.pickBounds(rect);
    }

    public void paint(Graphics2D g2) {
    }

    public void render(ZRenderContext renderContext) {
        this.paint(renderContext.getGraphics2D());
    }

    public void repaint() {
        if (!this.inTransaction) {
            this.parents.collectiveRepaint(null);
        }
    }

    public void repaint(ZBounds repaintBounds) {
        if (!this.inTransaction) {
            this.parents.collectiveRepaint(repaintBounds);
        }
    }

    protected void updateBounds() {
        super.updateBounds();
        ZNode[] parentsRef = this.parents.getNodesReference();
        int i = 0;
        while (i < this.parents.size()) {
            parentsRef[i].updateBounds();
            ++i;
        }
    }

    protected void updateVolatility() {
        super.updateVolatility();
        ZNode[] parentsRef = this.parents.getNodesReference();
        int i = 0;
        while (i < this.parents.size()) {
            parentsRef[i].updateVolatility();
            ++i;
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }
}

