/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ZLine
extends ZShape {
    protected transient Line2D line;

    public ZLine() {
    }

    public ZLine(Line2D aLine) {
        this(aLine.getP1(), aLine.getP2());
    }

    public ZLine(Point2D pt1, Point2D pt2) {
        this(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    public ZLine(double x1, double y1, double x2, double y2) {
        this.setLine(x1, y1, x2, y2);
        this.fillPaint = null;
    }

    protected Object duplicateObject() {
        ZLine newLine = (ZLine)super.duplicateObject();
        newLine.line = (Line2D)this.getLine().clone();
        return newLine;
    }

    public Line2D getLine() {
        if (this.line == null) {
            this.line = new Line2D.Double();
        }
        return this.line;
    }

    public void setAbsPenWidth(double width) {
        this.setVolatileBounds(true);
        super.setAbsPenWidth(width);
    }

    public void setPenWidth(double width) {
        this.setVolatileBounds(false);
        super.setPenWidth(width);
    }

    protected void computeBounds() {
        this.bounds.reset();
        Rectangle2D shapeBounds = this.getFrame();
        double aPenWidth = this.getPenWidthForCurrentContext();
        double aHalfPenWidth = aPenWidth * 0.5;
        this.bounds.setRect(shapeBounds.getX() - aHalfPenWidth, shapeBounds.getY() - aHalfPenWidth, shapeBounds.getWidth() + aPenWidth, shapeBounds.getHeight() + aPenWidth);
    }

    public void render(ZRenderContext renderContext) {
        if (this.absPenWidth) {
            if (this.penPaint != null) {
                Graphics2D g2 = renderContext.getGraphics2D();
                double pw = this.penWidth / renderContext.getCompositeMagnification();
                this.stroke = new BasicStroke((float)pw, 0, 0);
                g2.setStroke(this.stroke);
                g2.setPaint(this.penPaint);
                g2.draw(this.getShape());
            }
        } else {
            super.render(renderContext);
        }
    }

    public Shape getShape() {
        return this.getLine();
    }

    public void setLine(Line2D aLine) {
        this.setLine(aLine.getP1(), aLine.getP2());
    }

    public void setLine(Point2D pt1, Point2D pt2) {
        this.setLine(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    public void setLine(double x1, double y1, double x2, double y2) {
        this.getLine().setLine(x1, y1, x2, y2);
        this.reshape();
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        Line2D line = this.getLine();
        Vector<Double> dimensions = new Vector<Double>();
        dimensions.add(new Double(line.getX1()));
        dimensions.add(new Double(line.getY1()));
        dimensions.add(new Double(line.getX2()));
        dimensions.add(new Double(line.getY2()));
        out.writeState("line", "line", dimensions);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("line") == 0) {
            Vector dim = (Vector)fieldValue;
            double x1 = (Double)dim.get(0);
            double y1 = (Double)dim.get(1);
            double x2 = (Double)dim.get(2);
            double y2 = (Double)dim.get(3);
            this.setLine(x1, y1, x2, y2);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Line2D line = this.getLine();
        out.writeDouble(line.getX1());
        out.writeDouble(line.getY1());
        out.writeDouble(line.getX2());
        out.writeDouble(line.getY2());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double x1 = in.readDouble();
        double y1 = in.readDouble();
        double x2 = in.readDouble();
        double y2 = in.readDouble();
        this.getLine().setLine(x1, y1, x2, y2);
    }
}

