/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Vector;

public class ZPath
extends ZShape {
    protected transient GeneralPath path;

    public ZPath() {
    }

    public ZPath(GeneralPath path) {
        this.setPath(path);
    }

    public void setPath(GeneralPath aPath) {
        this.getPath().reset();
        this.getPath().append(aPath, false);
        this.reshape();
    }

    protected Object duplicateObject() {
        ZPath newPath = (ZPath)super.duplicateObject();
        newPath.path = (GeneralPath)this.getPath().clone();
        return newPath;
    }

    public double getX() {
        return this.getRect().getX();
    }

    public double getY() {
        return this.getRect().getY();
    }

    public double getWidth() {
        return this.getRect().getWidth();
    }

    public double getHeight() {
        return this.getRect().getHeight();
    }

    public Rectangle2D getRect() {
        return this.getShape().getBounds2D();
    }

    public Shape getShape() {
        return this.path;
    }

    public GeneralPath getPath() {
        if (this.path == null) {
            this.path = new GeneralPath();
        }
        return this.path;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        Vector pathVector = this.flattenPath(this.getPath());
        out.writeState("java.util.Vector", "path", pathVector);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("path") == 0) {
            Vector pathVector = (Vector)fieldValue;
            this.setPath(this.buildPathFrom(pathVector));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Vector pathVector = this.flattenPath(this.getPath());
        out.writeObject(pathVector);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Vector pathVector = (Vector)in.readObject();
        this.path = this.buildPathFrom(pathVector);
    }

    private Vector flattenPath(GeneralPath path) {
        Vector<Number> result = new Vector<Number>();
        AffineTransform at = new AffineTransform();
        PathIterator i = path.getPathIterator(at);
        while (!i.isDone()) {
            float[] data = new float[6];
            switch (i.currentSegment(data)) {
                case 0: {
                    result.addElement(new Integer(0));
                    result.addElement(new Float(data[0]));
                    result.addElement(new Float(data[1]));
                    break;
                }
                case 1: {
                    result.addElement(new Integer(1));
                    result.addElement(new Float(data[0]));
                    result.addElement(new Float(data[1]));
                    break;
                }
                case 2: {
                    result.addElement(new Integer(2));
                    result.addElement(new Float(data[0]));
                    result.addElement(new Float(data[1]));
                    result.addElement(new Float(data[2]));
                    result.addElement(new Float(data[3]));
                    break;
                }
                case 3: {
                    result.addElement(new Integer(3));
                    result.addElement(new Float(data[0]));
                    result.addElement(new Float(data[1]));
                    result.addElement(new Float(data[2]));
                    result.addElement(new Float(data[3]));
                    result.addElement(new Float(data[4]));
                    result.addElement(new Float(data[5]));
                    break;
                }
                case 4: {
                    result.addElement(new Integer(4));
                    break;
                }
            }
            i.next();
        }
        return result;
    }

    private GeneralPath buildPathFrom(Vector v) {
        GeneralPath path = new GeneralPath();
        Iterator i = v.iterator();
        while (i.hasNext()) {
            int segType = (Integer)i.next();
            switch (segType) {
                case 0: {
                    path.moveTo(((Float)i.next()).floatValue(), ((Float)i.next()).floatValue());
                    break;
                }
                case 1: {
                    path.lineTo(((Float)i.next()).floatValue(), ((Float)i.next()).floatValue());
                    break;
                }
                case 2: {
                    path.quadTo(((Float)i.next()).floatValue(), ((Float)i.next()).floatValue(), ((Float)i.next()).floatValue(), ((Float)i.next()).floatValue());
                    break;
                }
                case 3: {
                    path.curveTo(((Float)i.next()).floatValue(), ((Float)i.next()).floatValue(), ((Float)i.next()).floatValue(), ((Float)i.next()).floatValue(), ((Float)i.next()).floatValue(), ((Float)i.next()).floatValue());
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
            }
        }
        return path;
    }
}

