/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.event.ZMouseEvent;

public class ZMouseFilter {
    public static int ALL_MODIFIERS_MASK = 63;
    private int fAndMask;
    private int fOrMask;
    private int fNotMask;
    private short fClickCount = (short)-1;
    private boolean fConsumes = false;
    private boolean fAcceptsMouseClicked = true;
    private boolean fAcceptsMouseDragged = true;
    private boolean fAcceptsMouseEntered = true;
    private boolean fAcceptsMouseExited = true;
    private boolean fAcceptsMouseMoved = true;
    private boolean fAcceptsMousePressed = true;
    private boolean fAcceptsMouseReleased = true;

    public ZMouseFilter() {
        this.acceptEverything();
    }

    public ZMouseFilter(int aAndMask) {
        this();
        this.fAndMask = aAndMask;
    }

    public ZMouseFilter(int aAndMask, int aNotMask) {
        this(aAndMask);
        this.fNotMask = aNotMask;
    }

    public void setAndMask(int aAndMask) {
        this.fAndMask = aAndMask;
    }

    public void setOrMask(int aOrMask) {
        this.fOrMask = aOrMask;
    }

    public void setNotMask(int aNotMask) {
        this.fNotMask = aNotMask;
    }

    public void setAcceptClickCount(short aClickCount) {
        this.fClickCount = aClickCount;
    }

    public void acceptAllClickCounts() {
        this.fClickCount = (short)-1;
    }

    public void rejectAllClickCounts() {
        this.fClickCount = Short.MAX_VALUE;
    }

    public void setConsumes(boolean aBoolean) {
        this.fConsumes = aBoolean;
    }

    public boolean getConsumes() {
        return this.fConsumes;
    }

    public boolean getAcceptsMouseClicked() {
        return this.fAcceptsMouseClicked;
    }

    public void setAcceptsMouseClicked(boolean aBoolean) {
        this.fAcceptsMouseClicked = aBoolean;
    }

    public boolean getAcceptsMouseEntered() {
        return this.fAcceptsMouseEntered;
    }

    public void setAcceptsMouseEntered(boolean aBoolean) {
        this.fAcceptsMouseEntered = aBoolean;
    }

    public boolean getAcceptsMouseExited() {
        return this.fAcceptsMouseExited;
    }

    public void setAcceptsMouseExited(boolean aBoolean) {
        this.fAcceptsMouseExited = aBoolean;
    }

    public boolean getAcceptsMousePressed() {
        return this.fAcceptsMousePressed;
    }

    public void setAcceptsMousePressed(boolean aBoolean) {
        this.fAcceptsMousePressed = aBoolean;
    }

    public boolean getAcceptsMouseReleased() {
        return this.fAcceptsMouseReleased;
    }

    public void setAcceptsMouseReleased(boolean aBoolean) {
        this.fAcceptsMouseReleased = aBoolean;
    }

    public boolean getAcceptsMouseDragged() {
        return this.fAcceptsMouseDragged;
    }

    public void setAcceptsMouseDragged(boolean aBoolean) {
        this.fAcceptsMouseDragged = aBoolean;
    }

    public boolean getAcceptsMouseMoved() {
        return this.fAcceptsMouseMoved;
    }

    public void setAcceptsMouseMoved(boolean aBoolean) {
        this.fAcceptsMouseMoved = aBoolean;
    }

    public void rejectAllEventTypes() {
        this.fAcceptsMouseClicked = false;
        this.fAcceptsMouseDragged = false;
        this.fAcceptsMouseEntered = false;
        this.fAcceptsMouseExited = false;
        this.fAcceptsMouseMoved = false;
        this.fAcceptsMousePressed = false;
        this.fAcceptsMouseReleased = false;
    }

    public void acceptAllEventTypes() {
        this.fAcceptsMouseClicked = true;
        this.fAcceptsMouseDragged = true;
        this.fAcceptsMouseEntered = true;
        this.fAcceptsMouseExited = true;
        this.fAcceptsMouseMoved = true;
        this.fAcceptsMousePressed = true;
        this.fAcceptsMouseReleased = true;
    }

    public void acceptEverything() {
        this.acceptAllEventTypes();
        this.setAndMask(0);
        this.setOrMask(ALL_MODIFIERS_MASK);
        this.setNotMask(0);
        this.acceptAllClickCounts();
    }

    public boolean accept(ZMouseEvent aEvent) {
        if (aEvent.isConsumed()) {
            return false;
        }
        boolean aResult = false;
        int modifiers = aEvent.getModifiers();
        if (modifiers == 0 || (modifiers & this.fAndMask) == this.fAndMask && (modifiers & this.fOrMask) != 0 && (modifiers & this.fNotMask) == 0) {
            if (this.fClickCount != -1 && this.fClickCount != aEvent.getClickCount()) {
                aResult = false;
            } else {
                switch (aEvent.getID()) {
                    case 500: {
                        aResult = this.getAcceptsMouseClicked();
                        break;
                    }
                    case 504: {
                        aResult = this.getAcceptsMouseEntered();
                        break;
                    }
                    case 505: {
                        aResult = this.getAcceptsMouseExited();
                        break;
                    }
                    case 501: {
                        aResult = this.getAcceptsMousePressed();
                        break;
                    }
                    case 502: {
                        aResult = this.getAcceptsMouseReleased();
                        break;
                    }
                    case 506: {
                        aResult = this.getAcceptsMouseDragged();
                        break;
                    }
                    case 503: {
                        aResult = this.getAcceptsMouseMoved();
                        break;
                    }
                    default: {
                        throw new RuntimeException("ZMouseEvent with bad ID");
                    }
                }
            }
        }
        if (aResult && this.getConsumes()) {
            aEvent.consume();
        }
        return aResult;
    }
}

