/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.event.ZEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseMotionListener;
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class ZNavEventHandlerKeyBoard
implements ZEventHandler,
ZMouseMotionListener,
KeyListener,
Serializable {
    private boolean active = false;
    private ZNode node = null;
    private ZCanvas canvas = null;
    private boolean autoNav = false;
    private double scaleDelta = 1.25;
    private double panDelta = 25.0;
    private double autoPanXDelta;
    private double autoPanYDelta;
    private double autoZoomDelta;
    private Point2D pointerPosition;
    private int animTime = 250;
    private int zoomInKey = 33;
    private int zoomOutKey = 34;
    private int panLeftKey = 37;
    private int panRightKey = 39;
    private int panUpKey = 38;
    private int panDownKey = 40;
    private int homeKey = 36;
    private int prevKeyPress = 0;
    private int delay = 20;
    private double minMag = 0.0;
    private double maxMag = -1.0;

    public ZNavEventHandlerKeyBoard(ZNode node, ZCanvas canvas) {
        this.node = node;
        this.canvas = canvas;
        canvas.requestFocus();
        this.pointerPosition = new Point2D.Double();
    }

    public void setActive(boolean active) {
        if (this.active && !active) {
            this.active = false;
            this.node.removeMouseMotionListener(this);
            this.canvas.removeKeyListener(this);
        } else if (active) {
            this.canvas.requestFocus();
            if (!this.active) {
                this.active = true;
                this.node.addMouseMotionListener(this);
                this.canvas.addKeyListener(this);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setZoomKeys(int inKey, int outKey) {
        this.zoomInKey = inKey;
        this.zoomOutKey = outKey;
    }

    public void setPanKeys(int leftKey, int rightKey, int upKey, int downKey) {
        this.panLeftKey = leftKey;
        this.panRightKey = rightKey;
        this.panUpKey = upKey;
        this.panDownKey = downKey;
    }

    public void setHomeKey(int homeKey) {
        this.homeKey = homeKey;
    }

    public void keyPressed(KeyEvent e) {
        double delta = 0.0;
        double panX = 0.0;
        double panY = 0.0;
        boolean pan = false;
        boolean zoom = false;
        int keyCode = e.getKeyCode();
        ZCamera camera = this.canvas.getCamera();
        ZDrawingSurface surface = this.canvas.getDrawingSurface();
        if (keyCode == this.prevKeyPress) {
            if (!this.isAutoNav()) {
                if (keyCode == this.zoomInKey) {
                    this.autoZoomDelta = 1.0 + (double)0.3f * (this.scaleDelta - 1.0);
                    zoom = true;
                } else if (keyCode == this.zoomOutKey) {
                    this.autoZoomDelta = 1.0 / (1.0 + (double)0.3f * (this.scaleDelta - 1.0));
                    zoom = true;
                } else if (keyCode == this.panLeftKey) {
                    this.autoPanXDelta = 1.0 * this.panDelta / camera.getMagnification();
                    this.autoPanYDelta = 0.0;
                    pan = true;
                } else if (keyCode == this.panRightKey) {
                    this.autoPanXDelta = -1.0 * this.panDelta / camera.getMagnification();
                    this.autoPanYDelta = 0.0;
                    pan = true;
                } else if (keyCode == this.panUpKey) {
                    this.autoPanXDelta = 0.0;
                    this.autoPanYDelta = 1.0 * this.panDelta / camera.getMagnification();
                    pan = true;
                } else if (keyCode == this.panDownKey) {
                    this.autoPanXDelta = 0.0;
                    this.autoPanYDelta = -1.0 * this.panDelta / camera.getMagnification();
                    pan = true;
                }
                if (zoom || pan) {
                    surface.setInteracting(true);
                    this.startAutoNav();
                }
            }
        } else {
            if (this.isAutoNav()) {
                this.stopAutoNav();
            }
            if (keyCode == this.zoomInKey) {
                delta = this.scaleDelta;
                zoom = true;
            } else if (keyCode == this.zoomOutKey) {
                delta = 1.0 / this.scaleDelta;
                zoom = true;
            } else if (keyCode == this.panLeftKey) {
                panX = 1.0 * this.panDelta / camera.getMagnification();
                panY = 0.0;
                pan = true;
            } else if (keyCode == this.panRightKey) {
                panX = -1.0 * this.panDelta / camera.getMagnification();
                panY = 0.0;
                pan = true;
            } else if (keyCode == this.panUpKey) {
                panX = 0.0;
                panY = 1.0 * this.panDelta / camera.getMagnification();
                pan = true;
            } else if (keyCode == this.panDownKey) {
                panX = 0.0;
                panY = -1.0 * this.panDelta / camera.getMagnification();
                pan = true;
            } else if (keyCode == this.homeKey) {
                AffineTransform at = new AffineTransform();
                camera.animate(at, this.animTime, surface);
            }
            if (zoom || pan) {
                surface.setInteracting(true);
                if (zoom) {
                    double currentMag = camera.getMagnification();
                    double newMag = currentMag * delta;
                    if (newMag < this.minMag) {
                        delta = this.minMag / currentMag;
                    }
                    if (this.maxMag > 0.0 && newMag > this.maxMag) {
                        delta = this.maxMag / currentMag;
                    }
                    Point2D.Double pt = new Point2D.Double(this.pointerPosition.getX(), this.pointerPosition.getY());
                    camera.cameraToLocal(pt, null);
                    camera.scale(delta, ((Point2D)pt).getX(), ((Point2D)pt).getY(), this.animTime, surface);
                } else {
                    camera.translate(panX, panY, this.animTime, surface);
                }
                surface.setInteracting(false);
            }
        }
        this.prevKeyPress = keyCode;
    }

    public void keyReleased(KeyEvent e) {
        this.prevKeyPress = 0;
        this.autoZoomDelta = 0.0;
        this.autoPanXDelta = 0.0;
        this.autoPanYDelta = 0.0;
        if (this.isAutoNav()) {
            this.stopAutoNav();
            this.canvas.getDrawingSurface().setInteracting(false);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseMoved(ZMouseEvent e) {
        this.setZoomCenter(e.getX(), e.getY());
    }

    public void mouseDragged(ZMouseEvent e) {
        this.setZoomCenter(e.getX(), e.getY());
    }

    public void setZoomCenter(int x, int y) {
        this.pointerPosition.setLocation(x, y);
    }

    public boolean isAutoNav() {
        return this.autoNav;
    }

    public void startAutoNav() {
        if (!this.autoNav) {
            this.autoNav = true;
            this.navOneStep();
        }
    }

    public void stopAutoNav() {
        this.autoNav = false;
    }

    public void setMinMagnification(double newMinMag) {
        this.minMag = newMinMag;
    }

    public void setMaxMagnification(double newMaxMag) {
        this.maxMag = newMaxMag;
    }

    public void navOneStep() {
        ZCamera camera = this.canvas.getCamera();
        if (this.autoNav) {
            if (this.autoZoomDelta > 0.0) {
                double delta = this.autoZoomDelta;
                double currentMag = camera.getMagnification();
                double newMag = currentMag * this.autoZoomDelta;
                if (newMag < this.minMag) {
                    delta = this.minMag / currentMag;
                }
                if (this.maxMag > 0.0 && newMag > this.maxMag) {
                    delta = this.maxMag / currentMag;
                }
                Point2D.Double pt = new Point2D.Double(this.pointerPosition.getX(), this.pointerPosition.getY());
                camera.cameraToLocal(pt, null);
                camera.scale(delta, ((Point2D)pt).getX(), ((Point2D)pt).getY());
            }
            if (this.autoPanXDelta != 0.0 || this.autoPanYDelta != 0.0) {
                camera.translate(this.autoPanXDelta, this.autoPanYDelta);
            }
            try {
                Thread.sleep(20L);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ZNavEventHandlerKeyBoard.this.navOneStep();
                    }
                });
            }
            catch (InterruptedException e) {
                this.autoNav = false;
            }
        }
    }
}

