/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZSwing;
import edu.umd.cs.jazz.event.ZEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZPanEventHandler;
import edu.umd.cs.jazz.event.ZSwingEventHandler;
import edu.umd.cs.jazz.event.ZoomEventHandler;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZNodeNotFoundException;
import edu.umd.cs.jazz.util.ZNoninvertibleTransformException;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import edu.umd.cs.jazz.util.ZUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class ZCanvas
extends JComponent
implements Serializable {
    static final String SWING_WRAPPER_KEY = "Swing Wrapper";
    final MouseEvent FAKE_MOUSE_EVENT = new MouseEvent(this, 504, 0L, 0, 0, 0, 0, false);
    private ZRoot root;
    private ZCamera camera;
    private ZNode cameraNode;
    private ZDrawingSurface surface;
    private ZLayerGroup layer;
    private Cursor cursor = this.getCursor();
    private JComponent swingWrapper;
    protected ZNodeEventHandler nodeListener;
    protected ZSwingEventHandler swingEventHandler;
    protected ZPanEventHandler panEventHandler;
    protected ZoomEventHandler zoomEventHandler;
    protected boolean enableNodeEvents = false;
    protected boolean excludeMouseMoveEvents = false;

    public ZCanvas() {
        this.root = new ZRoot();
        this.camera = new ZCamera();
        this.cameraNode = new ZVisualLeaf(this.camera);
        this.surface = new ZDrawingSurface(this.camera, this.cameraNode, this);
        this.layer = new ZLayerGroup();
        this.root.addChild(this.layer);
        this.root.addChild(this.cameraNode);
        this.camera.addLayer(this.layer);
        this.init();
    }

    public ZCanvas(ZRoot aRoot, ZLayerGroup layer) {
        this.root = aRoot;
        this.camera = new ZCamera();
        this.cameraNode = new ZVisualLeaf(this.camera);
        this.surface = new ZDrawingSurface(this.camera, this.cameraNode, this);
        this.layer = layer;
        this.root.addChild(this.cameraNode);
        this.camera.addLayer(layer);
        this.init();
    }

    protected void init() {
        this.swingWrapper = new JComponent(){

            public boolean isValidateRoot() {
                return true;
            }
        };
        this.swingWrapper.putClientProperty(SWING_WRAPPER_KEY, new Object());
        this.swingWrapper.setSize(0, 0);
        this.swingWrapper.setVisible(true);
        this.add(this.swingWrapper);
        this.setEnableNodeEvents(true);
        if (!(RepaintManager.currentManager(this) instanceof ZBasicRepaintManager)) {
            RepaintManager.setCurrentManager(new ZBasicRepaintManager());
        }
        this.setNavEventHandlersActive(true);
        this.setSwingEventHandlersActive(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void paintComponent(Graphics g) {
        try {
            this.surface.paint(g);
        }
        catch (ZNoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        Rectangle bounds = this.getBounds();
        this.camera.setBounds(0, 0, (int)bounds.getWidth(), (int)bounds.getHeight());
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.camera.setFillColor(background);
    }

    public void setDrawingSurface(ZDrawingSurface aSurface) {
        this.surface = aSurface;
        this.surface.setCamera(this.camera, this.cameraNode);
        this.surface.setComponent(this);
        this.camera.repaint();
    }

    public ZDrawingSurface getDrawingSurface() {
        return this.surface;
    }

    public void setCamera(ZCamera aCamera) {
        this.camera = aCamera;
        Rectangle bounds = this.getBounds();
        this.camera.setBounds(0, 0, (int)bounds.getWidth(), (int)bounds.getHeight());
        this.camera.addLayer(this.layer);
        this.surface.setCamera(this.camera, this.cameraNode);
        boolean zoomActive = this.zoomEventHandler.isActive();
        boolean panActive = this.panEventHandler.isActive();
        boolean swingActive = this.swingEventHandler.isActive();
        this.zoomEventHandler = null;
        this.panEventHandler = null;
        this.swingEventHandler = null;
        if (zoomActive) {
            this.zoomEventHandler = new ZoomEventHandler(this.cameraNode);
            this.zoomEventHandler.setActive(true);
        }
        if (panActive) {
            this.panEventHandler = new ZPanEventHandler(this.cameraNode);
            this.panEventHandler.setActive(true);
        }
        if (swingActive) {
            this.swingEventHandler = new ZSwingEventHandler(this, this.cameraNode);
            this.swingEventHandler.setActive(true);
        }
        this.camera.repaint();
    }

    public void setCamera(ZCamera aCamera, ZNode aCameraNode) {
        this.camera = aCamera;
        this.cameraNode = aCameraNode;
        Rectangle bounds = this.getBounds();
        this.camera.setBounds(0, 0, (int)bounds.getWidth(), (int)bounds.getHeight());
        this.camera.addLayer(this.layer);
        this.surface.setCamera(this.camera, this.cameraNode);
        this.root.addChild(this.cameraNode);
        boolean zoomActive = this.zoomEventHandler.isActive();
        boolean panActive = this.panEventHandler.isActive();
        boolean swingActive = this.swingEventHandler.isActive();
        this.zoomEventHandler = null;
        this.panEventHandler = null;
        this.swingEventHandler = null;
        if (zoomActive) {
            this.zoomEventHandler = new ZoomEventHandler(this.cameraNode);
            this.zoomEventHandler.setActive(true);
        }
        if (panActive) {
            this.panEventHandler = new ZPanEventHandler(this.cameraNode);
            this.panEventHandler.setActive(true);
        }
        if (swingActive) {
            this.swingEventHandler = new ZSwingEventHandler(this, this.cameraNode);
            this.swingEventHandler.setActive(true);
        }
        this.camera.repaint();
    }

    public ZCamera getCamera() {
        return this.camera;
    }

    public ZNode getCameraNode() {
        return this.cameraNode;
    }

    public void setRoot(ZRoot aRoot) {
        this.root = aRoot;
        this.root.addChild(this.layer);
        this.root.addChild(this.cameraNode);
    }

    public ZRoot getRoot() {
        return this.root;
    }

    public void setLayer(ZLayerGroup aLayer) {
        if (this.layer != aLayer) {
            if (this.root.indexOf(aLayer) == -1) {
                this.root.addChild(aLayer);
            }
            this.camera.replaceLayer(this.layer, aLayer);
            this.layer = aLayer;
            this.camera.repaint();
        }
    }

    public ZLayerGroup getLayer() {
        return this.layer;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setAutoScrollingEnabled(boolean autoScroll) {
    }

    public Image getScreenImage(int maxDim) {
        int h;
        int w;
        if (this.getSize().getWidth() > this.getSize().getHeight()) {
            w = maxDim;
            h = (int)((double)maxDim * this.getSize().getHeight() / this.getSize().getWidth());
        } else {
            h = maxDim;
            w = (int)((double)maxDim * this.getSize().getWidth() / this.getSize().getHeight());
        }
        return this.getScreenImage(w, h);
    }

    public Image getScreenImage(int w, int h) {
        BufferedImage screenImage = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)((Image)screenImage).getGraphics();
        double dsx = (double)w / this.getSize().getWidth();
        double dsy = (double)h / this.getSize().getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(dsx, dsy);
        g2.setTransform(at);
        this.surface.paint(g2);
        return screenImage;
    }

    public void screenToGlobal(Point2D pt) {
        try {
            this.getCamera().getViewTransform().inverseTransform(pt, pt);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public void screenToGlobal(Dimension2D dimension) {
        try {
            ZUtil.inverseTransformDimension(dimension, this.getCamera().getViewTransform());
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public void screenToGlobal(Rectangle2D rectangle) {
        try {
            ZUtil.inverseTransformRectangle(rectangle, this.getCamera().getViewTransform());
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public ZEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public ZEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public void setSwingEventHandlersActive(boolean active) {
        if (active) {
            if (this.swingEventHandler == null) {
                this.swingEventHandler = new ZSwingEventHandler(this, this.cameraNode);
            }
            this.swingEventHandler.setActive(true);
        } else if (this.swingEventHandler != null) {
            this.swingEventHandler.setActive(false);
        }
    }

    public void setNavEventHandlersActive(boolean active) {
        if (active) {
            boolean swingActive = false;
            if (this.panEventHandler == null) {
                this.panEventHandler = new ZPanEventHandler(this.cameraNode);
            }
            if (this.zoomEventHandler == null) {
                this.zoomEventHandler = new ZoomEventHandler(this.cameraNode);
            }
            if (this.swingEventHandler != null && this.swingEventHandler.isActive()) {
                this.swingEventHandler.setActive(false);
                swingActive = true;
            }
            this.panEventHandler.setActive(true);
            this.zoomEventHandler.setActive(true);
            if (this.swingEventHandler != null && swingActive) {
                this.swingEventHandler.setActive(true);
            }
        } else {
            if (this.panEventHandler != null) {
                this.panEventHandler.setActive(false);
            }
            if (this.zoomEventHandler != null) {
                this.zoomEventHandler.setActive(false);
            }
        }
    }

    public JComponent getSwingWrapper() {
        return this.swingWrapper;
    }

    public ZSwingEventHandler getSwingEventHandler() {
        return this.swingEventHandler;
    }

    public void setEnableNodeEvents(boolean enable) {
        if (enable && !this.enableNodeEvents) {
            if (this.nodeListener == null) {
                this.nodeListener = new ZNodeEventHandler();
            }
            this.addMouseListener(this.nodeListener);
            this.addMouseMotionListener(this.nodeListener);
            this.enableNodeEvents = true;
        } else if (!enable && this.enableNodeEvents) {
            this.removeMouseListener(this.nodeListener);
            this.removeMouseMotionListener(this.nodeListener);
            this.enableNodeEvents = false;
            this.nodeListener = null;
        }
    }

    public final boolean getEnableNodeEvents() {
        return this.enableNodeEvents;
    }

    public boolean getExcludeMouseMoveEvents() {
        return this.excludeMouseMoveEvents;
    }

    public void setExcludeMouseMoveEvents(boolean aBoolean) {
        this.excludeMouseMoveEvents = aBoolean;
    }

    public void setCursor(Cursor c) {
        this.setCursor(c, true);
    }

    public void setCursor(Cursor c, boolean realSet) {
        if (realSet) {
            this.cursor = c;
        }
        super.setCursor(c);
    }

    public void resetCursor() {
        this.setCursor(this.cursor, false);
    }

    public void setToolTipText(String s) {
        super.setToolTipText(s);
        if (s != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolTipManager.sharedInstance().mouseEntered(ZCanvas.this.FAKE_MOUSE_EVENT);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolTipManager.sharedInstance().mouseEntered(ZCanvas.this.FAKE_MOUSE_EVENT);
                    ToolTipManager.sharedInstance().mouseExited(ZCanvas.this.FAKE_MOUSE_EVENT);
                }
            });
        }
    }

    static {
        SWING_WRAPPER_KEY = SWING_WRAPPER_KEY;
    }

    public class ZBasicRepaintManager
    extends RepaintManager {
        Vector paintingComponents = new Vector();

        public void lockRepaint(JComponent c) {
            this.paintingComponents.addElement(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlockRepaint(JComponent c) {
            Vector vector = this.paintingComponents;
            synchronized (vector) {
                this.paintingComponents.removeElementAt(this.paintingComponents.lastIndexOf(c));
            }
        }

        public boolean isPainting(JComponent c) {
            return this.paintingComponents.contains(c);
        }

        public synchronized void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            boolean captureRepaint = false;
            JComponent capturedComponent = null;
            int captureX = x;
            int captureY = y;
            Container comp = c;
            while (comp != null && comp.isLightweight() && !captureRepaint) {
                if (comp.getParent() != null && comp.getParent() instanceof JComponent && ((JComponent)comp.getParent()).getClientProperty(ZCanvas.SWING_WRAPPER_KEY) != null) {
                    if (comp instanceof JComponent) {
                        captureRepaint = true;
                        capturedComponent = comp;
                    }
                } else {
                    captureX = (int)((double)captureX + comp.getLocation().getX());
                    captureY = (int)((double)captureY + comp.getLocation().getY());
                }
                comp = comp.getParent();
            }
            if (captureRepaint) {
                ZSwing vis;
                if (!this.isPainting(capturedComponent) && (vis = (ZSwing)capturedComponent.getClientProperty("ZSwing")) != null) {
                    vis.repaint(new ZBounds(captureX, captureY, w, h));
                }
            } else {
                super.addDirtyRegion(c, x, y, w, h);
            }
        }

        public synchronized void addInvalidComponent(JComponent invalidComponent) {
            JComponent capturedComponent = invalidComponent;
            if (capturedComponent.getParent() != null && capturedComponent.getParent() instanceof JComponent && ((JComponent)capturedComponent.getParent()).getClientProperty(ZCanvas.SWING_WRAPPER_KEY) != null) {
                Runnable validater = new Runnable(this, capturedComponent){
                    private final /* synthetic */ JComponent val$capturedComponent;
                    private final /* synthetic */ ZBasicRepaintManager this$1;
                    {
                        this.this$1 = this$1;
                        this.val$capturedComponent = val$capturedComponent;
                    }

                    public void run() {
                        this.val$capturedComponent.validate();
                        ZSwing swing = (ZSwing)this.val$capturedComponent.getClientProperty("ZSwing");
                        swing.reshape();
                    }
                };
                SwingUtilities.invokeLater(validater);
            } else {
                super.addInvalidComponent(invalidComponent);
            }
        }
    }

    class ZNodeEventHandler
    implements MouseListener,
    MouseMotionListener {
        protected ZSceneGraphPath targetPath = null;
        protected ZSceneGraphPath mouseOverPath = null;
        protected ZSceneGraphPath previousPath = null;
        protected ZSceneGraphObject targetObject = null;
        protected ZSceneGraphObject currentObject = null;
        protected ZSceneGraphObject previousObject = null;

        ZNodeEventHandler() {
        }

        protected void updateMouseOverPath(MouseEvent e) {
            ZCamera camera = ZCanvas.this.surface.getCamera();
            ZRenderContext rc = camera.createRenderContext(camera);
            camera.getRoot().setCurrentRenderContext(rc);
            try {
                this.mouseOverPath = ZCanvas.this.getDrawingSurface().pick(e.getX(), e.getY());
            }
            catch (ZNoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
            this.currentObject = this.mouseOverPath.getObject();
            camera.getRoot().setCurrentRenderContext(null);
        }

        protected void updateTargetPath() {
            this.targetPath = this.mouseOverPath;
            this.targetObject = this.targetPath == null ? null : this.targetPath.getObject();
        }

        protected void checkForMouseEnteredOrExited(MouseEvent e) {
            if (ZCanvas.this.getExcludeMouseMoveEvents()) {
                return;
            }
            if (this.currentObject != this.previousObject) {
                if (this.previousObject != null) {
                    try {
                        this.dispatchEventToPath(505, e, this.previousPath);
                    }
                    catch (ZNodeNotFoundException zNodeNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.currentObject != null) {
                    this.dispatchEventToPath(504, e, this.mouseOverPath);
                }
            }
            this.previousPath = this.mouseOverPath;
            this.previousObject = this.currentObject;
        }

        public void mouseMoved(MouseEvent e) {
            if (ZCanvas.this.getExcludeMouseMoveEvents()) {
                return;
            }
            this.updateMouseOverPath(e);
            this.updateTargetPath();
            this.checkForMouseEnteredOrExited(e);
            this.dispatchEventToPath(503, e, this.targetPath);
        }

        public void mousePressed(MouseEvent e) {
            this.updateMouseOverPath(e);
            this.updateTargetPath();
            this.dispatchEventToPath(501, e, this.targetPath);
        }

        public void mouseDragged(MouseEvent e) {
            this.updateMouseOverPath(e);
            this.targetPath.updateTransform();
            this.dispatchEventToPath(506, e, this.targetPath);
        }

        public void mouseReleased(MouseEvent e) {
            this.updateMouseOverPath(e);
            this.targetPath.updateTransform();
            this.dispatchEventToPath(502, e, this.targetPath);
        }

        public void mouseClicked(MouseEvent e) {
            this.updateMouseOverPath(e);
            this.updateTargetPath();
            this.dispatchEventToPath(500, e, this.targetPath);
        }

        public void mouseExited(MouseEvent e) {
            this.mouseOverPath = null;
            this.currentObject = null;
            this.checkForMouseEnteredOrExited(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.updateMouseOverPath(e);
            this.checkForMouseEnteredOrExited(e);
        }

        protected void dispatchEventToPath(int id, MouseEvent e, ZSceneGraphPath aPath) {
            ZMouseEvent aNewEvent = ZMouseEvent.createMouseEvent(id, e, aPath, this.mouseOverPath);
            try {
                aPath.processMouseEvent(aNewEvent);
            }
            catch (ZNoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
    }
}

