/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Graph
extends Canvas {
    private short[] Samples;
    private int[] Display;
    public boolean DispChange;
    private Color ZeroColor;
    private Selection Sel;
    private Zoom zoom;
    private Color SelColor;
    private Color SelPointColor;
    private Color GraphColor;
    private Color BackgroundColor;
    private Color PosPointerColor;
    private int FWidth;
    private int FHeight;
    private double Min;
    private double Max;
    private double Zero;

    /*
     * Exception decompiling
     */
    public Graph() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Attempt to fetch element 0 from constant pool
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPool.getEntry(ConstantPool.java:155)
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPool.getUTF8Entry(ConstantPool.java:164)
         *     at org.benf.cfr.reader.bytecode.analysis.variables.VariableNamerHinted.getName(VariableNamerHinted.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable.<init>(LocalVariable.java:34)
         *     at org.benf.cfr.reader.bytecode.analysis.variables.VariableFactory.localVariable(VariableFactory.java:81)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.mkRetrieve(Op02WithProcessedDataAndRefs.java:935)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:983)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void reset(short[] sArray) {
        if (sArray == null || sArray.length == 0) {
            this.removeAll();
            return;
        }
        this.Samples = sArray;
        this.Max = 32768.0;
        this.Min = -32767.0;
        this.Zero = 0.0;
        this.DispChange = true;
    }

    public void init(short[] sArray) {
        this.reset(sArray);
        if (this.Samples != null) {
            this.zoom.start = 0;
            this.zoom.end = this.Samples.length - 1;
            this.Sel.start = 0;
            this.Sel.end = 0;
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            this.Sel.side = 0;
            this.invalidate();
            this.repaint();
        }
    }

    public void DonneesChanges(short[] sArray) {
        this.reset(sArray);
        if (this.Samples != null) {
            this.zoom.start = Math.min(this.Samples.length - 1, this.zoom.start);
            this.zoom.end = Math.min(this.Samples.length - 1, this.zoom.end);
            this.Sel.start = Math.min(this.Samples.length - 1, this.Sel.start);
            this.Sel.end = Math.min(this.Samples.length - 1, this.Sel.end);
            this.invalidate();
            this.repaint();
        }
    }

    public void removeAll() {
        this.Samples = null;
        this.Sel.start = 0;
        this.Sel.end = 0;
        this.zoom.start = 0;
        this.zoom.end = 0;
        this.Display = null;
        this.invalidate();
        this.repaint();
    }

    public void redraw() {
        this.DispChange = true;
        if (this.Samples != null) {
            Graphics graphics;
            if (this.DispChange) {
                this.Display = new int[this.FWidth + 1];
            }
            if ((graphics = this.getGraphics()) != null) {
                this.paintPart(this.getGraphics(), 0, this.Samples.length - 1);
                graphics.dispose();
            }
        } else {
            this.repaint();
        }
        this.DispChange = false;
    }

    public void setSelection(Selection selection) {
        this.Sel = selection;
    }

    public Selection getSelection() {
        return this.Sel;
    }

    public int getSampleSize() {
        return this.Samples.length;
    }

    public Zoom getZoom() {
        return this.zoom;
    }

    public void setZoom(Zoom zoom) {
        this.zoom = zoom;
    }

    public int pixelOneSample() {
        return Math.max(this.FWidth / (this.zoom.end - this.zoom.start + 1), 1);
    }

    public int samplesOnePixel() {
        return (this.zoom.end - this.zoom.start + 1) / this.FWidth;
    }

    public int toPixelY(int n) {
        return this.FHeight - 1 - (int)((double)((long)((double)n - this.Min) * (long)this.FHeight) / Math.abs(this.Max - this.Min));
    }

    public int toSamplesX(int n) {
        return (int)((long)n * (long)(this.zoom.end - this.zoom.start + 1) / (long)this.FWidth + (long)this.zoom.start);
    }

    public int toPixelX(int n) {
        return (int)((long)(n - this.zoom.start) * (long)this.FWidth / (long)(this.zoom.end - this.zoom.start + 1));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.FWidth = n3;
        this.FHeight = n4;
        super.setBounds(n, n2, n3, n4);
        if (this.FWidth == 0) {
            this.FWidth = 1;
        }
        if (this.FHeight == 0) {
            this.FHeight = 1;
        }
    }

    public synchronized void invalidate() {
        this.DispChange = true;
        super.invalidate();
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            if (!bl) {
                super.invalidate();
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (graphics != null) {
            if (this.Samples != null) {
                if (this.DispChange) {
                    this.Display = new int[this.FWidth + 1];
                    this.paintPart(graphics, 0, this.Samples.length - 1);
                    this.DispChange = false;
                    return;
                }
                Rectangle rectangle = graphics.getClip().getBounds();
                this.paintPart(graphics, this.toSamplesX(rectangle.x - 1), this.toSamplesX(rectangle.x + rectangle.width + 1));
                return;
            }
            graphics.clearRect(0, 0, this.FWidth, this.FHeight);
        }
    }

    private synchronized void paintPart(Graphics graphics, int n, int n2) {
        if (graphics != null) {
            if (this.Samples != null) {
                int n3 = Math.min(Math.max(this.toPixelX(n), 0), this.FWidth);
                int n4 = Math.max(Math.min(this.toPixelX(n2) + this.pixelOneSample(), this.FWidth), 0);
                if (this.Sel.onePoint() || this.Sel.start > n2 || this.Sel.end < n) {
                    graphics.clearRect(n3, 0, n4 - n3 + 1, this.FHeight);
                } else {
                    int n5 = Math.max(this.toPixelX(this.Sel.start), n3);
                    int n6 = Math.min(this.toPixelX(this.Sel.end) + this.pixelOneSample(), n4);
                    n5 = Math.min(n5, n4);
                    n6 = Math.max(n6, n3);
                    if (n5 > n3) {
                        graphics.clearRect(n3, 0, n5 - n3, this.FHeight);
                    }
                    if (n6 < n4) {
                        graphics.clearRect(n6, 0, n4 - n6, this.FHeight);
                    }
                    if (!this.isEnabled()) {
                        graphics.setColor(this.getBackground());
                    } else {
                        graphics.setColor(this.SelColor);
                    }
                    graphics.fillRect(n5, 0, n6 - n5, this.FHeight);
                }
                if (!this.isEnabled()) {
                    graphics.setColor(Color.gray);
                } else {
                    graphics.setColor(this.ZeroColor);
                }
                graphics.drawLine(n3, this.toPixelY((short)this.Zero), n4, this.toPixelY((short)this.Zero));
                if (!this.isEnabled()) {
                    graphics.setColor(Color.darkGray);
                } else {
                    graphics.setColor(this.getForeground());
                }
                this.draw(graphics, n3 - 1, n4 + 1);
                if (this.Sel.onePoint() && n <= this.Sel.start && n2 >= this.Sel.end && this.Sel.start != 0 && this.isEnabled()) {
                    graphics.setColor(this.SelPointColor);
                    graphics.drawLine(this.toPixelX(this.Sel.start), 0, this.toPixelX(this.Sel.start), this.FHeight);
                    return;
                }
            } else {
                graphics.clearRect(0, 0, this.FWidth, this.FHeight);
            }
        }
    }

    public synchronized void paintPart(int n, int n2) {
        if (this.DispChange) {
            this.repaint();
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintPart(graphics, n, n2);
            graphics.dispose();
        }
    }

    public synchronized void paintPart(int n) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintPart(graphics, n);
            graphics.dispose();
        }
    }

    public synchronized void paintPart(Graphics graphics, int n) {
        this.DispChange = true;
        if (n < 0) {
            this.paintPart(graphics, this.zoom.start, this.zoom.start - n + this.samplesOnePixel() + 1);
            return;
        }
        this.paintPart(graphics, this.zoom.end - n - this.samplesOnePixel() - 1, this.zoom.end);
    }

    public synchronized void paintLine(int n) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintPart(graphics, n, n + this.samplesOnePixel() + 1);
            graphics.dispose();
        }
    }

    public synchronized void paintPositionPointer(int n) {
        Graphics graphics;
        if (this.isEnabled() && (graphics = this.getGraphics()) != null) {
            graphics.setColor(this.PosPointerColor);
            n = this.toPixelX(n);
            graphics.drawLine(n, 0, n, this.FHeight);
            graphics.dispose();
        }
    }

    private int calculateMeanValue(int n) {
        int n2 = this.toSamplesX(n);
        if (n2 >= this.Samples.length) {
            return this.toPixelY(this.Samples[this.Samples.length - 1]);
        }
        if (n2 <= 0) {
            return this.toPixelY(this.Samples[0]);
        }
        int n3 = Math.max(this.zoom.start, n2 - (short)((this.zoom.end - this.zoom.start + 1) / this.FWidth / 2));
        int n4 = Math.min(this.zoom.end, n2 + (short)((this.zoom.end - this.zoom.start + 1) / this.FWidth / 2));
        if (n % 2 == 0) {
            int n5 = Short.MAX_VALUE;
            int n6 = n3;
            while (n6 <= n4) {
                n5 = (short)Math.min(n5, this.Samples[n6]);
                ++n6;
            }
            return this.toPixelY(n5);
        }
        int n7 = Short.MIN_VALUE;
        int n8 = n3;
        while (n8 <= n4) {
            n7 = (short)Math.max(n7, this.Samples[n8]);
            ++n8;
        }
        return this.toPixelY(n7);
    }

    private void draw(Graphics graphics, int n, int n2) {
        n = Math.min(Math.max(n, 0), this.FWidth);
        n2 = Math.min(Math.max(n2, 0), this.FWidth);
        int n3 = -2;
        try {
            if (this.DispChange) {
                this.Display[n] = this.calculateMeanValue(n);
                n3 = n + 1;
                while (n3 <= n2) {
                    this.Display[n3] = this.calculateMeanValue(n3);
                    graphics.drawLine(n3 - 1, this.Display[n3 - 1], n3, this.Display[n3]);
                    ++n3;
                }
                return;
            }
            n3 = n + 1;
            while (n3 <= n2) {
                graphics.drawLine(n3 - 1, this.Display[n3 - 1], n3, this.Display[n3]);
                ++n3;
            }
            return;
        }
        catch (Throwable throwable) {
            Globals.debugOut(throwable, "Error in Graph (x=" + n3 + ", Display.length=" + this.Display.length + ", FWidth=" + this.FWidth + ")");
            return;
        }
    }
}

