/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class WaveFileBase {
    protected static final int LEFT = 1;
    protected static final int RIGHT = 2;
    protected static final int STEREO = 3;
    protected static final int MONO = 4;
    private static final int MAGIC_RIFF = 1380533830;
    private static final int MAGIC_AU = 779316836;
    private static final int KEY_WAVE = 1463899717;
    private static final int FMT_ = 1718449184;
    private static final int DATA = 1684108385;
    private static final int LIST = 1279873876;
    protected static String sftName = "Wavefile by JaWavedit";
    private static final int INFO = 1229866575;
    private static final int INAM = 1229865293;
    private static final int ISFT = 1230194260;
    public static String NOT_SUPPORTED_S = "The format of %s is not supported";
    public static String IS_CORRUPT_S = "%s is corrupt.";
    public static String ERROR_OPENING_S = "Error opening %s.";
    public static String ERROR_SAVING_S = "Error saving %s.";
    public static String NOT_CREATE = "You did not create or load a wavefile.";
    public static String NEITHER_WAV_AU_S = "%s is neither .wav nor .au";
    public short[] Wave;
    protected int frequency;
    private static int defaultFrequency = 8000;
    protected short resolution;
    protected static short defaultResolution = (short)8;
    protected short channel_count;
    protected static short default_channel_count = 1;
    protected String name;
    private static String defaultName = "new.au";
    protected String description;
    protected Vector otherChunks;
    protected short[] leftWave;
    protected short[] rightWave;
    protected boolean changed;

    /*
     * Exception decompiling
     */
    public WaveFileBase() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Attempt to fetch element 0 from constant pool
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPool.getEntry(ConstantPool.java:155)
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPool.getUTF8Entry(ConstantPool.java:164)
         *     at org.benf.cfr.reader.bytecode.analysis.variables.VariableNamerHinted.getName(VariableNamerHinted.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable.<init>(LocalVariable.java:34)
         *     at org.benf.cfr.reader.bytecode.analysis.variables.VariableFactory.localVariable(VariableFactory.java:81)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.mkRetrieve(Op02WithProcessedDataAndRefs.java:935)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:983)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void resetParams() {
        this.setFrequency(defaultFrequency);
        this.resolution = defaultResolution;
        this.channel_count = default_channel_count;
        this.rightWave = new short[0];
        this.leftWave = new short[0];
        this.name = defaultName;
        this.description = defaultName;
        this.otherChunks = new Vector();
        this.setChanged(false);
    }

    public void createNew(int n, short[] sArray) {
        this.createNew(n, sArray, sArray);
    }

    public void createNew(int n, short[] sArray, short[] sArray2) {
        this.resetParams();
        this.setFrequency(n);
        this.setWaves(sArray, sArray2);
    }

    public void createNew() {
        this.resetParams();
    }

    private int readIntAndSwap(RandomAccessFile randomAccessFile) throws IOException {
        return randomAccessFile.readUnsignedByte() | randomAccessFile.readUnsignedByte() << 8 | randomAccessFile.readUnsignedByte() << 16 | randomAccessFile.readUnsignedByte() << 24;
    }

    private short readShortAndSwap(RandomAccessFile randomAccessFile) throws IOException {
        return (short)(randomAccessFile.readUnsignedByte() | randomAccessFile.readUnsignedByte() << 8);
    }

    private void uLawToLinear(byte[] byArray) {
        if (byArray == null) {
            this.leftWave = null;
            this.rightWave = null;
            return;
        }
        this.leftWave = new short[byArray.length / this.channel_count];
        this.rightWave = new short[byArray.length / this.channel_count];
        if (this.channel_count == 1) {
            int n = 0;
            while (n < byArray.length) {
                this.leftWave[n] = WaveTool.ulaw2linear(byArray[n]);
                ++n;
            }
            System.arraycopy(this.leftWave, 0, this.rightWave, 0, this.leftWave.length);
            return;
        }
        int n = 0;
        while (n < this.leftWave.length) {
            this.leftWave[n] = WaveTool.ulaw2linear(byArray[n * 2]);
            this.rightWave[n] = WaveTool.ulaw2linear(byArray[n * 2 + 1]);
            ++n;
        }
    }

    private long searchNextChunk(RandomAccessFile randomAccessFile, long l) {
        long l2 = -1L;
        try {
            randomAccessFile.seek(l);
            randomAccessFile.readInt();
            int n = this.readIntAndSwap(randomAccessFile);
            randomAccessFile.skipBytes(n + 1 & 0xFFFFFFFE);
            if (randomAccessFile.getFilePointer() < randomAccessFile.length() && n > 0) {
                l2 = randomAccessFile.getFilePointer();
            }
        }
        catch (Exception exception) {}
        return l2;
    }

    protected String readText(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte by;
        String string = "";
        while (n > 0 && (by = randomAccessFile.readByte()) != 0) {
            string = String.valueOf(string) + (char)by;
            --n;
        }
        return string;
    }

    private void readFormatChunk(RandomAccessFile randomAccessFile, int n) throws IOException {
        if (n < 16) {
            throw new IOException(String.valueOf(StringTool.sprintf(IS_CORRUPT_S, this.name)) + " (wrong fmt-chunk)");
        }
        short s = this.readShortAndSwap(randomAccessFile);
        if (s != 1) {
            throw new IOException(String.valueOf(StringTool.sprintf(NOT_SUPPORTED_S, this.name)) + " (format)");
        }
        this.channel_count = this.readShortAndSwap(randomAccessFile);
        if (this.channel_count != 2 && this.channel_count != 1) {
            throw new IOException(String.valueOf(StringTool.sprintf(NOT_SUPPORTED_S, this.name)) + " (channelCount)");
        }
        this.setFrequency(this.readIntAndSwap(randomAccessFile));
        randomAccessFile.readInt();
        randomAccessFile.readShort();
        this.resolution = this.readShortAndSwap(randomAccessFile);
        if (this.resolution != 8 && this.resolution != 16) {
            throw new IOException(String.valueOf(StringTool.sprintf(IS_CORRUPT_S, this.name)) + " (resolution)");
        }
    }

    private void readDataChunk(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte[] byArray = new byte[n];
        n = randomAccessFile.read(byArray);
        n = this.resolution == 16 ? (n >>= this.channel_count) : (n /= this.channel_count);
        this.leftWave = new short[n];
        this.rightWave = new short[n];
        if (this.channel_count == 1) {
            if (this.resolution == 16) {
                int n2 = 0;
                while (n2 < n) {
                    this.leftWave[n2] = (short)((short)byArray[n2 << 1] & 0xFF | (short)(byArray[(n2 << 1) + 1] << 8) & 0xFF00);
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < n) {
                    this.leftWave[n3] = (short)(byArray[n3] - 128 << 8);
                    ++n3;
                }
            }
            System.arraycopy(this.leftWave, 0, this.rightWave, 0, n);
            return;
        }
        if (this.resolution == 16) {
            int n4 = 0;
            while (n4 < n) {
                this.leftWave[n4] = (short)((short)byArray[n4 << 2] & 0xFF | (short)(byArray[(n4 << 2) + 1] << 8) & 0xFF00);
                this.rightWave[n4] = (short)((short)byArray[(n4 << 2) + 2] & 0xFF | (short)(byArray[(n4 << 2) + 3] << 8) & 0xFF00);
                ++n4;
            }
            return;
        }
        int n5 = 0;
        while (n5 < n) {
            this.leftWave[n5] = (short)(byArray[n5 << 1] - 128 << 8);
            this.rightWave[n5] = (short)(byArray[(n5 << 1) + 1] - 128 << 8);
            ++n5;
        }
    }

    private void readListChunk(RandomAccessFile randomAccessFile, int n) throws IOException {
        long l = randomAccessFile.getFilePointer() + (long)n;
        if (randomAccessFile.readInt() == 1229866575) {
            while (randomAccessFile.getFilePointer() < l) {
                int n2 = randomAccessFile.readInt();
                int n3 = this.readIntAndSwap(randomAccessFile);
                long l2 = randomAccessFile.getFilePointer() + (long)n3;
                switch (n2) {
                    case 1229865293: {
                        this.description = this.readText(randomAccessFile, n);
                        break;
                    }
                }
                randomAccessFile.seek(l2);
            }
        }
    }

    protected void readOtherChunk(RandomAccessFile randomAccessFile, int n, int n2) throws IOException {
        if (n2 < 8) {
            return;
        }
        randomAccessFile.seek(randomAccessFile.getFilePointer() - 8L);
        byte[] byArray = new byte[n2 + 8];
        try {
            if (randomAccessFile.read(byArray) == n2 + 8) {
                this.otherChunks.addElement(byArray);
                return;
            }
        }
        catch (Exception exception) {}
    }

    private String getChunkString(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)((n >>= 8) & 0xFF);
        byArray[1] = (byte)((n >>= 8) & 0xFF);
        byArray[0] = (byte)((n >>= 8) & 0xFF);
        return new String(byArray);
    }

    public void load(String string) throws WaveFileException {
        if (string != null) {
            RandomAccessFile randomAccessFile;
            try {
                randomAccessFile = new RandomAccessFile(string, "r");
            }
            catch (Exception exception) {
                throw new WaveFileException(StringTool.sprintf(ERROR_OPENING_S, string));
            }
            this.resetParams();
            this.setName(string);
            try {
                try {
                    int n = randomAccessFile.readInt();
                    if (n == 1380533830) {
                        int n2 = this.readIntAndSwap(randomAccessFile);
                        int n3 = randomAccessFile.readInt();
                        if (n3 != 1463899717) {
                            throw new WaveFileException(String.valueOf(StringTool.sprintf(IS_CORRUPT_S, this.name)) + " (no Wave key)");
                        }
                        long l = 12L;
                        boolean bl = false;
                        boolean bl2 = false;
                        randomAccessFile.seek(l);
                        do {
                            int n4;
                            if ((n4 = randomAccessFile.readInt()) == 0 || randomAccessFile.getFilePointer() >= (long)n2 || randomAccessFile.getFilePointer() >= randomAccessFile.length() - 4L) continue;
                            int n5 = this.readIntAndSwap(randomAccessFile);
                            switch (n4) {
                                case 1718449184: {
                                    this.readFormatChunk(randomAccessFile, n5);
                                    bl = true;
                                    break;
                                }
                                case 1684108385: {
                                    if (!bl2) {
                                        if (!bl) {
                                            throw new WaveFileException(String.valueOf(StringTool.sprintf(IS_CORRUPT_S, string)) + ": data before fmt chunk");
                                        }
                                        this.readDataChunk(randomAccessFile, n5);
                                        bl2 = true;
                                        break;
                                    }
                                    this.readOtherChunk(randomAccessFile, n4, n5);
                                    break;
                                }
                                case 1279873876: {
                                    this.readListChunk(randomAccessFile, n5);
                                    break;
                                }
                                default: {
                                    this.readOtherChunk(randomAccessFile, n4, n5);
                                }
                            }
                        } while ((l = this.searchNextChunk(randomAccessFile, l)) > 12L);
                        if (!bl) {
                            throw new WaveFileException(String.valueOf(StringTool.sprintf(IS_CORRUPT_S, string)) + ": no fmt chunk");
                        }
                        if (!bl2) {
                            throw new WaveFileException(String.valueOf(StringTool.sprintf(IS_CORRUPT_S, string)) + ": no data chunk");
                        }
                        this.setChanged(false);
                    } else if (n == 779316836) {
                        int n6 = randomAccessFile.readInt();
                        int n7 = randomAccessFile.readInt();
                        if (randomAccessFile.readInt() != 1) {
                            throw new WaveFileException(String.valueOf(StringTool.sprintf(NOT_SUPPORTED_S, string)) + " (format)");
                        }
                        this.setFrequency(randomAccessFile.readInt());
                        this.channel_count = (short)randomAccessFile.readInt();
                        this.resolution = (short)16;
                        if (this.channel_count != 1 && this.channel_count != 2) {
                            throw new WaveFileException(String.valueOf(StringTool.sprintf(NOT_SUPPORTED_S, string)) + " (channelCount)");
                        }
                        this.description = this.readText(randomAccessFile, n6 - 24);
                        randomAccessFile.seek(n6);
                        byte[] byArray = new byte[n7];
                        n7 = randomAccessFile.read(byArray);
                        this.uLawToLinear(byArray);
                        this.setChanged(false);
                    } else {
                        throw new WaveFileException(StringTool.sprintf(NOT_SUPPORTED_S, string));
                    }
                    Object var4_14 = null;
                }
                catch (Throwable throwable) {
                    Object var4_15 = null;
                    randomAccessFile.close();
                    throw throwable;
                }
                randomAccessFile.close();
                return;
            }
            catch (IOException iOException) {
                throw new WaveFileException(iOException.getMessage());
            }
        }
    }

    private void swapAndWriteInt(RandomAccessFile randomAccessFile, int n) throws IOException {
        randomAccessFile.writeByte(n & 0xFF);
        randomAccessFile.writeByte(n >> 8 & 0xFF);
        randomAccessFile.writeByte(n >> 16 & 0xFF);
        randomAccessFile.writeByte(n >> 24 & 0xFF);
    }

    private void swapAndWriteShort(RandomAccessFile randomAccessFile, short s) throws IOException {
        randomAccessFile.writeByte(s & 0xFF);
        randomAccessFile.writeByte(s >> 8 & 0xFF);
    }

    protected void writeText(RandomAccessFile randomAccessFile, String string) throws IOException {
        randomAccessFile.writeBytes(string);
        randomAccessFile.writeByte(0);
        if (string.length() % 2 == 0) {
            randomAccessFile.writeByte(0);
        }
    }

    protected int getTextLength(String string) {
        return string.length() + 2 & 0xFFFFFFFE;
    }

    private byte[] toULaw(int n) {
        if (this.leftWave != null) {
            return this.toULaw(0, this.leftWave.length - 1, n);
        }
        return null;
    }

    private byte[] toULaw(int n, int n2, int n3) {
        if (this.leftWave == null || n2 - n < 1 || this.leftWave.length < n2) {
            return null;
        }
        byte[] byArray = n3 == 3 ? new byte[(n2 - n + 1) * 2] : new byte[n2 - n + 1];
        switch (n3) {
            case 1: {
                int n4 = n;
                while (n4 <= n2) {
                    byArray[n4 - n] = WaveTool.linear2ulaw(this.leftWave[n4]);
                    ++n4;
                }
                break;
            }
            case 2: {
                int n5 = n;
                while (n5 <= n2) {
                    byArray[n5 - n] = WaveTool.linear2ulaw(this.rightWave[n5]);
                    ++n5;
                }
                break;
            }
            case 3: {
                int n6 = n;
                while (n6 <= n2) {
                    byArray[(n6 - n) * 2] = WaveTool.linear2ulaw(this.leftWave[n6]);
                    byArray[(n6 - n) * 2 + 1] = WaveTool.linear2ulaw(this.rightWave[n6]);
                    ++n6;
                }
                break;
            }
            case 4: {
                int n7 = n;
                while (n7 <= n2) {
                    byArray[n7 - n] = WaveTool.linear2ulaw((int)((long)this.leftWave[n7] + (long)this.rightWave[n7]) / 2);
                    ++n7;
                }
                break;
            }
        }
        return byArray;
    }

    private void writeFormatChunk(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(1718449184);
        this.swapAndWriteInt(randomAccessFile, 18);
        this.swapAndWriteShort(randomAccessFile, (short)1);
        this.swapAndWriteShort(randomAccessFile, this.channel_count);
        this.swapAndWriteInt(randomAccessFile, this.frequency);
        this.swapAndWriteInt(randomAccessFile, this.frequency * 2 * this.channel_count);
        this.swapAndWriteShort(randomAccessFile, (short)(this.channel_count * 2));
        this.swapAndWriteShort(randomAccessFile, this.resolution);
        this.swapAndWriteShort(randomAccessFile, (short)(this.resolution / 8 * this.channel_count));
    }

    private void writeDataChunk(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(1684108385);
        int n = this.leftWave.length * (this.resolution / 8) * this.channel_count;
        this.swapAndWriteInt(randomAccessFile, n);
        n = n + 1 & 0xFFFFFFFE;
        byte[] byArray = new byte[n];
        if (this.channel_count == 1) {
            int n2 = 0;
            while (n2 < this.leftWave.length) {
                short s = (short)Math.min(Math.max(((long)this.leftWave[n2] + (long)this.rightWave[n2]) / 2L, -32768L), 32767L);
                if (this.resolution == 16) {
                    byArray[n2 * 2] = (byte)(s & 0xFF);
                    byArray[n2 * 2 + 1] = (byte)(s >> 8 & 0xFF);
                } else {
                    byArray[n2] = (byte)((s >> 8) + 128 & 0xFF);
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.leftWave.length) {
                if (this.resolution == 16) {
                    byArray[n3 * 4] = (byte)(this.leftWave[n3] & 0xFF);
                    byArray[n3 * 4 + 1] = (byte)(this.leftWave[n3] >> 8 & 0xFF);
                    byArray[n3 * 4 + 2] = (byte)(this.rightWave[n3] & 0xFF);
                    byArray[n3 * 4 + 3] = (byte)(this.rightWave[n3] >> 8 & 0xFF);
                } else {
                    byArray[n3 * 2] = (byte)((this.leftWave[n3] >> 8) + 128 & 0xFF);
                    byArray[n3 * 2 + 1] = (byte)((this.rightWave[n3] >> 8) + 128 & 0xFF);
                }
                ++n3;
            }
        }
        randomAccessFile.write(byArray);
    }

    protected void writeOtherChunks(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = null;
        int n = 0;
        while (n < this.otherChunks.size()) {
            byArray = (byte[])this.otherChunks.elementAt(n);
            randomAccessFile.write(byArray);
            if (byArray.length % 2 == 1) {
                randomAccessFile.writeByte(0);
            }
            ++n;
        }
    }

    private void writeListChunk(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(1279873876);
        long l = randomAccessFile.getFilePointer();
        randomAccessFile.writeInt(0);
        randomAccessFile.writeInt(1229866575);
        randomAccessFile.writeInt(1229865293);
        this.swapAndWriteInt(randomAccessFile, this.getTextLength(this.getDescription()));
        this.writeText(randomAccessFile, this.getDescription());
        randomAccessFile.writeInt(1230194260);
        this.swapAndWriteInt(randomAccessFile, this.getTextLength(sftName));
        this.writeText(randomAccessFile, sftName);
        long l2 = randomAccessFile.getFilePointer();
        randomAccessFile.seek(l);
        this.swapAndWriteInt(randomAccessFile, (int)(l2 - l - 4L));
        randomAccessFile.seek(l2);
    }

    public void save() throws WaveFileException {
        RandomAccessFile randomAccessFile;
        if (this.isEmpty()) {
            throw new WaveFileException(NOT_CREATE);
        }
        File file = new File(this.name);
        if (file.exists()) {
            file.delete();
        }
        try {
            randomAccessFile = new RandomAccessFile(this.name, "rw");
        }
        catch (Exception exception) {
            throw new WaveFileException(StringTool.sprintf(ERROR_SAVING_S, this.name));
        }
        try {
            try {
                if ("au".equals(this.getCoding())) {
                    randomAccessFile.writeInt(779316836);
                    randomAccessFile.writeInt(24 + this.getTextLength(this.getDescription()));
                    randomAccessFile.writeInt(this.leftWave.length * this.channel_count);
                    randomAccessFile.writeInt(1);
                    randomAccessFile.writeInt(this.frequency);
                    randomAccessFile.writeInt(this.channel_count);
                    this.writeText(randomAccessFile, this.getDescription());
                    randomAccessFile.write(this.toULaw(this.channel_count == 1 ? 4 : 3));
                } else if ("wav".equals(this.getCoding())) {
                    randomAccessFile.writeInt(1380533830);
                    randomAccessFile.writeInt(0);
                    randomAccessFile.writeInt(1463899717);
                    this.writeFormatChunk(randomAccessFile);
                    this.writeDataChunk(randomAccessFile);
                    this.writeListChunk(randomAccessFile);
                    this.writeOtherChunks(randomAccessFile);
                    int n = (int)randomAccessFile.getFilePointer() - 8;
                    randomAccessFile.seek(4L);
                    this.swapAndWriteInt(randomAccessFile, n);
                } else {
                    throw new WaveFileException(StringTool.sprintf(NEITHER_WAV_AU_S, this.name));
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                randomAccessFile.close();
                throw throwable;
            }
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw new WaveFileException(iOException.getMessage());
        }
        this.setChanged(false);
    }

    public short[] getLeftWave() {
        return this.leftWave;
    }

    public short[] getRightWave() {
        return this.rightWave;
    }

    public synchronized void setWaves(short[] sArray, short[] sArray2) {
        this.setChanged(true);
        if (sArray == null || sArray2 == null) {
            this.resetParams();
            return;
        }
        this.leftWave = sArray;
        this.rightWave = sArray2;
    }

    public int getSize() {
        if (this.leftWave != null) {
            return this.leftWave.length;
        }
        return 0;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int setFrequency(int n) {
        if (n < 0) {
            this.frequency = defaultFrequency;
        }
        if (n != this.frequency) {
            this.setChanged(true);
            this.frequency = n;
        }
        return this.frequency;
    }

    public String getCoding() {
        int n = this.name.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        if (n == this.name.length()) {
            return "";
        }
        return this.name.substring(n + 1, this.name.length()).toLowerCase();
    }

    public void setCoding(String string) {
        String string2;
        int n = this.name.lastIndexOf(".");
        if (n == -1) {
            n = this.name.length();
        }
        if (!(string2 = String.valueOf(this.name.substring(0, n)) + "." + string).equals(this.name)) {
            this.setName(string2);
            this.setChanged(true);
        }
    }

    public boolean isEmpty() {
        if (this.name == null) {
            return true;
        }
        if (this.leftWave == null || this.rightWave == null || this.name == "") {
            return true;
        }
        return this.leftWave.length == 0 || this.rightWave.length == 0;
    }

    public short getResolution() {
        return this.resolution;
    }

    public short setResolution(short s) {
        if ((s == 16 || s == 8) && s != this.resolution) {
            this.resolution = s;
            this.setChanged(true);
        }
        return this.resolution;
    }

    public short getChannelCount() {
        return this.channel_count;
    }

    public short setChannelCount(short s) {
        if ((s == 1 || s == 2) && s != this.channel_count) {
            this.channel_count = s;
            this.setChanged(true);
        }
        return this.channel_count;
    }

    public boolean isMono() {
        return this.channel_count == 1;
    }

    public boolean isStereo() {
        return this.channel_count == 2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.name != "") {
            this.name = string;
        }
    }

    public String getDescription() {
        if (this.description == "" || this.description.equals(defaultName)) {
            return this.name;
        }
        return this.description;
    }

    public void setDescription(String string) {
        if (!this.description.equals(string)) {
            this.description = string;
            this.setChanged(true);
        }
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    protected void setSFTName(String string) {
        sftName = string;
    }

    public long samplesToMs(int n) {
        return (long)n * 1000L / (long)this.frequency;
    }

    public int msToSamples(long l) {
        return (int)(l * (long)this.frequency / 1000L);
    }

    public String extractFileName() {
        if (this.name == null) {
            return null;
        }
        int n = this.name.lastIndexOf(System.getProperty("file.separator"));
        if (n <= 0) {
            return this.name;
        }
        return this.name.substring(n + 1);
    }

    public String extractFilePath() {
        if (this.name == null) {
            return null;
        }
        int n = this.name.lastIndexOf(System.getProperty("file.separator"));
        if (n <= 0) {
            return this.name;
        }
        return this.name.substring(0, n + 1);
    }
}

