/* *******************************************************
 * 
 * name:          Delay.java
 * 
 * description:   Provides a generic method for a delay
 *                It is used in the demos of SimpleModule.
 *
 * Author:        Florian Bomers
 *
 * (c) by         Florian Boemers  fbomers@erato.unice.fr
 *                  or JaWavedit@bome.com
 *                Robin Pouget     rpouget@erato.unice.fr
 *                Niels Thorwirth  niels-t@usa.net
 *
 ********************************************************* */


import java.awt.Frame;
import java.awt.Cursor;

public class Delay {



	/*
	* Avoids clipping. (values>32767 respectively <-32768 are truncated)
	*
	* fait le clipping, qui est necessaire pour des
	*  samples.
	*/
	private static short trimShort(int val) {
		if (val>32767)
			return 32767;
		else
		if (val<-32768)
			return -32768;
		else return (short) val;
	}
  
  
  public static void delay(WaveFile wf,int debut, int fin,
    int nbRepetitions,      //number of repetitions
    int amortissement,      //Amount (in percent) of which each repetition gets softer
      int duree,            //Length of one repetition in milliseconds
      int initDuree,        //Time before first repetition in milliseconds
      boolean extend)       //wether to extend the wavefile with the last repetitions
  {
    // transform the values in milliseconds to samples.
    duree=wf.msToSamples(duree);
    initDuree=wf.msToSamples(initDuree);
      
    //array which contains only the delay
    int echoWave[]=new int[fin-debut+1+duree*nbRepetitions+initDuree];
    
    //1st part: Calculate the delay  
    for (int c=debut; c<=fin; c++) {
      int amo=100;        // first volume is 100%
      for (int r=0; r<nbRepetitions; r++) {
        amo=amo*amortissement/100; //new volume
        //mixing the original samples
        echoWave[c-debut+(r*duree)+initDuree]+=wf.Wave[c]*amo/100;
      }
    }
    
    //2nd part: Mix with original data
    
    //total length of this delay
    int longeurDelay=(nbRepetitions-1)*duree+initDuree;
    
    if (extend && (longeurDelay+fin<wf.Wave.length))
      extend=false; // it's not necessary to extend the wavefile
    
    if (extend) {	//when need to extend, create a new array
      short newWave[]=new short[longeurDelay+fin]; // the resulting array
    	//first copy the untreated area (before the selection)
    	System.arraycopy(wf.Wave,0,newWave,0,debut);
      //then mix with delay until end of original data
      for (int c=debut; c<wf.Wave.length; c++)
        newWave[c]=trimShort((int) wf.Wave[c]+echoWave[c-debut]);
      //for the last part, copy only the delay (this is the new area)
      for (int c=wf.Wave.length; c<longeurDelay+fin; c++)
        newWave[c]=trimShort(echoWave[c-debut]);
      //At last, assign this new Wave to the WaveFile
      wf.Wave=newWave;
    }
    else {
      //no extension necessary: copy only the mix of original and delay.
      for (int c=debut; c<=fin; c++)
        wf.Wave[c]=trimShort((int) wf.Wave[c]+echoWave[c-debut]);
    }
  } //of method delay
  
} //of class Delay