/* *******************************************************
 * 
 * name:          Pong.java
 * 
 * description:   SimpleModule which applies an "ping-
 *                pong"-effect to the wavefile. 
 *                It is just a long delay.
 *
 * Author:        Florian Bomers
 *
 * (c) by         Florian Boemers  fbomers@erato.unice.fr
 *                  or JaWavedit@bome.com
 *                Robin Pouget     rpouget@erato.unice.fr
 *                Niels Thorwirth  niels-t@usa.net
 *
 ********************************************************* */


public class Pong implements SimpleModule {
  
  public void apply(WaveFile wf,int SelStart, int SelEnd) {
    
    //utilise la methode traite de la class Delay
    //wf est .wav ou .au, SelStart ,SelEnd le debut et la fin de Selection
    //les parametres sont trouves par essais (adequat pour un effet type "Ping-Pong").
    //les parametres sont en ms, cela guaranti le meme echo pour n'importe quelle frequence
    Delay.delay(wf,SelStart,SelEnd,4,50,500,500,true);
  }
}

