/* *******************************************************
 * 
 * name:          Volume.java
 * 
 * description:   StereoModule to change the Volume
 *
 * Author:        Niels Thorwirth
 *
 * (c) by         Florian Boemers  fbomers@erato.unice.fr
 *                  or JaWavedit@bome.com
 *                Robin Pouget     rpouget@erato.unice.fr
 *                Niels Thorwirth  niels-t@usa.net
 *
 ********************************************************* */

import java.awt.*;
import java.awt.event.*;


public class Volume extends Dialog implements StereoModule, 
AdjustmentListener, ActionListener, WindowListener {
  private Label vol_nb_G;
  private Label vol_nb_D;
  private Scrollbar vol_G_scr;
  private Scrollbar vol_D_scr;
  private Checkbox g_et_d_cbox;
  private Button modifier_bt;
  private Button annuler_bt;
  private WaveFile wf;
  private short[] waveGauche;
  private short[] waveDroite;
  private int FSelDebut;
  private int FSelFin;
  final static int sb_max_val = 500;
  final static int sb_init_val = 100;
  
  public Volume(Frame parent) {
    super (parent,true);
    setTitle ("Modification du Volume");
    addWindowListener(this);
    setResizable(true);
    
    Panel p = new Panel();
    p.setLayout (new GridLayout(3,2));
    add ("North",p);
    p.add (new Label("Gauche:"));
    p.add (new Label("Droite:"));
    vol_nb_G = new Label(sb_init_val+"%");
    vol_nb_D = new Label(sb_init_val+"%");
    p.add (vol_nb_G);
    p.add (vol_nb_D);
    p = new Panel();
    p.setLayout (new GridLayout(1,5));
    add ("Center",p);
    Panel p2 = new Panel();
    p2.setLayout (new BorderLayout());
    p.add (p2);
    vol_G_scr = new Scrollbar (Scrollbar.VERTICAL,make_sb_val(sb_init_val),10,0,sb_max_val);
    vol_G_scr.addAdjustmentListener (this);
    p2.add ("West",vol_G_scr);
    p2 = new Panel();
    p2.setLayout (new BorderLayout());
    p.add (p2);
    vol_D_scr = new Scrollbar (Scrollbar.VERTICAL,make_sb_val(sb_init_val),10,0,sb_max_val);
    vol_D_scr.addAdjustmentListener (this);
    p2.add ("West",vol_D_scr);
    
    p = new Panel();
    p.setLayout (new GridLayout(1,3));
    add ("South",p);
    g_et_d_cbox = new Checkbox ("Le deux");
    p.add (g_et_d_cbox);
    modifier_bt = new Button ("Modifier !");
    modifier_bt.addActionListener (this);
    p.add (modifier_bt);
    annuler_bt = new Button ("Annuler !");
    annuler_bt.addActionListener (this);
    p.add (annuler_bt);
    
    pack();
    setSize(200,300);
    
  }    
  
  public void apply(WaveFile waveFile,Selection sel) {
    waveGauche=waveFile.getLeftWave();
    waveDroite=waveFile.getRightWave();
    wf=waveFile;
    FSelDebut=sel.start;
    FSelFin=sel.end;
    
    setVisible(true);
    vol_nb_G.setText (sb_init_val+"% de Volume"); // reetablier les valeurs initiales.
    vol_nb_D.setText (sb_init_val+"% de Volume"); // reetablier les valeurs initiales.
    vol_G_scr.setValue (make_sb_val(sb_init_val));
    vol_D_scr.setValue (make_sb_val(sb_init_val));
  }
  
  public void adjustmentValueChanged (AdjustmentEvent e) {
    if (e.getSource()==vol_G_scr) {
      vol_nb_G.setText(make_sb_val(vol_G_scr.getValue())+"%");
      if (g_et_d_cbox.getState() == true){
        // vol_nb_G.invalidate();
        vol_nb_D.setText(make_sb_val(vol_G_scr.getValue())+"%");
        vol_D_scr.setValue (vol_G_scr.getValue());
      }
    }
    if (e.getSource()==vol_D_scr) {
      vol_nb_D.setText(make_sb_val(vol_D_scr.getValue())+"%");
      if (g_et_d_cbox.getState() == true){
        // vol_nb_G.invalidate();
        vol_nb_G.setText(make_sb_val(vol_D_scr.getValue())+"%");
        vol_G_scr.setValue (vol_D_scr.getValue());
      }
    }
  }
  
  int make_sb_val (int val){
    return sb_max_val - val;
  }
  
  public void actionPerformed (ActionEvent e) {
    if (e.getSource()==modifier_bt) {
      changer(FSelDebut, FSelFin, waveGauche, make_sb_val(vol_G_scr.getValue()));
      changer(FSelDebut, FSelFin, waveDroite, make_sb_val(vol_D_scr.getValue()));
      wf.setWaves(waveGauche,waveDroite);
    }
    else if (e.getSource()==annuler_bt) {}
    
    setVisible(false);
  }
  
  void changer (int deb, int fin, short data[],int valeur){
    if (valeur!=100) 
      for (int c = deb; c <= fin ; c++ )
      data[c] =(short) Math.max(Math.min(((long) valeur * data[c] / 100),32767),-32768);      
  }
  
  public void windowClosed(WindowEvent event) {
  }
  public void windowDeiconified(WindowEvent event) {
  }
  public void windowIconified(WindowEvent event) {
  }
  public void windowActivated(WindowEvent event) {
  }
  public void windowDeactivated(WindowEvent event) {
  }
  public void windowOpened(WindowEvent event) {
  }
  public void windowClosing(WindowEvent event) {setVisible(false);}
}