/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.play;

import ch.laoe.audio.AudioException;
import ch.laoe.audio.play.APlay;
import ch.laoe.audio.play.APlayPcmSigned16BitBigEndian;
import ch.laoe.audio.play.APlayPcmSigned16BitLittleEndian;
import ch.laoe.audio.play.APlayPcmSigned8Bit;
import ch.laoe.audio.play.APlayPcmUnsigned16BitBigEndian;
import ch.laoe.audio.play.APlayPcmUnsigned16BitLittleEndian;
import ch.laoe.audio.play.APlayPcmUnsigned8Bit;
import ch.laoe.clip.AClip;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;

public class APlayFactory {
    private static ArrayList<APlay> classList;

    private static void preloadClasses() {
        classList = new ArrayList();
        classList.add(new APlayPcmUnsigned8Bit());
        classList.add(new APlayPcmSigned8Bit());
        classList.add(new APlayPcmUnsigned16BitLittleEndian());
        classList.add(new APlayPcmUnsigned16BitBigEndian());
        classList.add(new APlayPcmSigned16BitLittleEndian());
        classList.add(new APlayPcmSigned16BitBigEndian());
    }

    public static final APlay create(AClip aClip) throws AudioException {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, aClip.getSampleRate(), aClip.getSampleWidth(), aClip.getMaxNumberOfChannels(), aClip.getSampleWidth() / 8 * aClip.getMaxNumberOfChannels(), aClip.getSampleRate(), aClip.isBigEndian());
        APlay aPlay = APlayFactory.create(audioFormat);
        if (aPlay == null) {
            throw new AudioException("unsupportedAudioFormat");
        }
        aPlay.setAudioFormat(audioFormat);
        aPlay.setClip(aClip);
        return aPlay;
    }

    private static final APlay create(AudioFormat audioFormat) {
        for (int i = 0; i < classList.size(); ++i) {
            APlay aPlay = classList.get(i);
            if (!aPlay.supports(audioFormat)) continue;
            return aPlay.duplicate();
        }
        return null;
    }

    static {
        APlayFactory.preloadClasses();
    }
}

