/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerPlotter;
import ch.laoe.clip.AModel;
import ch.laoe.clip.APlotter;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GToolkit;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AClipPlotter
extends APlotter {
    private static boolean autoScaleIndividualYEnable = false;
    public static final int X_UNIT_1 = 0;
    public static final int X_UNIT_S = 1;
    public static final int X_UNIT_MS = 2;
    public static final int X_UNIT_PERCENT = 3;
    public static final int X_UNIT_HZ = 4;
    public static final int X_UNIT_FDHZ = 5;
    public static final int Y_UNIT_1 = 0;
    public static final int Y_UNIT_PERCENT = 1;
    public static final int Y_UNIT_DB = 2;
    public static final int Y_UNIT_FDHZ = 3;
    public int plotterXUnit = 1;
    public int plotterYUnit = 1;
    private static boolean skalaValuesVisible = true;
    private static boolean gridVisible = true;
    private Color bgColor = new Color(GPersistence.createPersistance().getInt("clip.defaultBackgroundColor"));
    private Color gridColor = new Color(GPersistence.createPersistance().getInt("clip.defaultGridColor"));
    protected int maxNumberOfChannels;
    protected int maxSampleLength;
    private static final Color playPointerColor = Color.GREEN.darker();
    private static final Color loopPointerColor = Color.RED.darker();
    private static final Color selectionSurfaceColor = Color.YELLOW;
    private static final Color selectionLineColor = GToolkit.mixColors(Color.RED, Color.YELLOW, 0.4f);

    public AClipPlotter(AModel aModel) {
        super(aModel);
    }

    @Override
    public void setDefaultName() {
        this.name = "";
    }

    public AClip getClipModel() {
        return (AClip)this.model;
    }

    public void setXRange(double d, double d2) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getPlotter().setXRange(d, d2);
        }
    }

    public void setYRange(float f, float f2) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getPlotter().setYRange(f, f2);
        }
    }

    public void translateXOffset(double d) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getPlotter().translateXOffset(d);
        }
    }

    public void translateYOffset(float f) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getPlotter().translateYOffset(f);
        }
    }

    public void zoomX(double d) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getPlotter().zoomX(d);
        }
    }

    public void zoomX(double d, double d2) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getPlotter().zoomX(d, d2);
        }
    }

    public void zoomY(double d) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getPlotter().zoomY(d);
        }
    }

    public void zoomY(double d, double d2) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getPlotter().zoomY(d, d2);
        }
    }

    public static void setAutoScaleIndividualYEnabled(boolean bl) {
        autoScaleIndividualYEnable = bl;
    }

    public void autoScale() {
        this.autoScaleX();
        this.autoScaleY();
    }

    public void autoScaleX() {
        double d = this.getAutoscaleXOffset();
        double d2 = this.getAutoscaleXLength();
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getPlotter();
            if (!aLayerPlotter.isVisible()) continue;
            aLayerPlotter.setXRange(d - d2 * (double)0.01f, d2 * (double)1.02f);
        }
    }

    public void autoScaleY() {
        this.autoScaleY(0, this.getClipModel().getMaxSampleLength());
    }

    public void autoScaleY(int n, int n2) {
        float f = this.getAutoscaleYOffset(n, n2);
        float f2 = this.getAutoscaleYLength(n, n2);
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getPlotter();
            if (!aLayerPlotter.isVisible()) continue;
            if (autoScaleIndividualYEnable) {
                aLayerPlotter.autoScaleY(n, n2);
                continue;
            }
            aLayerPlotter.setYRange(f - f2 * 0.03f, f2 * 1.06f);
        }
    }

    public double getAutoscaleXOffset() {
        double d = Double.MAX_VALUE;
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            double d2;
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getPlotter();
            if (!aLayerPlotter.isVisible() || !((d2 = aLayerPlotter.getAutoscaleXOffset()) < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getAutoscaleXLength() {
        double d = Double.MIN_VALUE;
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            double d2;
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getPlotter();
            if (!aLayerPlotter.isVisible() || !((d2 = aLayerPlotter.getAutoscaleXLength()) > d)) continue;
            d = d2;
        }
        return d;
    }

    public float getAutoscaleYOffset(int n, int n2) {
        float f = Float.MAX_VALUE;
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            float f2;
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getPlotter();
            if (!aLayerPlotter.isVisible() || !((f2 = aLayerPlotter.getAutoscaleYOffset(n, n2)) < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getAutoscaleYLength(int n, int n2) {
        float f = Float.MIN_VALUE;
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            float f2;
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getPlotter();
            if (!aLayerPlotter.isVisible() || !((f2 = aLayerPlotter.getAutoscaleYLength(n, n2)) > f)) continue;
            f = f2;
        }
        return f;
    }

    public void setPlotterXUnit(int n) {
        this.plotterXUnit = n;
    }

    public void togglePlotterXUnit() {
        this.plotterXUnit = this.plotterXUnit < 5 ? ++this.plotterXUnit : 0;
    }

    public void setPlotterYUnit(int n) {
        this.plotterYUnit = n;
    }

    public void togglePlotterYUnit() {
        this.plotterYUnit = this.plotterYUnit < 3 ? ++this.plotterYUnit : 0;
    }

    public String getPlotterXUnitName() {
        switch (this.plotterXUnit) {
            case 0: {
                return "";
            }
            case 1: {
                return "s";
            }
            case 2: {
                return "ms";
            }
            case 3: {
                return "%";
            }
            case 4: {
                return "1/s";
            }
            case 5: {
                return "Hz";
            }
        }
        return "";
    }

    public String getPlotterYUnitName() {
        switch (this.plotterYUnit) {
            case 0: {
                return "";
            }
            case 1: {
                return "%";
            }
            case 2: {
                return "dB";
            }
            case 3: {
                return "Hz";
            }
        }
        return "";
    }

    public static void setSkalaValuesVisible(boolean bl) {
        skalaValuesVisible = bl;
    }

    public static boolean isSkalaValuesVisible() {
        return skalaValuesVisible;
    }

    public static void setGridVisible(boolean bl) {
        gridVisible = bl;
    }

    public static boolean isGridVisible() {
        return gridVisible;
    }

    public double toPlotterXUnit(double d) {
        switch (this.plotterXUnit) {
            case 0: {
                return d;
            }
            case 1: {
                return d / (double)this.getClipModel().getSampleRate();
            }
            case 2: {
                return d / (double)this.getClipModel().getSampleRate() * 1000.0;
            }
            case 3: {
                return d / (double)this.getClipModel().getMaxSampleLength() * 100.0;
            }
            case 4: {
                return (double)this.getClipModel().getSampleRate() / d;
            }
            case 5: {
                return d / (double)(2 * this.getClipModel().getMaxSampleLength()) * (double)this.getClipModel().getSampleRate();
            }
        }
        return d;
    }

    public float toPlotterYUnit(float f) {
        try {
            switch (this.plotterYUnit) {
                case 0: {
                    return f;
                }
                case 1: {
                    return f / (float)(1 << this.getClipModel().getSampleWidth() - 1) * 100.0f;
                }
                case 2: {
                    if (f >= 0.0f) {
                        return (float)(8.68589 * Math.log((double)Math.abs(f * 2.0f) / Math.pow(2.0, this.getClipModel().getSampleWidth())));
                    }
                    return (float)(8.68589 * Math.log((double)Math.abs(f * 2.0f) / Math.pow(2.0, this.getClipModel().getSampleWidth())));
                }
                case 3: {
                    return f;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    double fromPlotterXUnit(double d) {
        switch (this.plotterXUnit) {
            case 0: {
                return d;
            }
            case 1: {
                return d * (double)this.getClipModel().getSampleRate();
            }
            case 2: {
                return d * (double)this.getClipModel().getSampleRate() / 1000.0;
            }
            case 3: {
                return d * (double)this.getClipModel().getMaxSampleLength() / 100.0;
            }
            case 4: {
                return (double)this.getClipModel().getSampleRate() / d;
            }
            case 5: {
                return d * (double)(2 * this.getClipModel().getMaxSampleLength()) / (double)this.getClipModel().getSampleRate();
            }
        }
        return d;
    }

    float fromPlotterYUnit(float f) {
        try {
            switch (this.plotterYUnit) {
                case 0: {
                    return f;
                }
                case 1: {
                    return f * (float)(1 << this.getClipModel().getSampleWidth() - 1) / 100.0f;
                }
                case 2: {
                    if (f >= 0.0f) {
                        return (float)(Math.exp((double)f / 8.68589) * Math.pow(2.0, this.getClipModel().getSampleWidth()) / 2.0);
                    }
                    return (float)(Math.exp((double)f / 8.68589) * Math.pow(2.0, this.getClipModel().getSampleWidth()) / 2.0);
                }
                case 3: {
                    return f;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void paintFullClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.maxNumberOfChannels = this.getClipModel().getMaxNumberOfChannels();
            this.maxSampleLength = this.getClipModel().getMaxSampleLength();
            ALayer aLayer = this.getClipModel().getSelectedLayer();
            boolean bl = false;
            for (int i = 0; i < this.getClipModel().getNumberOfLayers(); ++i) {
                ALayer aLayer2 = this.getClipModel().getLayer(i);
                if (aLayer2 == aLayer) continue;
                aLayer2.getPlotter().paintLayer(graphics2D, rectangle, this.maxSampleLength, this.maxNumberOfChannels, false, true, this.bgColor, 0.3f, !bl, this.gridColor);
                bl = true;
            }
            aLayer.getPlotter().paintLayer(graphics2D, rectangle, this.maxSampleLength, this.maxNumberOfChannels, true, true, this.bgColor, 1.0f, !bl, this.gridColor);
        }
    }

    public void paintDetailsOfSelectedLayer(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.getClipModel().getNumberOfLayers() > 0) {
            this.getClipModel().getSelectedLayer().getPlotter().paintAllSelections(graphics2D, rectangle, selectionSurfaceColor, selectionLineColor, this.maxSampleLength, this.maxNumberOfChannels);
            this.getClipModel().getAudio().getPlotter().paintPlayPointer(graphics2D, rectangle, playPointerColor);
            this.getClipModel().getAudio().getPlotter().paintLoopPointer(graphics2D, rectangle, loopPointerColor);
            this.getClipModel().getSelectedLayer().getPlotter().paintMasks(graphics2D, rectangle, this.maxSampleLength, this.maxNumberOfChannels);
            this.getClipModel().getSelectedLayer().getPlotter().paintMarkers(graphics2D, rectangle, this.maxSampleLength, this.maxNumberOfChannels);
        }
    }

    public void paintLayerThumbnail(Graphics2D graphics2D, Rectangle rectangle, int n) {
        ALayer aLayer = this.getClipModel().getLayer(n);
        aLayer.getPlotter().paintLayer(graphics2D, rectangle, aLayer.getMaxSampleLength(), aLayer.getNumberOfChannels(), false, false, this.bgColor, 1.0f, true, this.gridColor);
    }

    public void paintChannelThumbnail(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
        ALayer aLayer = this.getClipModel().getLayer(n);
        AChannel aChannel = aLayer.getChannel(n2);
        aChannel.getPlotter().setRectangle(rectangle);
        aChannel.getPlotter().paintBackground(graphics2D, this.bgColor);
        aChannel.getPlotter().paintSamples(graphics2D, aLayer.getPlotter().getColor(), aLayer.getPlotter().getColorGamma());
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        aChannel.getPlotter().paintFrame(graphics2D);
    }
}

