/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.ui.Debug;
import java.util.ArrayList;

public class MMArray2 {
    private ArrayList<SubArray> subArrays;
    private int usedLength;
    private final float initialValue;

    public MMArray2(int n, float f) {
        if (n < 0) {
            n = 0;
        }
        this.subArrays = new ArrayList();
        this.subArrays.add(new SubArray(0, n, f));
        this.usedLength = n;
        this.initialValue = f;
    }

    public MMArray2(MMArray2 mMArray2) {
        this(mMArray2.getLength(), 0.0f);
        this.subArrays.clear();
        for (int i = 0; i < mMArray2.subArrays.size(); ++i) {
            this.subArrays.add(new SubArray(mMArray2.subArrays.get(i)));
        }
    }

    public final void destroy() {
        this.set(new float[0]);
    }

    public final void cleanup() {
        for (int i = this.subArrays.size() - 1; i >= 0; --i) {
            if (!this.subArrays.get(i).isInitial()) {
                return;
            }
            this.subArrays.remove(i);
        }
    }

    public final int getLength() {
        return this.usedLength;
    }

    public final int getMemoryUsage() {
        if (this.subArrays.size() > 0) {
            SubArray subArray = this.subArrays.get(this.subArrays.size() - 1);
            return subArray.offset + subArray.samples.length;
        }
        return 0;
    }

    public final boolean isInRange(int n) {
        return n >= 0 && n < this.usedLength;
    }

    public final float get(int n) {
        if (this.isInRange(n)) {
            int n2 = this.subArrays.size();
            for (int i = 0; i < n2; ++i) {
                SubArray subArray = this.subArrays.get(i);
                if (n >= subArray.end) continue;
                return subArray.samples[n - subArray.offset];
            }
            return this.initialValue;
        }
        return this.initialValue;
    }

    public final void set(int n, float f) {
        if (n < 0) {
            return;
        }
        int n2 = this.subArrays.size();
        for (int i = 0; i < n2; ++i) {
            SubArray subArray = this.subArrays.get(i);
            if (n >= subArray.end) continue;
            subArray.samples[n - subArray.offset] = f;
            if (n >= this.usedLength) {
                this.usedLength = n + 1;
            }
            return;
        }
        this.grow(n);
        SubArray subArray = this.subArrays.get(this.subArrays.size() - 1);
        subArray.samples[n - subArray.offset] = f;
        if (n >= this.usedLength) {
            this.usedLength = n + 1;
        }
    }

    public final void set(float[] fArray) {
        this.subArrays.clear();
        this.subArrays.add(new SubArray(fArray));
        this.usedLength = fArray.length;
    }

    public final void copy(MMArray2 mMArray2, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, mMArray2.get(n + i));
        }
    }

    private final void grow(int n) {
        long l = System.currentTimeMillis();
        if (this.subArrays.size() > 0) {
            SubArray subArray = this.subArrays.get(this.subArrays.size() - 1);
            int n2 = this.getMemoryUsage();
            int n3 = Math.min(subArray.samples.length * 2, 8000000);
            n3 = Math.max(n3, n + 1 - n2);
            SubArray subArray2 = new SubArray(n2, n3, this.initialValue);
            this.subArrays.add(subArray2);
        } else {
            this.subArrays.add(new SubArray(0, Math.max(n + 1, 10000), this.initialValue));
        }
        this.usedLength = n + 1;
        Debug.println(6, "MMArray2 grow: length=" + this.getLength() + " memory-usage=" + this.getMemoryUsage());
        System.out.println("MMArray2 grow: length=" + this.getLength() + " memory-usage=" + this.getMemoryUsage() + " grow-time=" + (System.currentTimeMillis() - l));
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        System.out.println("test array with initial value of zero...");
        MMArray2 mMArray2 = new MMArray2(100, 0.0f);
        if (mMArray2.getLength() != 100) {
            System.out.println("failed 1");
        }
        if (!mMArray2.isInRange(0)) {
            System.out.println("failed 2");
        }
        if (mMArray2.isInRange(-1)) {
            System.out.println("failed 3");
        }
        if (!mMArray2.isInRange(66)) {
            System.out.println("failed 4");
        }
        if (!mMArray2.isInRange(99)) {
            System.out.println("failed 5");
        }
        if (mMArray2.isInRange(100)) {
            System.out.println("failed 6");
        }
        if (mMArray2.get(0) != 0.0f) {
            System.out.println("failed 7");
        }
        if (mMArray2.get(55) != 0.0f) {
            System.out.println("failed 8");
        }
        if (mMArray2.get(99) != 0.0f) {
            System.out.println("failed 9");
        }
        if (mMArray2.get(333) != 0.0f) {
            System.out.println("failed 10");
        }
        mMArray2.set(77, 4.0f);
        if (mMArray2.get(77) != 4.0f) {
            System.out.println("failed 11");
        }
        if (mMArray2.getLength() != 100) {
            System.out.println("failed 12");
        }
        mMArray2.set(111, 7.0f);
        if (mMArray2.get(77) != 4.0f) {
            System.out.println("failed 21");
        }
        if (mMArray2.get(110) != 0.0f) {
            System.out.println("failed 22");
        }
        if (mMArray2.get(111) != 7.0f) {
            System.out.println("failed 23");
        }
        if (mMArray2.getLength() != 112) {
            System.out.println("failed 24");
        }
        mMArray2.set(1111, 7777.0f);
        if (mMArray2.get(77) != 4.0f) {
            System.out.println("failed 31");
        }
        if (mMArray2.get(111) != 7.0f) {
            System.out.println("failed 32");
        }
        if (mMArray2.get(1110) != 0.0f) {
            System.out.println("failed 34");
        }
        if (mMArray2.get(1111) != 7777.0f) {
            System.out.println("failed 35");
        }
        if (mMArray2.getLength() != 1112) {
            System.out.println("failed 36");
        }
        if (!mMArray2.isInRange(0)) {
            System.out.println("failed 36a");
        }
        if (mMArray2.isInRange(-1)) {
            System.out.println("failed 36b");
        }
        if (!mMArray2.isInRange(66)) {
            System.out.println("failed 36c");
        }
        if (!mMArray2.isInRange(99)) {
            System.out.println("failed 36d");
        }
        if (!mMArray2.isInRange(100)) {
            System.out.println("failed 36e");
        }
        if (!mMArray2.isInRange(1111)) {
            System.out.println("failed 36f");
        }
        if (mMArray2.isInRange(1112)) {
            System.out.println("failed 36g");
        }
        if (mMArray2.isInRange(999999)) {
            System.out.println("failed 36h");
        }
        System.out.println("test copied array...");
        MMArray2 mMArray22 = new MMArray2(mMArray2);
        if (mMArray22.get(77) != 4.0f) {
            System.out.println("failed 41");
        }
        if (mMArray22.get(111) != 7.0f) {
            System.out.println("failed 42");
        }
        if (mMArray22.get(1110) != 0.0f) {
            System.out.println("failed 44");
        }
        if (mMArray22.get(1111) != 7777.0f) {
            System.out.println("failed 45");
        }
        if (mMArray22.getLength() != 1112) {
            System.out.println("failed 46");
        }
        mMArray22.set(1234, 2345.0f);
        if (mMArray22.get(1234) != 2345.0f) {
            System.out.println("failed 47");
        }
        if (mMArray22.getLength() != 1235) {
            System.out.println("failed 48");
        }
        if (mMArray2.get(1234) != 0.0f) {
            System.out.println("failed 49");
        }
        if (mMArray2.getLength() != 1112) {
            System.out.println("failed 49b");
        }
        System.out.println("test array with initial value other than zero...");
        MMArray2 mMArray23 = new MMArray2(100, 69.0f);
        if (mMArray23.getLength() != 100) {
            System.out.println("failed 51");
        }
        if (mMArray23.get(0) != 69.0f) {
            System.out.println("failed 52");
        }
        if (mMArray23.get(55) != 69.0f) {
            System.out.println("failed 53");
        }
        if (mMArray23.get(99) != 69.0f) {
            System.out.println("failed 54");
        }
        if (mMArray23.get(333) != 69.0f) {
            System.out.println("failed 55");
        }
        mMArray23.set(77, 4.0f);
        if (mMArray23.get(77) != 4.0f) {
            System.out.println("failed 61");
        }
        if (mMArray23.getLength() != 100) {
            System.out.println("failed 62");
        }
        mMArray23.set(111, 7.0f);
        if (mMArray23.get(77) != 4.0f) {
            System.out.println("failed 71");
        }
        if (mMArray23.get(110) != 69.0f) {
            System.out.println("failed 72");
        }
        if (mMArray23.get(111) != 7.0f) {
            System.out.println("failed 73");
        }
        if (mMArray23.getLength() != 112) {
            System.out.println("failed 74");
        }
        mMArray23.set(1111, 7777.0f);
        if (mMArray23.get(77) != 4.0f) {
            System.out.println("failed 81");
        }
        if (mMArray23.get(111) != 7.0f) {
            System.out.println("failed 82");
        }
        if (mMArray23.get(1110) != 69.0f) {
            System.out.println("failed 84");
        }
        if (mMArray23.get(1111) != 7777.0f) {
            System.out.println("failed 85");
        }
        if (mMArray23.getLength() != 1112) {
            System.out.println("failed 86");
        }
        System.out.println("test array replaced...");
        mMArray23.set(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        if (mMArray23.getLength() != 4) {
            System.out.println("failed 91");
        }
        if (mMArray23.get(0) != 1.0f) {
            System.out.println("failed 92");
        }
        if (mMArray23.get(2) != 3.0f) {
            System.out.println("failed 93");
        }
        if (mMArray23.get(3) != 4.0f) {
            System.out.println("failed 94");
        }
        if (mMArray23.get(4) != 69.0f) {
            System.out.println("failed 95");
        }
        System.out.println("test array copy in range...");
        MMArray2 mMArray24 = new MMArray2(100, 44.0f);
        MMArray2 mMArray25 = new MMArray2(100, 44.0f);
        for (n3 = 0; n3 < mMArray24.getLength(); ++n3) {
            mMArray24.set(n3, n3);
        }
        mMArray25.copy(mMArray24, 40, 0, 10);
        for (n3 = 0; n3 < 10; ++n3) {
            if (mMArray25.get(n3) == (float)(40 + n3)) continue;
            System.out.println("failed " + (100 + n3));
        }
        if (mMArray25.get(39) != 44.0f) {
            System.out.println("failed 111");
        }
        if (mMArray25.get(50) != 44.0f) {
            System.out.println("failed 112");
        }
        System.out.println("test array copy extra range...");
        mMArray24 = new MMArray2(70, 22.0f);
        mMArray25 = new MMArray2(600, 44.0f);
        for (n3 = 0; n3 < mMArray24.getLength(); ++n3) {
            mMArray24.set(n3, n3);
        }
        mMArray25.copy(mMArray24, 40, 0, 300);
        for (n3 = 0; n3 < 20; ++n3) {
            if (mMArray25.get(n3) == (float)(40 + n3)) continue;
            System.out.println("failed " + (200 + n3));
        }
        if (mMArray25.get(299) != 22.0f) {
            System.out.println("failed 221");
        }
        if (mMArray25.get(300) != 44.0f) {
            System.out.println("failed 222");
        }
        System.out.println("test array growing...");
        mMArray24 = new MMArray2(5, 0.0f);
        mMArray24.set(5000000, 99.0f);
        if (mMArray24.get(5000000) != 99.0f) {
            System.out.println("failed 921");
        }
        if (mMArray24.get(4999990) != 0.0f) {
            System.out.println("failed 922");
        }
        if (mMArray24.get(5000010) != 0.0f) {
            System.out.println("failed 923");
        }
        mMArray24.set(10000000, 66.0f);
        if (mMArray24.get(10000000) != 66.0f) {
            System.out.println("failed 924");
        }
        mMArray24.set(20000000, 77.0f);
        if (mMArray24.get(20000000) != 77.0f) {
            System.out.println("failed 925");
        }
        mMArray24.set(40000000, 77.0f);
        if (mMArray24.get(40000000) != 77.0f) {
            System.out.println("failed 926");
        }
        mMArray24.set(80000000, 77.0f);
        if (mMArray24.get(80000000) != 77.0f) {
            System.out.println("failed 927");
        }
        System.out.print("profiling calibration...            ");
        mMArray24 = new MMArray2(2000000, 0.0f);
        long l = System.currentTimeMillis();
        int n4 = mMArray24.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray24.getLength() + " ps/element");
        System.out.print("profiling get()...                  ");
        mMArray24 = new MMArray2(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray24.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray24.get(n);
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray24.getLength() + " ps/element");
        System.out.print("profiling set()...                  ");
        mMArray24 = new MMArray2(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray24.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray24.set(n, n);
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray24.getLength() + " ps/element");
        System.out.print("profiling manual get() and set()... ");
        mMArray24 = new MMArray2(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray24.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray24.set(n, mMArray24.get(n + 2));
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray24.getLength() + " ps/element");
        System.out.print("profiling copy() in range...        ");
        mMArray24 = new MMArray2(2000000, 44.0f);
        MMArray2 mMArray26 = new MMArray2(2000001, 22.0f);
        long l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 100; ++n2) {
            mMArray26.copy(mMArray24, 0, 0, mMArray24.getLength());
        }
        System.out.println("" + (System.currentTimeMillis() - l2) * 10000000L / (long)mMArray24.getLength() + " ps/element");
        System.out.print("profiling copy() extra range...     ");
        mMArray24 = new MMArray2(2000000, 44.0f);
        mMArray26 = new MMArray2(2000001, 22.0f);
        l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 100; ++n2) {
            mMArray26.copy(mMArray24, 0, 0, mMArray26.getLength());
        }
        System.out.println("" + (System.currentTimeMillis() - l2) * 10000000L / (long)mMArray26.getLength() + " ps/element");
        System.out.println("if not failed then passed...!");
    }

    private class SubArray {
        public float[] samples;
        public int offset;
        public int end;

        public SubArray(int n, int n2, float f) {
            this.offset = n;
            this.end = n + n2;
            this.samples = new float[n2];
            if (f != 0.0f) {
                for (int i = 0; i < this.samples.length; ++i) {
                    this.samples[i] = f;
                }
            }
        }

        public SubArray(SubArray subArray) {
            this(subArray.offset, subArray.samples.length, mMArray2.initialValue);
            System.arraycopy(subArray.samples, 0, this.samples, 0, subArray.samples.length);
        }

        public SubArray(float[] fArray) {
            this(0, fArray.length, 0.0f);
            System.arraycopy(fArray, 0, this.samples, 0, fArray.length);
        }

        public boolean isInitial() {
            for (int i = 0; i < this.samples.length; ++i) {
                if (this.samples[i] == MMArray2.this.initialValue) continue;
                return false;
            }
            return true;
        }
    }
}

