/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;

public class AOReverb
extends AOperation {
    private int delay;
    private float gain;
    private float dry;
    private float wet;
    private boolean negFeedback;
    private boolean backward;

    public AOReverb(int n, float f, float f2, float f3, boolean bl, boolean bl2) {
        this.delay = n;
        this.gain = f;
        this.dry = f2;
        this.wet = f3;
        this.negFeedback = bl;
        this.backward = bl2;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = AOToolkit.rmsAverage(mMArray, n, n2);
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        aChannelSelection.getChannel().markChange();
        try {
            int n3;
            if (this.backward) {
                for (n3 = 0; n3 < n2; ++n3) {
                    mMArray2.set(n2 - 1 - n3, mMArray.get(n3 + n));
                }
            } else {
                mMArray2.copy(mMArray, n, 0, n2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (n3 + this.delay >= n2) continue;
                if (this.negFeedback) {
                    mMArray2.set(n3 + this.delay, mMArray2.get(n3 + this.delay) - mMArray2.get(n3) * this.gain);
                    continue;
                }
                mMArray2.set(n3 + this.delay, mMArray2.get(n3 + this.delay) + mMArray2.get(n3) * this.gain);
            }
            float f2 = AOToolkit.rmsAverage(mMArray2, 0, n2);
            AOToolkit.multiply(mMArray2, 0, n2, f / f2);
            if (this.backward) {
                for (int i = n; i < n + n2; ++i) {
                    float f3 = mMArray.get(i) * this.dry + mMArray2.get(n2 - 1 - i - n) * this.wet;
                    mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), f3));
                }
            } else {
                for (int i = n; i < n + n2; ++i) {
                    float f4 = mMArray.get(i) * this.dry + mMArray2.get(i - n) * this.wet;
                    mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), f4));
                }
            }
            AOToolkit.applyZeroCross(mMArray, n);
            AOToolkit.applyZeroCross(mMArray, n + n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }
}

