/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOAutoVolume;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPAutoVolume
extends GPluginFrame {
    private UiControlText dry;
    private UiControlText wet;
    private UiControlText attack;
    private UiControlText release;
    private JCheckBox backward;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPAutoVolume(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "autoVolume";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 6);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("dryFactor")), 0, 0, 4, 1);
        this.dry = new GControlTextA(7, true, true);
        this.dry.setDataRange(-1.0, 1.0);
        this.dry.setData(0.3);
        uiCartesianLayout.add(this.dry, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("wetFactor")), 0, 1, 4, 1);
        this.wet = new GControlTextA(7, true, true);
        this.wet.setDataRange(-1.0, 1.0);
        this.wet.setData(0.7);
        uiCartesianLayout.add(this.wet, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("attack")), 0, 2, 4, 1);
        this.attack = new GControlTextX(Laoe.getInstance(), 7, true, true);
        this.attack.setDataRange(1.0, 1.0E9);
        this.attack.setData(1000.0);
        this.attack.setUnit("ms");
        uiCartesianLayout.add(this.attack, 4, 2, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("release")), 0, 3, 4, 1);
        this.release = new GControlTextX(Laoe.getInstance(), 7, true, true);
        this.release.setDataRange(0.0, 1.0E9);
        this.release.setData(1000.0);
        this.release.setUnit("ms");
        uiCartesianLayout.add(this.release, 4, 3, 6, 1);
        this.backward = new JCheckBox(GLanguage.translate("backward"));
        uiCartesianLayout.add(this.backward, 0, 4, 6, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 5, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
    }

    @Override
    public void reload() {
        super.reload();
        this.dry.refresh();
        this.wet.refresh();
        this.attack.refresh();
        this.release.refresh();
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        int n = (int)this.getFocussedClip().getSampleRate();
        int n2 = (int)this.attack.getData();
        int n3 = (int)this.release.getData();
        boolean bl = this.backward.isSelected();
        aLayerSelection.operateEachChannel(new AOAutoVolume(n, (float)this.dry.getData(), (float)this.wet.getData(), n2, n3, bl));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPAutoVolume.this.apply) {
                LProgressViewer.getInstance().entrySubProgress(GPAutoVolume.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPAutoVolume.this.getName() + " [apply] clicked");
                GPAutoVolume.this.onApply();
                GPAutoVolume.this.updateHistory(GLanguage.translate(GPAutoVolume.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPAutoVolume.this.reloadFocussedClipEditor();
                GPAutoVolume.this.autoCloseNow();
            }
        }
    }
}

