/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOEqualizer;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GPEqualizer
extends GPluginFrame {
    private JSlider[] bands;
    private JLabel[] labels;
    float[] frequency = new float[]{20.0f, 27.0f, 36.0f, 47.0f, 63.0f, 84.0f, 112.0f, 150.0f, 200.0f, 266.0f, 355.0f, 474.0f, 631.0f, 842.0f, 1122.0f, 1497.0f, 1996.0f, 2661.0f, 3548.0f, 4730.0f, 6307.0f, 8409.0f, 11212.0f, 14950.0f, 20000.0f};
    private JComboBox numberOfBands;
    private JComboBox predefined;
    private JComboBox order;
    private JButton reset;
    private JButton invert;
    private JButton apply;
    private EventDispatcher eventDispatcher;
    private String[] presetsName;
    private float[][] bandsPresets;

    public GPEqualizer(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "equalizer";
    }

    private void initGui() {
        Object object;
        PersistenceDefaultImpl persistenceDefaultImpl = new PersistenceDefaultImpl();
        try {
            ((Persistence)persistenceDefaultImpl).restore(this.getName() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = ((Persistence)persistenceDefaultImpl).getInt("numberOfPresets");
        this.presetsName = new String[n];
        this.bandsPresets = new float[n][];
        for (int i = 0; i < n; ++i) {
            this.presetsName[i] = GLanguage.translate(((Persistence)persistenceDefaultImpl).getString("name_" + i));
            this.bandsPresets[i] = new float[this.frequency.length];
            for (int j = 0; j < this.frequency.length; ++j) {
                try {
                    this.bandsPresets[i][j] = ((Persistence)persistenceDefaultImpl).getFloat("band_" + i + "_" + j);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 27, 6);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        uiCartesianLayout.setCellGap(0.0f);
        jPanel.setLayout(uiCartesianLayout);
        this.bands = new JSlider[this.frequency.length];
        uiCartesianLayout.add(new JLabel("+18dB"), 0, 0, 2, 1);
        uiCartesianLayout.add(new JLabel("-18dB"), 0, 3, 2, 1);
        this.labels = new JLabel[this.frequency.length];
        for (int i = 0; i < this.bands.length; ++i) {
            this.bands[i] = new JSlider(1, -180, 180, 0);
            this.bands[i].setOrientation(1);
            this.bands[i].setMajorTickSpacing(180);
            this.bands[i].setMinorTickSpacing(20);
            this.bands[i].setPaintTicks(true);
            uiCartesianLayout.add(this.bands[i], i + 2, 0, 1, 4);
            object = this.frequency[i] < 1000.0f ? "" + (int)this.frequency[i] : (this.frequency[i] < 10000.0f ? "" + (float)((int)(this.frequency[i] + 50.0f) / 100) / 10.0f + "K" : "" + (int)(this.frequency[i] + 500.0f) / 1000 + "K");
            this.labels[i] = new JLabel((String)object);
            uiCartesianLayout.add(this.labels[i], i + 2, 4, 1, 1);
        }
        String[] stringArray = new String[]{GLanguage.translate("5Bands"), GLanguage.translate("9Bands"), GLanguage.translate("13Bands"), GLanguage.translate("25Bands")};
        this.numberOfBands = new JComboBox<String>(stringArray);
        this.numberOfBands.setSelectedIndex(3);
        uiCartesianLayout.add(this.numberOfBands, 1, 5, 3, 1);
        this.predefined = new JComboBox<String>(this.presetsName);
        uiCartesianLayout.add(this.predefined, 4, 5, 5, 1);
        object = new String[]{GLanguage.translate("1Order"), GLanguage.translate("2Order"), GLanguage.translate("3Order"), GLanguage.translate("4Order")};
        this.order = new JComboBox<String>((E[])object);
        uiCartesianLayout.add(this.order, 9, 5, 3, 1);
        this.reset = new JButton(GLanguage.translate("reset"));
        uiCartesianLayout.add(this.reset, 15, 5, 3, 1);
        this.invert = new JButton(GLanguage.translate("invert"));
        uiCartesianLayout.add(this.invert, 18, 5, 3, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 21, 5, 3, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        for (int i = 0; i < this.bands.length; ++i) {
            this.bands[i].addChangeListener(this.eventDispatcher);
        }
        this.numberOfBands.addActionListener(this.eventDispatcher);
        this.predefined.addActionListener(this.eventDispatcher);
        this.reset.addActionListener(this.eventDispatcher);
        this.invert.addActionListener(this.eventDispatcher);
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
    }

    private int getNumberOfBands() {
        switch (this.numberOfBands.getSelectedIndex()) {
            case 0: {
                return 5;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 13;
            }
            case 3: {
                return 25;
            }
        }
        return 25;
    }

    private void interpolateBand(int n, int n2, int n3) {
        this.bands[n2].setValue((int)((float)(this.bands[n].getValue() * (n3 - n2) + this.bands[n3].getValue() * (n2 - n)) / (float)(n3 - n)));
    }

    private void copyBand(int n, int n2) {
        this.bands[n2].setValue(this.bands[n].getValue());
    }

    private void smoothNeighbourBands() {
        switch (this.getNumberOfBands()) {
            case 5: {
                this.interpolateBand(2, 3, 7);
                this.interpolateBand(2, 4, 7);
                this.interpolateBand(2, 5, 7);
                this.interpolateBand(2, 6, 7);
                this.interpolateBand(7, 8, 12);
                this.interpolateBand(7, 9, 12);
                this.interpolateBand(7, 10, 12);
                this.interpolateBand(7, 11, 12);
                this.interpolateBand(12, 13, 17);
                this.interpolateBand(12, 14, 17);
                this.interpolateBand(12, 15, 17);
                this.interpolateBand(12, 16, 17);
                this.interpolateBand(17, 18, 22);
                this.interpolateBand(17, 19, 22);
                this.interpolateBand(17, 20, 22);
                this.interpolateBand(17, 21, 22);
                this.copyBand(2, 0);
                this.copyBand(2, 1);
                this.copyBand(22, 23);
                this.copyBand(22, 24);
                break;
            }
            case 9: {
                this.interpolateBand(0, 1, 3);
                this.interpolateBand(0, 2, 3);
                this.interpolateBand(3, 4, 6);
                this.interpolateBand(3, 5, 6);
                this.interpolateBand(6, 7, 9);
                this.interpolateBand(6, 8, 9);
                this.interpolateBand(9, 10, 12);
                this.interpolateBand(9, 11, 12);
                this.interpolateBand(12, 13, 15);
                this.interpolateBand(12, 14, 15);
                this.interpolateBand(15, 16, 18);
                this.interpolateBand(15, 17, 18);
                this.interpolateBand(18, 19, 21);
                this.interpolateBand(18, 20, 21);
                this.interpolateBand(21, 22, 24);
                this.interpolateBand(21, 23, 24);
                break;
            }
            case 13: {
                this.interpolateBand(0, 1, 2);
                this.interpolateBand(2, 3, 4);
                this.interpolateBand(4, 5, 6);
                this.interpolateBand(6, 7, 8);
                this.interpolateBand(8, 9, 10);
                this.interpolateBand(10, 11, 12);
                this.interpolateBand(12, 13, 14);
                this.interpolateBand(14, 15, 16);
                this.interpolateBand(16, 17, 18);
                this.interpolateBand(18, 19, 20);
                this.interpolateBand(20, 21, 22);
                this.interpolateBand(22, 23, 24);
            }
        }
    }

    @Override
    public void reload() {
        super.reload();
        try {
            int n;
            switch (this.getNumberOfBands()) {
                case 5: {
                    for (n = 0; n < this.bands.length; ++n) {
                        this.bands[n].setVisible(n % 5 == 2);
                    }
                    break;
                }
                case 9: {
                    for (n = 0; n < this.bands.length; ++n) {
                        this.bands[n].setVisible(n % 3 == 0);
                    }
                    break;
                }
                case 13: {
                    for (n = 0; n < this.bands.length; ++n) {
                        this.bands[n].setVisible(n % 2 == 0);
                    }
                    break;
                }
                case 25: {
                    for (n = 0; n < this.bands.length; ++n) {
                        this.bands[n].setVisible(true);
                    }
                    break;
                }
            }
            for (n = 0; n < this.bands.length; ++n) {
                if (!(this.frequency[n] > this.getFocussedClip().getSampleRate())) continue;
                this.bands[n].setVisible(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            for (int i = 0; i < this.bands.length; ++i) {
                this.labels[i].setVisible(this.bands[i].isVisible());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onApply() {
        int n;
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float[] fArray = new float[this.frequency.length];
        float[] fArray2 = new float[fArray.length];
        float f = 1.75f;
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = this.frequency[n] / this.getFocussedClip().getSampleRate();
        }
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = AOToolkit.fromdB((float)this.bands[n].getValue() / 10.0f);
        }
        try {
            fArray2[0] = fArray2[0] / 1.0f;
            fArray2[1] = fArray2[1] / 1.0f;
            fArray2[2] = fArray2[2] / 1.0f;
            fArray2[3] = fArray2[3] / 1.0f;
            fArray2[4] = fArray2[4] / 1.0f;
            fArray2[5] = fArray2[5] / 1.0f;
            fArray2[6] = fArray2[6] / 1.0f;
            fArray2[7] = fArray2[7] / 1.0f;
            fArray2[8] = fArray2[8] / 1.0f;
            fArray2[9] = fArray2[9] / 1.0f;
            fArray2[10] = fArray2[10] / 1.0f;
            fArray2[11] = fArray2[11] / 1.0f;
            fArray2[12] = fArray2[12] / 1.02f;
            fArray2[13] = fArray2[13] / 1.03f;
            fArray2[14] = fArray2[14] / 1.03f;
            fArray2[15] = fArray2[15] / 1.04f;
            fArray2[16] = fArray2[16] / 1.05f;
            fArray2[17] = fArray2[17] / 1.06f;
            fArray2[18] = fArray2[18] / 1.08f;
            fArray2[19] = fArray2[19] / 1.11f;
            fArray2[20] = fArray2[20] / 1.15f;
            fArray2[21] = fArray2[21] / 1.17f;
            fArray2[22] = fArray2[22] / 1.15f;
            fArray2[23] = fArray2[23] / 0.98f;
            fArray2[24] = fArray2[24] / 1.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().entrySubProgress(0.7);
        int n2 = this.order.getSelectedIndex() + 1;
        for (int i = 0; i < n2; ++i) {
            if (LProgressViewer.getInstance().setProgress((double)(i + 1) * 1.0 / (double)n2)) {
                return;
            }
            LProgressViewer.getInstance().entrySubProgress(0.3, "order " + i);
            aLayerSelection.operateEachChannel(new AOEqualizer(fArray, fArray2, f));
            LProgressViewer.getInstance().exitSubProgress();
        }
        LProgressViewer.getInstance().exitSubProgress();
    }

    private void onPredefined() {
        int n = this.predefined.getSelectedIndex();
        for (int i = 0; i < this.bands.length; ++i) {
            this.bands[i].setValue((int)(this.bandsPresets[n][i] * 10.0f));
        }
    }

    private void onReset() {
        for (int i = 0; i < this.bands.length; ++i) {
            this.bands[i].setValue(0);
        }
    }

    private void onInvert() {
        for (int i = 0; i < this.bands.length; ++i) {
            this.bands[i].setValue(-this.bands[i].getValue());
        }
    }

    private class EventDispatcher
    implements ActionListener,
    ChangeListener {
        private EventDispatcher() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            GPEqualizer.this.smoothNeighbourBands();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPEqualizer.this.apply) {
                LProgressViewer.getInstance().entrySubProgress(GPEqualizer.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPEqualizer.this.getName() + " [apply] clicked");
                GPEqualizer.this.onApply();
                GPEqualizer.this.updateHistory(GLanguage.translate(GPEqualizer.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPEqualizer.this.reloadFocussedClipEditor();
                GPEqualizer.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPEqualizer.this.numberOfBands) {
                Debug.println(1, "plugin " + GPEqualizer.this.getName() + " [" + GPEqualizer.this.getNumberOfBands() + " bands] selected");
                GPEqualizer.this.reload();
            } else if (actionEvent.getSource() == GPEqualizer.this.predefined) {
                Debug.println(1, "plugin " + GPEqualizer.this.getName() + " [predefined] clicked");
                GPEqualizer.this.onPredefined();
            } else if (actionEvent.getSource() == GPEqualizer.this.reset) {
                Debug.println(1, "plugin " + GPEqualizer.this.getName() + " [reset] clicked");
                GPEqualizer.this.onReset();
            } else if (actionEvent.getSource() == GPEqualizer.this.invert) {
                Debug.println(1, "plugin " + GPEqualizer.this.getName() + " [invert] clicked");
                GPEqualizer.this.onInvert();
            }
            GPEqualizer.this.smoothNeighbourBands();
        }
    }
}

