/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOClickReduction;
import ch.laoe.operation.AOClippReparing;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPNoiseReduction
extends GPluginFrame {
    private UiControlText sense;
    private UiControlText smooth;
    private UiControlText clippMaxWidth;
    private UiControlText clippMinDerivation;
    private JButton applyClickReduction;
    private JButton applyClippRemoving;
    private EventDispatcher eventDispatcher;

    public GPNoiseReduction(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "noiseReduction";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("sense")), 0, 0, 4, 1);
        this.sense = new GControlTextA(10, true, true);
        this.sense.setDataRange(0.1, 1.0);
        this.sense.setData(0.7);
        uiCartesianLayout.add(this.sense, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("smooth")), 0, 1, 4, 1);
        this.smooth = new GControlTextX(Laoe.getInstance(), 10, true, true);
        this.smooth.setDataRange(0.0, 100.0);
        this.smooth.setData(40.0);
        uiCartesianLayout.add(this.smooth, 4, 1, 6, 1);
        this.applyClickReduction = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.applyClickReduction, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("clickReduction"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 5);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("maxWidth")), 0, 0, 4, 1);
        this.clippMaxWidth = new GControlTextX(Laoe.getInstance(), 10, true, true);
        this.clippMaxWidth.setDataRange(1.0, 10000.0);
        this.clippMaxWidth.setData(1000.0);
        uiCartesianLayout2.add(this.clippMaxWidth, 4, 0, 6, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("minYStep")), 0, 1, 4, 1);
        this.clippMinDerivation = new GControlTextA(10, true, true);
        this.clippMinDerivation.setDataRange(0.1, 1.0);
        this.clippMinDerivation.setData(0.9);
        uiCartesianLayout2.add(this.clippMinDerivation, 4, 1, 6, 1);
        this.applyClippRemoving = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applyClippRemoving, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("clippRemoving"), jPanel2);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.applyClickReduction.addActionListener(new LWorker(this.eventDispatcher));
        this.applyClippRemoving.addActionListener(new LWorker(this.eventDispatcher));
    }

    @Override
    public void reload() {
        super.reload();
        this.sense.refresh();
        this.smooth.refresh();
        this.clippMaxWidth.refresh();
        this.clippMinDerivation.refresh();
    }

    private void onApplyClickReduction() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(new AOClickReduction((float)this.sense.getData(), (int)this.smooth.getData()));
    }

    private void onApplyClippRemoving() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(new AOClippReparing((int)this.clippMaxWidth.getData(), (float)this.clippMinDerivation.getData()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPNoiseReduction.this.applyClickReduction) {
                LProgressViewer.getInstance().entrySubProgress(GPNoiseReduction.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPNoiseReduction.this.getName() + " [apply click reduction] clicked");
                GPNoiseReduction.this.onApplyClickReduction();
                GPNoiseReduction.this.updateHistory(GLanguage.translate(GPNoiseReduction.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPNoiseReduction.this.reloadFocussedClipEditor();
                GPNoiseReduction.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPNoiseReduction.this.applyClippRemoving) {
                LProgressViewer.getInstance().entrySubProgress(GPNoiseReduction.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPNoiseReduction.this.getName() + " [apply clipp removing] clicked");
                GPNoiseReduction.this.onApplyClippRemoving();
                GPNoiseReduction.this.updateHistory(GLanguage.translate(GPNoiseReduction.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPNoiseReduction.this.reloadFocussedClipEditor();
                GPNoiseReduction.this.autoCloseNow();
            }
        }
    }
}

