/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannelPlotterSpectrogram;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GColorPicker;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlEvent;
import ch.oli4.ui.control.UiControlListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPViewOptions
extends GPluginFrame {
    private JComboBox windowType;
    private JCheckBox numericRuler;
    private JCheckBox grid;
    private GColorPicker gridColor;
    private GColorPicker bgColor;
    private GComboBoxPowerOf2 fftLength;
    private GControlTextA layerColorGamma;
    private EventDispatcher eventDispatcher;

    public GPViewOptions(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "viewOptions";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(20, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.grid = new JCheckBox(GLanguage.translate("grid"));
        this.grid.setSelected(AClipPlotter.isGridVisible());
        jPanel.add((Component)this.grid, new Rectangle(0, 0, 8, 1));
        this.numericRuler = new JCheckBox(GLanguage.translate("numericRuler"));
        this.numericRuler.setSelected(AClipPlotter.isSkalaValuesVisible());
        jPanel.add((Component)this.numericRuler, new Rectangle(0, 1, 8, 1));
        this.gridColor = new GColorPicker(GLanguage.translate("grid"), GLanguage.translate("gridColor"));
        this.gridColor.setToolTipText(GLanguage.translate("gridColor"));
        jPanel.add((Component)this.gridColor, new Rectangle(0, 2, 8, 1));
        this.bgColor = new GColorPicker(GLanguage.translate("background"), GLanguage.translate("backgroundColor"));
        this.bgColor.setToolTipText(GLanguage.translate("backgroundColor"));
        jPanel.add((Component)this.bgColor, new Rectangle(0, 3, 8, 1));
        jTabbedPane.add((Component)jPanel, GLanguage.translate("ruler"));
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 5);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(20, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("fftLength")), 0, 0, 4, 1);
        this.fftLength = new GComboBoxPowerOf2(4, 12);
        this.fftLength.setSelectedExponent(11);
        uiCartesianLayout2.add(this.fftLength, 4, 0, 6, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("window")), 0, 1, 4, 1);
        this.windowType = new JComboBox<String>(AOToolkit.getFFTWindowNames());
        this.windowType.setSelectedIndex(3);
        uiCartesianLayout2.add(this.windowType, 4, 1, 6, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("brightness")), 0, 2, 4, 1);
        this.layerColorGamma = new GControlTextA(9, true, true);
        this.layerColorGamma.setDataRange(0.0, 1.0);
        this.layerColorGamma.setData(0.33);
        uiCartesianLayout2.add(this.layerColorGamma, 4, 2, 6, 1);
        jTabbedPane.add((Component)jPanel2, GLanguage.translate("spectrogram"));
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.grid.addActionListener(this.eventDispatcher);
        this.gridColor.addActionListener(this.eventDispatcher);
        this.bgColor.addActionListener(this.eventDispatcher);
        this.numericRuler.addActionListener(this.eventDispatcher);
        this.fftLength.addActionListener(this.eventDispatcher);
        this.windowType.addActionListener(this.eventDispatcher);
        this.layerColorGamma.addControlListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.gridColor.setSelectedColor(this.getFocussedClip().getPlotter().getGridColor());
        this.getFocussedClip().getPlotter();
        this.grid.setSelected(AClipPlotter.isGridVisible());
        this.getFocussedClip().getPlotter();
        this.numericRuler.setSelected(AClipPlotter.isSkalaValuesVisible());
        this.bgColor.setSelectedColor(this.getFocussedClip().getPlotter().getBgColor());
        this.fftLength.setSelectedValue(AChannelPlotterSpectrogram.getFftLength());
        this.layerColorGamma.setData(this.getFocussedClip().getSelectedLayer().getPlotter().getColorGamma());
        this.windowType.setSelectedIndex(AChannelPlotterSpectrogram.getWindowType());
    }

    private class EventDispatcher
    implements ActionListener,
    UiControlListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPViewOptions.this.fftLength) {
                Debug.println(1, "plugin " + GPViewOptions.this.getName() + " [fft length] clicked");
                AChannelPlotterSpectrogram.setFftLength(GPViewOptions.this.fftLength.getSelectedValue());
                GPViewOptions.this.reloadFocussedClipEditor();
            } else if (actionEvent.getSource() == GPViewOptions.this.grid) {
                Debug.println(1, "plugin " + GPViewOptions.this.getName() + " [grid] clicked");
                AClipPlotter.setGridVisible(GPViewOptions.this.grid.isSelected());
                GPViewOptions.this.reloadFocussedClipEditor();
            } else if (actionEvent.getSource() == GPViewOptions.this.gridColor) {
                GPViewOptions.this.pluginHandler.getFocussedClip().getPlotter().setGridColor(GPViewOptions.this.gridColor.getSelectedColor());
                GPViewOptions.this.reloadFocussedClipEditor();
            } else if (actionEvent.getSource() == GPViewOptions.this.bgColor) {
                GPViewOptions.this.pluginHandler.getFocussedClip().getPlotter().setBgColor(GPViewOptions.this.bgColor.getSelectedColor());
                GPViewOptions.this.reloadFocussedClipEditor();
            } else if (actionEvent.getSource() == GPViewOptions.this.numericRuler) {
                Debug.println(1, "plugin " + GPViewOptions.this.getName() + " [numeric ruler] clicked");
                AClipPlotter.setSkalaValuesVisible(GPViewOptions.this.numericRuler.isSelected());
                GPViewOptions.this.reloadFocussedClipEditor();
            } else if (actionEvent.getSource() == GPViewOptions.this.windowType) {
                Debug.println(1, "plugin " + GPViewOptions.this.getName() + " [window type] clicked");
                AChannelPlotterSpectrogram.setWindowType(GPViewOptions.this.windowType.getSelectedIndex());
                GPViewOptions.this.reloadFocussedClipEditor();
            }
        }

        @Override
        public void onDataChanging(UiControlEvent uiControlEvent) {
        }

        @Override
        public void onDataChanged(UiControlEvent uiControlEvent) {
            if (uiControlEvent.getSource() == GPViewOptions.this.layerColorGamma) {
                Debug.println(1, "plugin " + GPViewOptions.this.getName() + " [layer color gamma] changed");
                GPViewOptions.this.getFocussedClip().getSelectedLayer().getPlotter().setColorGamma((float)GPViewOptions.this.layerColorGamma.getData());
                GPViewOptions.this.reloadFocussedClipEditor();
            }
        }

        @Override
        public void onValidate(UiControlEvent uiControlEvent) {
        }
    }
}

