/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerPlotter;
import ch.laoe.plugin.GPMeasure;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextSF;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlEvent;
import ch.oli4.ui.control.UiControlListener;
import ch.oli4.ui.control.UiControlText;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class GPZoom
extends GPluginFrame {
    private BasicStroke dashedStroke;
    private BasicStroke normalStroke;
    private AChannelPlotter mouseChannelPlotter;
    private int mouseZoomXPress;
    private int mouseZoomYPress;
    private int mouseZoomXReleas;
    private int mouseZoomYReleas;
    private int mouseZoomXOld;
    private int mouseZoomYOld;
    private boolean shiftActive;
    private boolean ctrlActive;
    private boolean mouseDown;
    private UiControlText scaleX;
    private UiControlText scaleY;
    private UiControlText offsetX;
    private UiControlText offsetY;
    private JButton autoScale;
    private JCheckBox individualY;
    private JCheckBox autoX;
    private JCheckBox autoY;
    private JComboBox xAutoMode;
    private JComboBox yAutoMode;
    private EventDispatcher eventDispatcher;
    private Cursor moveCursor;
    private Cursor xCursor;
    private Cursor yCursor;
    private Cursor xyCursor;
    private Cursor actualCursor;

    public GPZoom(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "zoom";
    }

    @Override
    public JMenuItem createMenuItem() {
        return super.createMenuItem(49);
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    @Override
    public void reload() {
        super.reload();
        if (this.pluginHandler.getFocussedClipEditor() != null) {
            this.reloadZoomFrame();
        }
    }

    @Override
    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.mouseDown) {
            int n = Math.min(this.mouseZoomXPress, this.mouseZoomXReleas);
            int n2 = Math.abs(this.mouseZoomXReleas - this.mouseZoomXPress);
            int n3 = Math.min(this.mouseZoomYPress, this.mouseZoomYReleas);
            int n4 = Math.abs(this.mouseZoomYReleas - this.mouseZoomYPress);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (this.shiftActive && this.ctrlActive) {
                graphics2D.setColor(Color.white);
                graphics2D.setStroke(this.normalStroke);
                graphics2D.drawRect(n, n3, n2, n4);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(this.dashedStroke);
                graphics2D.drawRect(n, n3, n2, n4);
            } else if (this.shiftActive) {
                graphics2D.setColor(Color.white);
                graphics2D.setStroke(this.normalStroke);
                graphics2D.drawRect(n, 0, n2, rectangle.height - 1);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(this.dashedStroke);
                graphics2D.drawRect(n, 0, n2, rectangle.height - 1);
            } else if (this.ctrlActive) {
                graphics2D.setColor(Color.white);
                graphics2D.setStroke(this.normalStroke);
                graphics2D.drawRect(0, n3, rectangle.width - 1, n4);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(this.dashedStroke);
                graphics2D.drawRect(0, n3, rectangle.width - 1, n4);
            } else {
                graphics2D.setColor(Color.white);
                graphics2D.setStroke(this.normalStroke);
                graphics2D.drawLine(this.mouseZoomXPress, this.mouseZoomYPress, this.mouseZoomXReleas, this.mouseZoomYReleas);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(this.dashedStroke);
                graphics2D.drawLine(this.mouseZoomXPress, this.mouseZoomYPress, this.mouseZoomXReleas, this.mouseZoomYReleas);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Debug.println(5, "mouse pressed: start zoom functionality");
        this.mouseDown = true;
        this.mouseZoomXPress = mouseEvent.getPoint().x;
        this.mouseZoomYPress = mouseEvent.getPoint().y;
        this.mouseZoomXReleas = this.mouseZoomXPress;
        this.mouseZoomYReleas = this.mouseZoomYPress;
        this.mouseZoomXOld = this.mouseZoomXPress;
        this.mouseZoomYOld = this.mouseZoomYPress;
        this.shiftActive = GToolkit.isShiftKey(mouseEvent);
        this.ctrlActive = GToolkit.isCtrlKey(mouseEvent);
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        int n = aLayer.getPlotter().getInsideChannelIndex(mouseEvent.getPoint());
        this.mouseChannelPlotter = aLayer.getChannel(n).getPlotter();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDown = false;
        double d = this.mouseChannelPlotter.graphToSampleX(this.mouseZoomXPress);
        double d2 = this.mouseChannelPlotter.graphToSampleX(this.mouseZoomXReleas);
        double d3 = Math.min(d, d2);
        double d4 = Math.max(d, d2);
        int n = this.mouseZoomXReleas - this.mouseZoomXPress;
        float f = this.mouseChannelPlotter.graphToSampleY(this.mouseZoomYPress);
        float f2 = this.mouseChannelPlotter.graphToSampleY(this.mouseZoomYReleas);
        float f3 = Math.min(f, f2);
        float f4 = Math.max(f, f2);
        int n2 = this.mouseZoomYReleas - this.mouseZoomYPress;
        AClipPlotter aClipPlotter = this.getFocussedClip().getPlotter();
        ALayerPlotter aLayerPlotter = this.getFocussedClip().getSelectedLayer().getPlotter();
        if (this.shiftActive || this.ctrlActive) {
            if (this.shiftActive && Math.abs(n) > 0) {
                Debug.println(5, "mouse released: zoom x into rectangle");
                aClipPlotter.setXRange(d3, d4 - d3);
            }
            if (this.ctrlActive && Math.abs(n2) > 0) {
                Debug.println(5, "mouse released: zoom y into rectangle");
                if (this.individualY.isSelected()) {
                    aLayerPlotter.setYRange(f3, f4 - f3);
                } else {
                    aClipPlotter.setYRange(f3, f4 - f3);
                }
            }
        }
        if (mouseEvent.getClickCount() == 0) {
            this.reloadZoomFrame();
            this.reloadFocussedClipEditor();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Debug.println(5, "zoom out on click");
        AClipPlotter aClipPlotter = this.getFocussedClip().getPlotter();
        ALayerPlotter aLayerPlotter = this.getFocussedClip().getSelectedLayer().getPlotter();
        if (mouseEvent.getClickCount() == 1) {
            if (GToolkit.isShiftKey(mouseEvent)) {
                Debug.println(5, "mouse clicked: zoom out x");
                aClipPlotter.zoomX(0.5);
            }
            if (GToolkit.isCtrlKey(mouseEvent)) {
                Debug.println(5, "mouse clicked: zoom out y");
                if (this.individualY.isSelected()) {
                    aLayerPlotter.zoomY(0.5);
                } else {
                    aClipPlotter.zoomY(0.5);
                }
            }
        } else if (mouseEvent.getClickCount() == 2) {
            if (GToolkit.isShiftKey(mouseEvent)) {
                Debug.println(5, "mouse double-clicked: autoscale visible x");
                aClipPlotter.autoScaleX();
            }
            if (GToolkit.isCtrlKey(mouseEvent)) {
                Debug.println(5, "mouse double-clicked: autoscale visible y");
                if (this.individualY.isSelected()) {
                    aLayerPlotter.autoScaleY();
                } else {
                    aClipPlotter.autoScaleY();
                }
            }
        }
        this.reloadZoomFrame();
        this.reloadFocussedClipEditor();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseZoomXOld = this.mouseZoomXReleas;
        this.mouseZoomYOld = this.mouseZoomYReleas;
        this.mouseZoomXReleas = mouseEvent.getPoint().x;
        this.mouseZoomYReleas = mouseEvent.getPoint().y;
        if (!this.shiftActive && !this.ctrlActive) {
            double d = this.mouseChannelPlotter.graphToSampleX(this.mouseZoomXReleas);
            double d2 = this.mouseChannelPlotter.graphToSampleX(this.mouseZoomXOld);
            float f = this.mouseChannelPlotter.graphToSampleY(this.mouseZoomYReleas);
            float f2 = this.mouseChannelPlotter.graphToSampleY(this.mouseZoomYOld);
            AClipPlotter aClipPlotter = this.getFocussedClip().getPlotter();
            ALayerPlotter aLayerPlotter = this.getFocussedClip().getSelectedLayer().getPlotter();
            Debug.println(5, "mouse released: move xy offset");
            if (this.individualY.isSelected()) {
                aLayerPlotter.translateYOffset(f2 - f);
            } else {
                aClipPlotter.translateYOffset(f2 - f);
            }
            aClipPlotter.translateXOffset(d2 - d);
            this.reloadZoomFrame();
            this.pluginHandler.getFocussedClipEditor().reload();
        } else {
            this.reloadZoomFrame();
            this.repaintFocussedClipEditor();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = GToolkit.isShiftKey(mouseEvent) ? (GToolkit.isCtrlKey(mouseEvent) ? this.xyCursor : this.xCursor) : (GToolkit.isCtrlKey(mouseEvent) ? this.yCursor : this.moveCursor);
        if (cursor != this.actualCursor) {
            this.actualCursor = cursor;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        int n = aLayer.getPlotter().getInsideChannelIndex(mouseWheelEvent.getPoint());
        AChannelPlotter aChannelPlotter = aLayer.getChannel(n).getPlotter();
        double d = aChannelPlotter.graphToSampleX(mouseWheelEvent.getX());
        double d2 = aChannelPlotter.graphToSampleY(mouseWheelEvent.getY());
        int n2 = mouseWheelEvent.getWheelRotation();
        AClipPlotter aClipPlotter = this.getFocussedClip().getPlotter();
        ALayerPlotter aLayerPlotter = this.getFocussedClip().getSelectedLayer().getPlotter();
        if (GToolkit.isShiftKey(mouseWheelEvent)) {
            if (GToolkit.isCtrlKey(mouseWheelEvent)) {
                aClipPlotter.zoomX(n2 > 0 ? (double)1.1f : 0.9090908893868948, d);
                if (this.individualY.isSelected()) {
                    aLayerPlotter.zoomY(n2 > 0 ? (double)1.1f : 0.9090908893868948, d2);
                } else {
                    aClipPlotter.zoomY(n2 > 0 ? (double)1.1f : 0.9090908893868948, d2);
                }
            } else {
                aClipPlotter.zoomX(n2 > 0 ? (double)1.1f : 0.9090908893868948, d);
            }
        } else if (GToolkit.isCtrlKey(mouseWheelEvent)) {
            if (this.individualY.isSelected()) {
                aLayerPlotter.zoomY(n2 > 0 ? (double)1.1f : 0.9090908893868948, d2);
            } else {
                aClipPlotter.zoomY(n2 > 0 ? (double)1.1f : 0.9090908893868948, d2);
            }
        } else if (this.individualY.isSelected()) {
            aClipPlotter.translateXOffset(aLayerPlotter.getLayerModel().getChannel(0).getPlotter().getXLength() * (n2 > 0 ? (double)0.035f : (double)-0.035f));
        } else {
            aClipPlotter.translateXOffset(aClipPlotter.getClipModel().getLayer(0).getChannel(0).getPlotter().getXLength() * (n2 > 0 ? (double)0.035f : (double)-0.035f));
        }
        this.reloadZoomFrame();
        this.pluginHandler.getFocussedClipEditor().reload();
    }

    public void initGui() {
        this.moveCursor = this.createCustomCursor("zoomMoveCursor");
        this.xCursor = this.createCustomCursor("zoomXCursor");
        this.yCursor = this.createCustomCursor("zoomYCursor");
        this.xyCursor = this.createCustomCursor("zoomXYCursor");
        this.actualCursor = null;
        float[] fArray = new float[]{4.0f, 4.0f};
        this.dashedStroke = new BasicStroke(1.0f, 2, 0, 1.0f, fArray, 0.0f);
        this.normalStroke = new BasicStroke();
        JPanel jPanel = new JPanel();
        this.frame.getContentPane().add(jPanel);
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(35, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.autoX = new JCheckBox(GLanguage.translate("x"));
        this.autoX.setSelected(true);
        uiCartesianLayout.add(this.autoX, 2, 0, 4, 1);
        this.autoY = new JCheckBox(GLanguage.translate("y"));
        this.autoY.setSelected(true);
        uiCartesianLayout.add(this.autoY, 6, 0, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("offset")), 0, 1, 2, 1);
        this.offsetX = new GControlTextSF(Laoe.getInstance(), 9, true, true);
        this.offsetX.setDataRange(-1.0E9, 1.0E9);
        this.offsetX.setData(1.0);
        this.offsetX.setUnit("s");
        uiCartesianLayout.add(this.offsetX, 2, 1, 4, 1);
        this.offsetY = new GControlTextY(Laoe.getInstance(), 9, true, true);
        this.offsetY.setDataRange(-1.0E9, 1.0E9);
        this.offsetY.setData(1.0);
        this.offsetY.setUnit("%");
        uiCartesianLayout.add(this.offsetY, 6, 1, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("range")), 0, 2, 2, 1);
        this.scaleX = new GControlTextSF(Laoe.getInstance(), 9, true, true);
        this.scaleX.setDataRange(0.0, 1.0E9);
        this.scaleX.setData(1.0);
        this.scaleX.setUnit("s");
        uiCartesianLayout.add(this.scaleX, 2, 2, 4, 1);
        this.scaleY = new GControlTextY(Laoe.getInstance(), 9, true, true);
        this.scaleY.setDataRange(0.0, 1.0E9);
        this.scaleY.setData(1.0);
        this.scaleY.setUnit("%");
        uiCartesianLayout.add(this.scaleY, 6, 2, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("mode")), 0, 3, 2, 1);
        String[] stringArray = new String[]{GLanguage.translate("wholeClip"), GLanguage.translate("loopPoints"), GLanguage.translate("measurePoints"), GLanguage.translate("selections")};
        this.xAutoMode = new JComboBox<String>(stringArray);
        this.xAutoMode.setSelectedIndex(0);
        uiCartesianLayout.add(this.xAutoMode, 2, 3, 4, 1);
        String[] stringArray2 = new String[]{GLanguage.translate("wholeClip"), GLanguage.translate("zoomedRange"), GLanguage.translate("sampleWidth"), GLanguage.translate("selections")};
        this.yAutoMode = new JComboBox<String>(stringArray2);
        this.yAutoMode.setSelectedIndex(1);
        uiCartesianLayout.add(this.yAutoMode, 6, 3, 4, 1);
        this.individualY = new JCheckBox(GLanguage.translate("yIndividual"));
        uiCartesianLayout.add(this.individualY, 0, 4, 4, 1);
        this.autoScale = new JButton(GLanguage.translate("autoscale"));
        uiCartesianLayout.add(this.autoScale, 4, 4, 4, 1);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.scaleX.addControlListener(this.eventDispatcher);
        this.scaleY.addControlListener(this.eventDispatcher);
        this.offsetX.addControlListener(this.eventDispatcher);
        this.offsetY.addControlListener(this.eventDispatcher);
        this.individualY.addActionListener(this.eventDispatcher);
        this.autoScale.addActionListener(this.eventDispatcher);
    }

    private void reloadZoomFrame() {
        AChannelPlotter aChannelPlotter = this.getFocussedClip().getSelectedLayer().getChannel(0).getPlotter();
        this.scaleX.setData(aChannelPlotter.getXLength());
        this.scaleY.setData(aChannelPlotter.getYLength());
        this.offsetX.setData(aChannelPlotter.getXOffset());
        this.offsetY.setData(aChannelPlotter.getYOffset());
    }

    private class EventDispatcher
    implements UiControlListener,
    ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPZoom.this.individualY) {
                Debug.println(1, "plugin " + GPZoom.this.getName() + " [individual y] clicked");
                AClipPlotter.setAutoScaleIndividualYEnabled(GPZoom.this.individualY.isSelected());
            } else if (actionEvent.getSource() == GPZoom.this.autoScale) {
                Debug.println(1, "plugin " + GPZoom.this.getName() + " [autoscale] clicked");
                AClip aClip = GPZoom.this.getFocussedClip();
                AClipPlotter aClipPlotter = aClip.getPlotter();
                ALayer aLayer = aClip.getSelectedLayer();
                AChannel aChannel = aLayer.getChannel(0);
                AChannelPlotter aChannelPlotter = aChannel.getPlotter();
                if (GPZoom.this.autoX.isSelected()) {
                    switch (GPZoom.this.xAutoMode.getSelectedIndex()) {
                        case 0: {
                            aClipPlotter.autoScaleX();
                            break;
                        }
                        case 1: {
                            double d = aClip.getAudio().getLoopStartPointer();
                            double d2 = aClip.getAudio().getLoopEndPointer() - aClip.getAudio().getLoopStartPointer();
                            aClipPlotter.setXRange(d - (double)0.03f * d2, d2 * (double)1.06f);
                            break;
                        }
                        case 2: {
                            double d = GPMeasure.getLowerCursor();
                            double d2 = GPMeasure.getHigherCursor() - GPMeasure.getLowerCursor();
                            aClipPlotter.setXRange(d - (double)0.03f * d2, d2 * (double)1.06f);
                            break;
                        }
                        case 3: {
                            double d = aLayer.getSelection().getLowestSelectedIndex();
                            double d2 = aLayer.getSelection().getHighestSelectedIndex() - aLayer.getSelection().getLowestSelectedIndex();
                            aClipPlotter.setXRange(d - (double)0.03f * d2, d2 * (double)1.06f);
                        }
                    }
                }
                if (GPZoom.this.autoY.isSelected()) {
                    switch (GPZoom.this.yAutoMode.getSelectedIndex()) {
                        case 0: {
                            aClipPlotter.autoScaleY();
                            break;
                        }
                        case 1: {
                            int n = (int)aChannelPlotter.getXOffset();
                            int n2 = (int)aChannelPlotter.getXLength();
                            aClipPlotter.autoScaleY(n, n2);
                            break;
                        }
                        case 2: {
                            float f = 1 << aClip.getSampleWidth() - 1;
                            aClipPlotter.setYRange(-f * 1.03f, 2.0f * f * 1.03f);
                            break;
                        }
                        case 3: {
                            int n = aLayer.getSelection().getLowestSelectedIndex();
                            int n3 = aLayer.getSelection().getHighestSelectedIndex() - aLayer.getSelection().getLowestSelectedIndex();
                            aClipPlotter.autoScaleY(n, n3);
                        }
                    }
                }
                GPZoom.this.reloadZoomFrame();
                GPZoom.this.reloadFocussedClipEditor();
            }
        }

        @Override
        public void onDataChanging(UiControlEvent uiControlEvent) {
        }

        @Override
        public void onDataChanged(UiControlEvent uiControlEvent) {
            AClip aClip = GPZoom.this.getFocussedClip();
            AClipPlotter aClipPlotter = aClip.getPlotter();
            ALayerPlotter aLayerPlotter = aClip.getSelectedLayer().getPlotter();
            if (uiControlEvent.getSource() == GPZoom.this.scaleX || uiControlEvent.getSource() == GPZoom.this.offsetX) {
                Debug.println(1, "plugin " + GPZoom.this.getName() + " [scale x] changed");
                if (GPZoom.this.individualY.isSelected()) {
                    aLayerPlotter.setXRange((float)GPZoom.this.offsetX.getData(), (float)GPZoom.this.scaleX.getData());
                } else {
                    aClipPlotter.setXRange((float)GPZoom.this.offsetX.getData(), (float)GPZoom.this.scaleX.getData());
                }
            } else if (uiControlEvent.getSource() == GPZoom.this.scaleY || uiControlEvent.getSource() == GPZoom.this.offsetY) {
                Debug.println(1, "plugin " + GPZoom.this.getName() + " [scale y] changed");
                if (GPZoom.this.individualY.isSelected()) {
                    aLayerPlotter.setYRange((float)GPZoom.this.offsetY.getData(), (float)GPZoom.this.scaleY.getData());
                } else {
                    aClipPlotter.setYRange((float)GPZoom.this.offsetY.getData(), (float)GPZoom.this.scaleY.getData());
                }
            }
            GPZoom.this.reloadZoomFrame();
            GPZoom.this.reloadFocussedClipEditor();
        }

        @Override
        public void onValidate(UiControlEvent uiControlEvent) {
        }
    }
}

