/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.ui.GClipFrame;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GClipLayerChannelChooser
extends JPanel
implements ActionListener {
    private Laoe main;
    private JComboBox paramChannel;
    private JComboBox paramLayer;
    private JComboBox paramClip;

    public GClipLayerChannelChooser(Laoe laoe) {
        this.main = laoe;
        this.initGui("channel");
    }

    public GClipLayerChannelChooser(Laoe laoe, String string) {
        this.main = laoe;
        this.initGui(string);
    }

    private void initGui(String string) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 3);
        jPanel.setLayout(uiCartesianLayout);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), GLanguage.translate(string)));
        uiCartesianLayout.add(new JLabel(GLanguage.translate("clip")), 0, 0, 3, 1);
        this.paramClip = new JComboBox();
        uiCartesianLayout.add(this.paramClip, 3, 0, 7, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("layer")), 0, 1, 3, 1);
        this.paramLayer = new JComboBox();
        uiCartesianLayout.add(this.paramLayer, 3, 1, 7, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("channel")), 0, 2, 3, 1);
        this.paramChannel = new JComboBox();
        uiCartesianLayout.add(this.paramChannel, 3, 2, 7, 1);
        this.add((Component)jPanel, "Center");
        this.paramClip.addActionListener(this);
        this.paramLayer.addActionListener(this);
        this.paramChannel.addActionListener(this);
        this.reload();
    }

    private void updateParameterClip() {
        Object[] objectArray = this.main.getAllClipFrames();
        if (objectArray != null) {
            int n = objectArray.length;
            int n2 = this.paramClip.getSelectedIndex();
            this.paramClip.removeAllItems();
            for (int i = 0; i < n; ++i) {
                this.paramClip.addItem(((GClipFrame)objectArray[i]).getClipEditor().getClip());
            }
            if (n2 < n) {
                this.paramClip.setSelectedIndex(n2);
            }
        }
    }

    private void updateParameterLayer() {
        AClip aClip = (AClip)this.paramClip.getSelectedItem();
        if (aClip != null) {
            int n = aClip.getNumberOfLayers();
            int n2 = this.paramLayer.getSelectedIndex();
            this.paramLayer.removeAllItems();
            for (int i = 0; i < n; ++i) {
                this.paramLayer.addItem(aClip.getLayer(i));
            }
            if (n2 < n) {
                this.paramLayer.setSelectedIndex(n2);
            }
        }
    }

    private void updateParameterChannel() {
        ALayer aLayer = (ALayer)this.paramLayer.getSelectedItem();
        if (aLayer != null) {
            int n = aLayer.getNumberOfChannels();
            int n2 = this.paramChannel.getSelectedIndex();
            this.paramChannel.removeAllItems();
            for (int i = 0; i < n; ++i) {
                this.paramChannel.addItem(aLayer.getChannel(i));
            }
            if (n2 < n) {
                this.paramChannel.setSelectedIndex(n2);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.paramClip) {
                this.updateParameterLayer();
                this.updateParameterChannel();
            } else if (actionEvent.getSource() == this.paramLayer) {
                this.updateParameterChannel();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public AChannel getSelectedChannel() {
        return (AChannel)this.paramChannel.getSelectedItem();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.paramClip.setEnabled(bl);
        this.paramLayer.setEnabled(bl);
        this.paramChannel.setEnabled(bl);
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.paramClip.isEnabled();
    }

    public void reload() {
        this.updateParameterClip();
        this.updateParameterLayer();
        this.updateParameterChannel();
    }
}

