/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.console;

import ch.oli4.console.CCommandImpl;
import ch.oli4.console.CConsole;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class CCommandHistory
extends CCommandImpl {
    private LinkedList history = new LinkedList();
    private int historyIndex;

    public CCommandHistory(String name) {
        super(name, "", "history browser, o for older, n for newer");
    }

    public CCommandHistory() {
        this("^");
    }

    private void addToHistory(String line) {
        if (!this.isSameAsOlderCommand(line)) {
            this.history.add(line);
            this.historyIndex = this.history.size() - 1;
        }
    }

    private boolean isSameAsOlderCommand(String line) {
        if (this.history.size() == 0) {
            return false;
        }
        return line.equals(this.history.getLast());
    }

    private String getOlder() {
        if (this.historyIndex > 0) {
            --this.historyIndex;
        }
        return (String)this.history.get(this.historyIndex);
    }

    private String getNewer() {
        if (this.historyIndex < this.history.size() - 1) {
            ++this.historyIndex;
        }
        return (String)this.history.get(this.historyIndex);
    }

    private String getCurrent() {
        return (String)this.history.get(this.historyIndex);
    }

    public boolean onConsoleCommand(CConsole console, String commandLine) {
        StringTokenizer t = new StringTokenizer(commandLine);
        if (t.countTokens() >= 1) {
            String cmd = t.nextToken();
            if (cmd.equals(this.name)) {
                while (true) {
                    String c;
                    int range = 10;
                    int begin = Math.max(0, this.historyIndex - range / 2);
                    int end = Math.min(this.history.size(), begin + range);
                    console.println("history: o for older, n for newer");
                    int i = begin;
                    while (i < end) {
                        if (this.historyIndex == i) {
                            console.println("--> [" + i + "]> " + this.history.get(i));
                        } else {
                            console.println("    [" + i + "]> " + this.history.get(i));
                        }
                        ++i;
                    }
                    String str = console.readInputCommand();
                    if (str == null) {
                        return true;
                    }
                    if (str.startsWith("n\n")) {
                        c = this.getNewer();
                        continue;
                    }
                    if (str.startsWith("o\n")) {
                        c = this.getOlder();
                        continue;
                    }
                    if (str.startsWith("\n")) break;
                }
                console.printPrompt();
                console.print(this.getCurrent());
                String s = console.readInputCommand();
                if (s == null) {
                    return true;
                }
                console.fireOnConsoleCommand(String.valueOf(this.getCurrent()) + s);
                return true;
            }
            this.addToHistory(commandLine.trim());
        }
        return false;
    }

    public void onConsoleStart() {
    }

    public void onConsoleStop() {
    }
}

