/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.console;

import ch.oli4.console.CCommand;
import ch.oli4.console.CCommandAutoComplete;
import ch.oli4.console.CCommandHelp;
import ch.oli4.console.CCommandHistory;
import ch.oli4.console.CCommandInfo;
import ch.oli4.console.CCommandManPage;
import ch.oli4.console.CCommandRepeat;
import ch.oli4.console.CCommandScript;
import ch.oli4.console.CConsoleListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class CConsole
implements Runnable {
    private InputStream in;
    private PrintStream out;
    private Map commands;
    private StringBuffer currentInput;
    private boolean running = true;
    private static final int ESC_CHAR = 27;
    private String prompt = ">";
    private String returnString = "";
    private WeakHashMap<CConsoleListener, Object> listeners;

    public CConsole(InputStream in, PrintStream out) {
        this.connectStreams(in, out);
        this.commands = new TreeMap();
        this.currentInput = new StringBuffer();
        this.listeners = new WeakHashMap();
    }

    public void start() {
        Thread t = new Thread(this);
        this.running = true;
        t.start();
    }

    public void stop() {
        this.running = false;
    }

    private void connectStreams(InputStream in, PrintStream out) {
        this.in = in;
        this.out = out;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void addCommand(CCommand command) {
        this.commands.put(command.name, command);
        if (command instanceof CConsoleListener) {
            this.addConsoleListener((CConsoleListener)((Object)command));
        }
    }

    public void addSystemCommands() {
        this.addCommand(new CCommandAutoComplete());
        this.addCommand(new CCommandRepeat());
        this.addCommand(new CCommandHistory());
        this.addCommand(new CCommandHelp());
        this.addCommand(new CCommandManPage());
        this.addCommand(new CCommandScript());
    }

    Map getCommandMap() {
        return this.commands;
    }

    public void run() {
        this.fireOnConsoleStart();
        while (this.running) {
            try {
                this.scan();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fireOnConsoleStop();
    }

    private void scan() throws IOException {
        this.cleanInputStream();
        this.printPrompt();
        String s = this.readInputCommand();
        if (s != null && s.trim().length() > 0) {
            this.fireOnConsoleCommand(s);
        }
    }

    private void cleanInputStream() throws IOException {
        while (this.in.available() > 0) {
            this.in.read();
        }
    }

    String readInputCommand() {
        try {
            int d;
            StringBuffer sb = new StringBuffer();
            do {
                d = this.getInputStream().read();
                sb.append((char)d);
                if (!this.isEnter(d)) continue;
                return sb.toString();
            } while (!this.isEsc(d));
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isEnter(int d) {
        return d == 10 || d == 13;
    }

    private boolean isEsc(int d) {
        return d == 27;
    }

    private void printCurrentLine() {
        this.out.print(this.currentInput.toString());
    }

    public void setPromptString(String p) {
        this.prompt = p;
    }

    public String getPromptString() {
        return this.prompt;
    }

    public void println() {
        this.returnString = "";
        this.out.println();
    }

    public void println(String s) {
        this.returnString = s;
        this.out.println(s);
    }

    public void print(String s) {
        this.returnString = s;
        this.out.print(s);
    }

    String getReturnString() {
        return this.returnString;
    }

    void printPrompt() {
        this.out.print(this.prompt);
    }

    void printError(String command) {
        this.out.println("ERROR: command: " + command);
    }

    public void addConsoleListener(CConsoleListener l) {
        this.listeners.put(l, null);
    }

    boolean fireOnConsoleCommand(String commandLine) {
        for (CConsoleListener l : this.listeners.keySet()) {
            if (!l.onConsoleCommand(this, commandLine)) continue;
            return true;
        }
        this.printPrompt();
        this.printError(String.valueOf(commandLine.trim()) + " is unknown");
        this.fireOnConsoleStart();
        return false;
    }

    private void fireOnConsoleStart() {
        for (CConsoleListener l : this.listeners.keySet()) {
            l.onConsoleStart();
        }
    }

    private void fireOnConsoleStop() {
        for (CConsoleListener l : this.listeners.keySet()) {
            l.onConsoleStop();
        }
    }

    public static void main(String[] arg) {
        new Test(arg);
    }

    private static class Test
    implements CConsoleListener {
        public Test(String[] arg) {
            CConsole c = new CConsole(System.in, System.out);
            c.addCommand(new CCommandHelp());
            c.addCommand(new CCommandHistory());
            c.addCommand(new CCommandScript());
            c.addCommand(new CCommandAutoComplete());
            c.addCommand(new CCommandInfo("oli4", "-s size -l length", "bla bla bla"));
            c.addCommand(new CCommandInfo("oli5", "bla bla bla"));
            c.addCommand(new CCommandInfo("oli4445", "bla bla bla"));
            c.addCommand(new CCommandInfo("olga", "bla bla bla"));
            c.addCommand(new CCommandInfo("aaa"));
            c.addCommand(new CCommandInfo("sss", "bla bla bla"));
            c.addCommand(new CCommandInfo("ccc", "bla bla bla"));
            c.addCommand(new CCommandInfo("bbb", "prints out this help"));
            c.addCommand(new CCommandInfo("nnn", "-n name -v value", "prints out this help"));
            c.setPromptString("console>");
            c.addConsoleListener(this);
            c.start();
        }

        public boolean onConsoleCommand(CConsole console, String commandLine) {
            System.out.println("command " + commandLine + " executed");
            return !commandLine.startsWith("a");
        }

        public void onConsoleStart() {
            System.out.println("********* halloooooo *********");
            System.out.println("type h for more info!");
        }

        public void onConsoleStop() {
        }
    }
}

