/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

public class ByteFifo {
    private byte[] body;
    private int head;
    private int tail;
    private int maxSize;

    public ByteFifo() {
        this(1024);
    }

    public ByteFifo(int maxSize) {
        this.maxSize = maxSize + 1;
        this.body = new byte[this.maxSize];
        this.head = 0;
        this.tail = 0;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public synchronized void put(byte o) {
        if (!this.isNotFull()) {
            this.tail = (this.tail + 1) % this.maxSize;
        }
        this.body[this.head] = o;
        this.head = (this.head + 1) % this.maxSize;
    }

    public void put(String str) {
        byte[] b = str.getBytes();
        int i = 0;
        while (i < b.length) {
            this.put(b[i]);
            ++i;
        }
    }

    public synchronized byte get() {
        byte o = this.body[this.tail];
        this.tail = (this.tail + 1) % this.maxSize;
        return o;
    }

    public synchronized void replace(byte o, int index) {
        this.body[(this.tail + index) % this.maxSize] = o;
    }

    public float pick(int index) {
        int i = this.tail + index;
        if (i < this.getActualSize()) {
            return this.body[i];
        }
        return this.body[i - this.maxSize];
    }

    public float pickFromHead(int index) {
        int i = this.head - index;
        if (i < 0) {
            return this.body[i + this.maxSize];
        }
        return this.body[i];
    }

    public boolean isNotEmpty() {
        return this.head != this.tail;
    }

    public boolean isNotFull() {
        return (this.head + 1) % this.maxSize != this.tail;
    }

    public int getActualSize() {
        return (this.head + this.maxSize - this.tail) % this.maxSize;
    }

    public int getFreeSize() {
        return this.maxSize - 1 - this.getActualSize();
    }
}

