/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.io.InputStream;
import java.io.OutputStream;

public class LoopbackStream
implements Runnable {
    private int blockLength;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean enabled;

    public LoopbackStream(InputStream is, OutputStream os) {
        this(is, os, 1024);
    }

    public LoopbackStream(InputStream is, OutputStream os, int blockLength) {
        this.blockLength = blockLength;
        this.inputStream = is;
        this.outputStream = os;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        byte[] data = new byte[this.blockLength];
        while (true) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.enabled) continue;
            try {
                int n = Math.min(this.inputStream.available(), data.length);
                if (n <= 0) continue;
                this.inputStream.read(data, 0, n);
                this.outputStream.write(data, 0, n);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }
}

