/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia;

import ch.oli4.trace.Trace;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;

public class MAudio
implements LineListener,
Runnable {
    private String name;
    private AudioInputStream stream = null;
    private SourceDataLine line = null;
    private byte[] buffer = new byte[524288];
    private static final int STOPPED = 0;
    private static final int STARTING = 1;
    private static final int RUNNING = 2;
    private static final int STOPPING = 3;
    private volatile int state = 0;
    private volatile boolean looping;
    private volatile boolean disposed = false;
    private AudioClip audioClip;
    public static final int MODE_APPLET_AUDIOCLIP = 1;
    public static final int MODE_JAVAX_SOUND = 2;
    private static int mode = 1;

    public MAudio(String name) {
        Trace.getInstance().addEntry(3, "create MAudio " + name);
        this.name = name;
        try {
            switch (mode) {
                case 1: {
                    break;
                }
                case 2: {
                    Thread t = new Thread(this);
                    t.setPriority(10);
                    t.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.stop();
        this.disposed = true;
    }

    public static void setAudioMode(int m) {
        Trace.getInstance().addEntry(3, "MAudio.setAudioMode() " + m);
        mode = m;
    }

    public void play() {
        Trace.getInstance().addEntry(3, "MAudio.play() " + this.name);
        int retry = 3;
        while (retry-- > 0) {
            try {
                switch (mode) {
                    case 1: {
                        if (this.audioClip != null) {
                            this.audioClip.stop();
                        } else {
                            this.audioClip = Applet.newAudioClip(new URL(String.valueOf(MAudio.getBasePath()) + this.name));
                        }
                        this.audioClip.play();
                        break;
                    }
                    case 2: {
                        this.stream = AudioSystem.getAudioInputStream(new File(this.name));
                        this.line = AudioSystem.getSourceDataLine(this.stream.getFormat());
                        this.line.open();
                        this.line.start();
                        this.looping = false;
                        this.state = 2;
                    }
                }
                retry = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("run play retry " + this.name);
            }
        }
    }

    public void loop() {
        Trace.getInstance().addEntry(3, "MAudio.loop() " + this.name);
        int retry = 3;
        while (retry-- > 0) {
            try {
                switch (mode) {
                    case 1: {
                        if (this.audioClip != null) {
                            this.audioClip.stop();
                        } else {
                            this.audioClip = Applet.newAudioClip(new URL(String.valueOf(MAudio.getBasePath()) + this.name));
                        }
                        this.audioClip.loop();
                        break;
                    }
                    case 2: {
                        this.stream = AudioSystem.getAudioInputStream(new File(this.name));
                        this.line = AudioSystem.getSourceDataLine(this.stream.getFormat());
                        this.line.open();
                        this.line.start();
                        FloatControl c = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                        c.setValue(-45.0f);
                        this.looping = true;
                        this.state = 1;
                        new Thread(new Runnable(){

                            public void run() {
                                try {
                                    FloatControl c = (FloatControl)MAudio.this.line.getControl(FloatControl.Type.MASTER_GAIN);
                                    int i = 0;
                                    while (i < 45) {
                                        c.setValue(i - 44);
                                        Thread.sleep(11L);
                                        if (MAudio.this.state != 1) {
                                            return;
                                        }
                                        ++i;
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }).start();
                    }
                }
                retry = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("run loop retry " + this.name);
            }
        }
    }

    public void stop() {
        Trace.getInstance().addEntry(3, "MAudio.stop() " + this.name);
        try {
            switch (mode) {
                case 1: {
                    if (this.audioClip != null) {
                        this.audioClip.stop();
                    }
                    break;
                }
                case 2: {
                    if (this.state == 0) break;
                    this.state = 3;
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                FloatControl c = (FloatControl)MAudio.this.line.getControl(FloatControl.Type.MASTER_GAIN);
                                int i = 0;
                                while (i < 450) {
                                    c.setValue((float)(-i) * 0.1f);
                                    Thread.sleep(2L);
                                    if (MAudio.this.state != 3) {
                                        return;
                                    }
                                    ++i;
                                }
                                MAudio.this.state = 0;
                                MAudio.this.line.stop();
                                MAudio.this.line.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
                default: {
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isPlayingOrLooping() {
        switch (mode) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.state) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void run() {
        while (!this.disposed) {
            try {
                switch (this.state) {
                    case 1: 
                    case 2: 
                    case 3: {
                        int rl = this.stream.read(this.buffer, 0, this.state == 3 ? 32768 : this.buffer.length);
                        if (this.looping) {
                            if (rl == -1) {
                                this.stream.close();
                                this.stream = AudioSystem.getAudioInputStream(new File(this.name));
                                rl = this.stream.read(this.buffer);
                            }
                            int wl = this.line.write(this.buffer, 0, rl);
                            break;
                        }
                        if (rl == -1) {
                            this.state = 0;
                            break;
                        }
                        int n = this.line.write(this.buffer, 0, rl);
                        break;
                    }
                    case 0: {
                        Thread.sleep(100L);
                    }
                }
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            this.stream.close();
            this.line.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(LineEvent le) {
        Trace.getInstance().addEntry(3, "LineListener.update() " + this.name + " event=" + le.toString());
    }

    private static String getBasePath() {
        return "file:" + System.getProperty("user.dir") + System.getProperty("file.separator");
    }
}

