/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia;

import ch.oli4.mmedia.MImageCache;
import ch.oli4.mmedia.MTimer;
import ch.oli4.trace.Trace;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class MPanel
extends JPanel {
    private double scaleFactor;
    private MImageCache cache;
    private int nominalW;
    private int nominalH;
    private boolean reprintNeeded = true;
    private MTimer imageTimer;
    private int imageTimeout = 2000;
    private BufferedImage bgImage;

    public MPanel(int w, int h, double scale) {
        this.nominalW = w;
        this.nominalH = h;
        int sw = (int)((double)w * scale);
        int sh = (int)((double)h * scale);
        this.setPreferredSize(new Dimension(sw, sh));
        this.scaleFactor = scale;
        this.bgImage = new BufferedImage(sw, sh, 5);
        this.imageTimer = new MTimer();
        this.cache = new MImageCache(this, 10);
    }

    public MPanel(int w, int h) {
        this(w, h, 1.0);
    }

    public Dimension getNominalSize() {
        return new Dimension(this.nominalW, this.nominalH);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(float f) {
        int sw = (int)((float)this.nominalW * f);
        int sh = (int)((float)this.nominalH * f);
        this.setPreferredSize(new Dimension(sw, sh));
        this.scaleFactor = f;
        this.bgImage = new BufferedImage(sw, sh, 5);
        this.cache.dispose();
        this.reprintNeeded = true;
    }

    public void printImage(String fileName) {
        this.printImage(fileName, 0, 0);
    }

    public void printImage(String fileName, boolean repaint) {
        this.printImage(fileName, 0, 0, this.bgImage.getGraphics(), repaint);
    }

    public void printImage(String fileName, int x, int y) {
        this.printImage(fileName, x, y, this.bgImage.getGraphics(), true);
    }

    public void printImage(String fileName, int x, int y, boolean repaint) {
        this.printImage(fileName, x, y, this.bgImage.getGraphics(), repaint);
    }

    public void printRectangle(int x1, int y1, int x2, int y2, Color color, boolean repaint) {
        Graphics2D g = (Graphics2D)this.bgImage.getGraphics();
        g.setColor(color);
        int w = x2 - x1;
        int h = y2 - y1;
        w = (int)((double)w * this.scaleFactor);
        h = (int)((double)h * this.scaleFactor);
        int x = (int)((double)x1 * this.scaleFactor);
        int y = (int)((double)y1 * this.scaleFactor);
        g.drawRect(x, y, w, h);
        this.reprintNeeded = true;
        Trace.getInstance().addEntry(7, "printRectangle() ");
    }

    private void printImage(String fileName, int x, int y, Graphics g, boolean repaint) {
        int n;
        block1: {
            ImageIcon i = this.cache.get(fileName);
            Image im = i.getImage();
            this.imageTimer.start(this.imageTimeout);
            n = 0;
            do {
                ++n;
                if (g.drawImage(im, (int)((double)x * this.scaleFactor), (int)((double)y * this.scaleFactor), null)) break block1;
                this.imageTimer.run();
            } while (!this.imageTimer.isTimeout());
            Trace.getInstance().addEntry(7, "ERROR: MPanel.printImage() timeout reached, missing " + fileName);
            this.clearScreen(Color.RED, fileName);
        }
        this.reprintNeeded = true;
        Trace.getInstance().addEntry(7, "MPanel.printImage() " + fileName + " (" + n + " tries)");
    }

    public boolean isReprintNeeded() {
        return this.reprintNeeded;
    }

    public void reprint() {
        this.reprint(false);
    }

    public void reprint(boolean intermediateReprint) {
        if (this.reprintNeeded) {
            if (!intermediateReprint) {
                this.reprintNeeded = false;
            }
            this.repaint();
            Trace.getInstance().addEntry(7, "MPanel.reprint()");
        }
    }

    public void mixImage(String fileName, int x, int y, float alpha, boolean repaint) {
        AlphaComposite ac = AlphaComposite.getInstance(3, alpha);
        Graphics2D g2d = (Graphics2D)this.bgImage.getGraphics();
        g2d.setComposite(ac);
        this.printImage(fileName, x, y, g2d, repaint);
    }

    public void fadeImage(String fileName, int fadeTime) {
        this.fadeImage(fileName, 0, 0, fadeTime);
    }

    public void fadeImage(String fileName, int x, int y, int fadeTime) {
        Trace.getInstance().addEntry(7, "MPanel.fadeImage() " + fileName);
        Graphics2D g2d = (Graphics2D)this.bgImage.getGraphics();
        int n = fadeTime / 100;
        int i = 0;
        while (i < n) {
            AlphaComposite ac = AlphaComposite.getInstance(3, (float)i / (float)n);
            g2d.setComposite(ac);
            this.printImage(fileName, x, y, g2d, true);
            this.reprint();
            MTimer.sleep(fadeTime / n);
            ++i;
        }
    }

    public void clearScreen() {
        this.clearScreen(Color.BLACK);
    }

    public void clearScreen(Color c) {
        Graphics g = this.bgImage.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, this.bgImage.getWidth(), this.bgImage.getHeight());
        this.repaint();
    }

    public void clearScreen(Color c, String text) {
        Graphics g = this.bgImage.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, this.bgImage.getWidth(), this.bgImage.getHeight());
        g.setColor(Color.BLACK);
        int x = (this.bgImage.getWidth() - g.getFontMetrics().stringWidth(text)) / 2;
        int y = this.bgImage.getHeight() / 2;
        g.drawString(text, this.bgImage.getWidth() / 2, this.bgImage.getHeight() / 2);
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        while (!g.drawImage(this.bgImage, 0, 0, null)) {
            MTimer.sleep(10);
        }
    }

    public void dispose() {
        this.cache.dispose();
    }
}

