/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia;

public class MTimer {
    private long timeout;
    private int triggerState = 3;
    private static final int WAITING = 1;
    private static final int TRIGGERED = 2;
    private static final int OFF = 3;

    public static void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start(int delay) {
        this.timeout = System.currentTimeMillis() + (long)delay;
        this.triggerState = 1;
    }

    public void run() {
        switch (this.triggerState) {
            case 1: {
                if (System.currentTimeMillis() < this.timeout) break;
                this.triggerState = 2;
                break;
            }
            case 2: {
                this.triggerState = 3;
                break;
            }
        }
    }

    public int getTimeUntilTrigger() {
        return (int)(this.timeout - System.currentTimeMillis());
    }

    public boolean isTriggered() {
        return this.triggerState == 2;
    }

    public boolean isWaiting() {
        return this.triggerState == 1;
    }

    public boolean isTimeout() {
        return !this.isWaiting();
    }

    public void stop() {
        this.triggerState = 3;
    }
}

