/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.MAnimation;
import ch.oli4.mmedia.MMouse;
import ch.oli4.mmedia.MTimer;
import ch.oli4.mmedia.game.ActiveArea;
import ch.oli4.mmedia.game.EventListener;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Game;
import ch.oli4.mmedia.game.PassiveArea;
import ch.oli4.mmedia.game.Room;
import ch.oli4.mmedia.game.Timer;
import ch.oli4.trace.Trace;
import java.util.ArrayList;

public class Perspective
extends Room
implements EventListener {
    private ArrayList<ActiveArea> mouseAreaActions = new ArrayList();
    private ArrayList<PassiveArea> mouseAreaBlockers = new ArrayList();
    private ArrayList<Timer> timerActions = new ArrayList();
    private ArrayList<MAnimation> animations = new ArrayList();

    public Perspective(String name) {
        super(name);
    }

    public final void add(Room r) {
        throw new IllegalStateException("perspectives may not own subrooms!!!");
    }

    public final void add(ActiveArea a) {
        this.mouseAreaActions.add(a);
        a.setEventListener(this);
    }

    public final void add(PassiveArea a) {
        this.mouseAreaBlockers.add(a);
    }

    public final void add(Timer a) {
        this.timerActions.add(a);
        a.setEventListener(this);
    }

    public void add(MAnimation a) {
        this.animations.add(a);
    }

    protected void onEntry() {
    }

    protected void onRun() {
    }

    public final void onEvent(EventProducer a) {
        Trace.getInstance().addEntry(1, "onEvent " + a.getName() + " " + this.getPath().toString());
        this.onEventReception(a);
    }

    public void onEventReception(EventProducer a) {
    }

    protected void onExit() {
    }

    private void processMouseAreaActions() {
        for (PassiveArea passiveArea : this.mouseAreaBlockers) {
            if (!passiveArea.run()) continue;
            MMouse.getInstance().setCursor(1);
            return;
        }
        for (ActiveArea activeArea : this.mouseAreaActions) {
            if (!activeArea.run()) continue;
            return;
        }
        MMouse.getInstance().setCursor(1);
    }

    private void printMouseAreaActions() {
        for (PassiveArea passiveArea : this.mouseAreaBlockers) {
            passiveArea.print();
        }
        for (ActiveArea activeArea : this.mouseAreaActions) {
            activeArea.print();
        }
    }

    private void processTimers() {
        for (Timer i : this.timerActions) {
            i.run();
        }
    }

    private void processAnimations() {
        for (MAnimation i : this.animations) {
            i.run();
        }
    }

    void run() {
        Trace.getInstance().addEntry(1, "onEntry " + this.getPath().toString());
        this.onEntry();
        while (Game.getInstance().getCurrentPath().equals(this.getPath())) {
            MMouse.getInstance().scan();
            this.processMouseAreaActions();
            this.processTimers();
            Trace.getInstance().addEntry(9, "onRun " + this.getPath().toString());
            this.onRun();
            this.processAnimations();
            if (Perspective.getPanel().isReprintNeeded()) {
                this.printMouseAreaActions();
            }
            Perspective.getPanel().reprint();
            MTimer.sleep(10);
        }
        Trace.getInstance().addEntry(1, "onExit " + this.getPath().toString());
        this.onExit();
        System.gc();
    }
}

