/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.AbstractArchiveDetector;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultArchiveDetector
extends AbstractArchiveDetector {
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static final Logger logger;
    private static final String SERVICE = "META-INF/services/de.schlichtherle.io.archive.spi.ArchiveDriver.properties";
    private static final Object INVALID_DRIVER;
    public static final String DEFAULT_SUFFIXES;
    public static final String ALL_SUFFIXES;
    private static final Map allDrivers;
    private final String suffixes;
    private final Matcher matcher;
    private final Map drivers = new HashMap(allDrivers);
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultArchiveDetector(String string) {
        this.suffixes = string = DefaultArchiveDetector.checkSuffixes(string, ALL_SUFFIXES, true);
        this.matcher = string != null ? DefaultArchiveDetector.matcher(string) : DefaultArchiveDetector.matcher("\\00");
    }

    public DefaultArchiveDetector(String string, ArchiveDriver archiveDriver) {
        this(NULL, string, archiveDriver);
    }

    public DefaultArchiveDetector(DefaultArchiveDetector defaultArchiveDetector, String string, ArchiveDriver archiveDriver) {
        this(defaultArchiveDetector, new Object[]{string, archiveDriver});
    }

    public DefaultArchiveDetector(DefaultArchiveDetector defaultArchiveDetector, Object[] objectArray) {
        this(defaultArchiveDetector, DefaultArchiveDetector.map(objectArray));
    }

    public DefaultArchiveDetector(DefaultArchiveDetector defaultArchiveDetector, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (defaultArchiveDetector.suffixes != null) {
            stringBuffer.append(defaultArchiveDetector.suffixes);
        }
        this.drivers.putAll(defaultArchiveDetector.drivers);
        DefaultArchiveDetector.registerArchiveDrivers(map, stringBuffer, new StringBuffer(), this.drivers);
        this.suffixes = stringBuffer.length() > 0 ? stringBuffer.toString() : null;
        this.matcher = this.suffixes != null ? DefaultArchiveDetector.matcher(this.suffixes) : DefaultArchiveDetector.matcher("\\00");
    }

    public synchronized ArchiveDriver getArchiveDriver(String string) {
        this.matcher.reset(string);
        if (!this.matcher.matches()) {
            return null;
        }
        return this.lookupArchiveDriver(this.matcher.group(1));
    }

    private ArchiveDriver lookupArchiveDriver(String string) {
        Object object = this.drivers.get(string = string.toLowerCase());
        if (object instanceof ArchiveDriver) {
            return (ArchiveDriver)object;
        }
        if (object == INVALID_DRIVER || object == null) {
            return null;
        }
        try {
            if (object instanceof String) {
                object = Thread.currentThread().getContextClassLoader().loadClass((String)object);
                logger.log(Level.FINE, "driverLoaded", new Object[]{string, object});
            }
            if (object instanceof Class) {
                object = (ArchiveDriver)((Class)object).newInstance();
                this.drivers.put(string, object);
                logger.log(Level.FINE, "driverInstantiated", new Object[]{string, object});
                return (ArchiveDriver)object;
            }
        }
        catch (Exception exception) {
            this.drivers.put(string, INVALID_DRIVER);
            String string2 = MessageFormat.format(resources.getString("driverInstallationFailed"), string, object);
            logger.log(Level.WARNING, string2, exception);
        }
        return null;
    }

    private static Map map(Object[] objectArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            hashMap.put(objectArray[i], objectArray[i + 1]);
        }
        return hashMap;
    }

    public String getSuffixes() {
        return this.suffixes;
    }

    private static void registerArchiveDrivers(StringBuffer stringBuffer, StringBuffer stringBuffer2, Map map, StringBuffer stringBuffer3, Map map2) {
        Enumeration<URL> enumeration;
        try {
            enumeration = Thread.currentThread().getContextClassLoader().getResources(SERVICE);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "resourceLookupFailed", SERVICE);
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            DefaultArchiveDetector.registerArchiveDrivers(uRL, stringBuffer, stringBuffer2, map, stringBuffer3, map2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerArchiveDrivers(URL uRL, StringBuffer stringBuffer, StringBuffer stringBuffer2, Map map, StringBuffer stringBuffer3, Map map2) {
        logger.log(Level.CONFIG, "processingConfiguration", uRL);
        Properties properties = new Properties();
        try {
            InputStream inputStream = uRL.openStream();
            try {
                properties.load(inputStream);
                DefaultArchiveDetector.registerArchiveDrivers(properties, stringBuffer, stringBuffer2, map, stringBuffer3, map2);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "processingConfigurationFailed", iOException);
        }
    }

    private static void registerArchiveDrivers(Map map, StringBuffer stringBuffer, StringBuffer stringBuffer2, Map map2, StringBuffer stringBuffer3, Map map3) {
        String string = (String)map.get("DRIVER");
        boolean bl = Boolean.TRUE.equals(Boolean.valueOf(string));
        if (bl) {
            DefaultArchiveDetector.registerArchiveDrivers(map, stringBuffer, stringBuffer2, map2);
        } else {
            DefaultArchiveDetector.registerArchiveDrivers(map, stringBuffer, stringBuffer3, map3);
        }
    }

    private static void registerArchiveDrivers(Map map, StringBuffer stringBuffer, StringBuffer stringBuffer2, Map map2) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && map2 == null) {
            throw new AssertionError();
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if ("DRIVER".equals(string)) continue;
            if ("DEFAULT".equals(string)) {
                DefaultArchiveDetector.addSuffixes(stringBuffer2, (String)v);
                continue;
            }
            DefaultArchiveDetector.registerArchiveDriver(stringBuffer, map2, string, v);
        }
    }

    private static void registerArchiveDriver(StringBuffer stringBuffer, Map map, String string, Object object) {
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        NormalizedSuffixEnumeration normalizedSuffixEnumeration = new NormalizedSuffixEnumeration(string);
        while (normalizedSuffixEnumeration.hasMoreElements()) {
            String string2 = (String)normalizedSuffixEnumeration.nextElement();
            map.put(string2.toLowerCase(), object);
            if (string2.matches(stringBuffer.toString().replaceAll("\\.", "\\\\\\."))) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(string2);
        }
    }

    private static void addSuffixes(StringBuffer stringBuffer, String string) {
        if (string == null) {
            return;
        }
        NormalizedSuffixEnumeration normalizedSuffixEnumeration = new NormalizedSuffixEnumeration(string);
        while (normalizedSuffixEnumeration.hasMoreElements()) {
            String string2 = (String)normalizedSuffixEnumeration.nextElement();
            if (string2.matches(stringBuffer.toString().replaceAll("\\.", "\\\\\\."))) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(string2);
        }
    }

    private static String evaluateSuffixes(String string, String string2) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if ("NULL".equals(string)) {
            return null;
        }
        if ("ALL".equals(string)) {
            return string2;
        }
        return DefaultArchiveDetector.checkSuffixes(string, string2, false);
    }

    private static String checkSuffixes(String string, String string2, boolean bl) throws IllegalArgumentException {
        if (string == null || string2 == null) {
            return null;
        }
        Matcher matcher = DefaultArchiveDetector.matcher(string2);
        StringBuffer stringBuffer = new StringBuffer();
        NormalizedSuffixEnumeration normalizedSuffixEnumeration = new NormalizedSuffixEnumeration(string);
        while (normalizedSuffixEnumeration.hasMoreElements()) {
            String string3 = (String)normalizedSuffixEnumeration.nextElement();
            matcher.reset("foo." + string3);
            if (matcher.matches()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('|');
                }
                stringBuffer.append(string3);
                continue;
            }
            if (bl) {
                throw new IllegalArgumentException(string3);
            }
            logger.log(Level.WARNING, "unknownSuffix", string3);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private static Matcher matcher(String string) {
        return Pattern.compile(DefaultArchiveDetector.pattern(string), 66).matcher("");
    }

    private static String pattern(String string) {
        StringBuffer stringBuffer = new StringBuffer(".*\\.(");
        int n = 0;
        NormalizedSuffixEnumeration normalizedSuffixEnumeration = new NormalizedSuffixEnumeration(string);
        while (normalizedSuffixEnumeration.hasMoreElements()) {
            String string2 = (String)normalizedSuffixEnumeration.nextElement();
            if (n > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append("\\Q");
            stringBuffer.append(string2);
            stringBuffer.append("\\E");
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static {
        Object object;
        $assertionsDisabled = !DefaultArchiveDetector.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/DefaultArchiveDetector".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
        INVALID_DRIVER = new Object();
        logger.config("banner");
        HashMap hashMap = new HashMap();
        StringBuffer stringBuffer = new StringBuffer();
        HashMap hashMap2 = new HashMap();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        DefaultArchiveDetector.registerArchiveDrivers(stringBuffer3, stringBuffer, hashMap, stringBuffer2, hashMap2);
        hashMap.putAll(hashMap2);
        allDrivers = hashMap;
        Iterator iterator = allDrivers.entrySet().iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                object = iterator.next();
                logger.log(Level.CONFIG, "driverConfigured", new Object[]{object.getKey(), object.getValue()});
            }
        } else {
            logger.warning("noDriversConfigured");
        }
        ALL_SUFFIXES = stringBuffer3.length() > 0 ? stringBuffer3.toString() : null;
        object = null;
        if (stringBuffer2.length() > 0) {
            object = DefaultArchiveDetector.evaluateSuffixes(stringBuffer2.toString(), ALL_SUFFIXES);
        } else if (stringBuffer.length() > 0) {
            object = DefaultArchiveDetector.evaluateSuffixes(stringBuffer.toString(), ALL_SUFFIXES);
        }
        DEFAULT_SUFFIXES = object;
        logger.log(Level.CONFIG, "allSuffixes", ALL_SUFFIXES);
        logger.log(Level.CONFIG, "defaultSuffixes", DEFAULT_SUFFIXES);
    }

    private static class NormalizedSuffixEnumeration
    implements Enumeration {
        final String[] split;
        int i = 0;

        private NormalizedSuffixEnumeration(String string) {
            this.split = string.split("\\|");
        }

        public boolean hasMoreElements() {
            int n = this.split.length;
            while (this.i < n) {
                String string = this.split[this.i].replaceAll("\\\\\\.", "\\.");
                if (string.length() > 0 && string.charAt(0) == '.') {
                    string = string.substring(1);
                }
                if (string.length() > 0) {
                    this.split[this.i] = string;
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        public Object nextElement() {
            return this.split[this.i++];
        }
    }
}

