/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveStatistics;
import de.schlichtherle.io.FileConstants;
import de.schlichtherle.io.FileFactory;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.util.Path;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;

public class File
extends java.io.File
implements FileConstants,
Cloneable {
    private static boolean lenient;
    private static ArchiveDetector defaultArchiveDetector;
    private final java.io.File delegate;
    private final ArchiveDetector archiveDetector;
    private File innerArchive;
    private String innerEntryName;
    private File enclArchive;
    private String enclEntryName;
    ArchiveController archiveController;
    private static final HashSet roots;
    private static final String uncPrefix;
    private static final List buffersList;
    static final /* synthetic */ boolean $assertionsDisabled;

    static java.io.File normalize(java.io.File file) {
        String string = file.getPath();
        String string2 = Path.normalize(string, separatorChar);
        if (string2 != string) {
            return new java.io.File(string2);
        }
        return file;
    }

    public static final void update() throws ArchiveException {
        ArchiveController.updateAll("", false, true, false, true, false, true);
    }

    public static final void update(boolean bl) throws ArchiveException {
        ArchiveController.updateAll("", false, bl, false, bl, false, true);
    }

    public static final void update(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ArchiveException {
        ArchiveController.updateAll("", bl, bl2, bl3, bl4, false, true);
    }

    public static final void update(File file) throws ArchiveException {
        File.update(file, false, true, false, true);
    }

    public static final void update(File file, boolean bl) throws ArchiveException {
        File.update(file, false, bl, false, bl);
    }

    public static final void update(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ArchiveException {
        if (!file.isArchive()) {
            throw new IllegalArgumentException(file.getPath() + " (not an archive)");
        }
        if (file.getEnclArchive() != null) {
            throw new IllegalArgumentException(file.getPath() + " (not a top level archive)");
        }
        ArchiveController.updateAll(file.getCanOrAbsPath(), bl, bl2, bl3, bl4, false, true);
    }

    public static final void umount() throws ArchiveException {
        ArchiveController.updateAll("", false, true, false, true, true, true);
    }

    public static final void umount(boolean bl) throws ArchiveException {
        ArchiveController.updateAll("", false, bl, false, bl, true, true);
    }

    public static final void umount(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ArchiveException {
        ArchiveController.updateAll("", bl, bl2, bl3, bl4, true, true);
    }

    public static final void umount(File file) throws ArchiveException {
        File.umount(file, false, true, false, true);
    }

    public static final void umount(File file, boolean bl) throws ArchiveException {
        File.umount(file, false, bl, false, bl);
    }

    public static final void umount(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ArchiveException {
        if (!file.isArchive()) {
            throw new IllegalArgumentException(file.getPath() + " (not an archive)");
        }
        if (file.getEnclArchive() != null) {
            throw new IllegalArgumentException(file.getPath() + " (not a top level archive)");
        }
        ArchiveController.updateAll(file.getCanOrAbsPath(), bl, bl2, bl3, bl4, true, true);
    }

    public static final ArchiveStatistics getLiveArchiveStatistics() {
        return ArchiveController.getLiveStatistics();
    }

    public static final boolean isLenient() {
        return lenient;
    }

    public static final void setLenient(boolean bl) {
        lenient = bl;
    }

    public static final ArchiveDetector getDefaultArchiveDetector() {
        return defaultArchiveDetector;
    }

    public static final void setDefaultArchiveDetector(ArchiveDetector archiveDetector) {
        if (archiveDetector == null) {
            throw new NullPointerException();
        }
        defaultArchiveDetector = archiveDetector;
    }

    public File(java.io.File file) {
        this(file, defaultArchiveDetector);
    }

    public File(java.io.File file, ArchiveDetector archiveDetector) {
        super(file.getPath());
        if (file instanceof File) {
            File file2 = (File)file;
            this.delegate = file2.delegate;
            this.archiveDetector = file2.archiveDetector;
            this.enclArchive = file2.enclArchive;
            this.enclEntryName = file2.enclEntryName;
            this.innerArchive = file2.isArchive() ? this : file2.innerArchive;
            this.innerEntryName = file2.innerEntryName;
            this.archiveController = file2.archiveController;
        } else {
            this.delegate = file;
            this.archiveDetector = archiveDetector;
            this.init((File)null);
        }
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    public File(String string) {
        this(string, defaultArchiveDetector);
    }

    public File(String string, ArchiveDetector archiveDetector) {
        super(string);
        this.delegate = new java.io.File(string);
        this.archiveDetector = archiveDetector;
        this.init((File)null);
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    public File(String string, String string2) {
        this(string, string2, defaultArchiveDetector);
    }

    public File(String string, String string2, ArchiveDetector archiveDetector) {
        super(string, string2);
        this.delegate = new java.io.File(string, string2);
        this.archiveDetector = archiveDetector;
        this.init((File)null);
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    public File(java.io.File file, String string) {
        this(file, string, null);
    }

    public File(java.io.File file, String string, ArchiveDetector archiveDetector) {
        super(file, string);
        this.delegate = new java.io.File(file, string);
        if (file instanceof File && string.length() > 0) {
            File file2 = (File)file;
            this.archiveDetector = archiveDetector != null ? archiveDetector : file2.archiveDetector;
            this.init((File)file);
        } else {
            this.archiveDetector = archiveDetector != null ? archiveDetector : defaultArchiveDetector;
            this.init((File)null);
        }
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    public File(URI uRI) {
        this(uRI, (ArchiveDetector)ArchiveDetector.ALL);
    }

    private File(URI uRI, ArchiveDetector archiveDetector) {
        super(File.unjarFileURI(uRI));
        this.delegate = new java.io.File(super.getPath());
        this.archiveDetector = archiveDetector;
        this.init(uRI);
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    private static final URI unjarFileURI(URI uRI) {
        try {
            String string = uRI.getScheme();
            String string2 = Path.normalize(uRI.getSchemeSpecificPart(), '/');
            return File.unjarFileURIImpl(new URI(string, string2, null));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRI + ": Not a valid (possibly jared) file URI!");
        }
    }

    private static final URI unjarFileURIImpl(URI uRI) throws URISyntaxException {
        String string = uRI.getScheme();
        if ("jar".equalsIgnoreCase(string)) {
            String string2 = uRI.getRawSchemeSpecificPart();
            int n = string2.endsWith("!") ? string2.length() - 1 : string2.lastIndexOf("!/");
            if (n <= 0) {
                return File.unjarFileURI(new URI(string2));
            }
            URI uRI2 = new URI(string2.substring(0, n) + string2.substring(n + 1));
            String string3 = uRI2.getScheme();
            if ("jar".equalsIgnoreCase(string3)) {
                URI uRI3 = File.unjarFileURIImpl(uRI2);
                if (uRI3 != uRI2) {
                    return uRI3;
                }
            } else if ("file".equalsIgnoreCase(string3)) {
                return uRI2;
            }
        } else if ("file".equalsIgnoreCase(string)) {
            return uRI;
        }
        throw new URISyntaxException(uRI.toString(), "Not a valid (possibly jared) file URI!");
    }

    public File(java.io.File file, File file2, ArchiveDetector archiveDetector) {
        super(file.getPath());
        if (!$assertionsDisabled && !File.assertParams(file, file2, archiveDetector)) {
            throw new AssertionError();
        }
        this.delegate = file;
        String string = file.getPath();
        if (file2 != null) {
            int n = file2.getPath().length();
            if (string.length() == n) {
                this.archiveDetector = file2.archiveDetector;
                this.innerArchive = this;
                this.innerEntryName = "";
                this.enclArchive = file2.enclArchive;
                this.enclEntryName = file2.enclEntryName;
                this.archiveController = ArchiveController.getInstance(this);
            } else {
                this.archiveDetector = archiveDetector;
                this.innerArchive = this.enclArchive = file2;
                this.innerEntryName = this.enclEntryName = string.substring(n + 1).replace(separatorChar, '/');
            }
        } else {
            this.archiveDetector = archiveDetector;
        }
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    private static final boolean assertParams(java.io.File file, File file2, ArchiveDetector archiveDetector) throws AssertionError {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"delegate is null!");
        }
        if (!$assertionsDisabled && file instanceof File) {
            throw new AssertionError((Object)"delegate must not be a de.schlichtherle.io.File!");
        }
        if (file2 != null) {
            if (!$assertionsDisabled && !file2.isArchive()) {
                throw new AssertionError((Object)"innerArchive must be an archive!");
            }
            if (!$assertionsDisabled && !File.containsImpl(file2, file)) {
                throw new AssertionError((Object)"innerArchive must contain delegate!");
            }
        }
        if (!$assertionsDisabled && archiveDetector == null) {
            throw new AssertionError((Object)"archiveDetector is null!");
        }
        return true;
    }

    public File(File file, java.io.File file2, File file3) {
        super(file2.getPath());
        if (!$assertionsDisabled && !File.assertParams(file, file2, file3)) {
            throw new AssertionError();
        }
        this.delegate = file2;
        this.archiveDetector = file.archiveDetector;
        this.enclArchive = file3;
        this.enclEntryName = file.enclEntryName;
        this.innerArchive = file.isArchive() ? this : file3;
        this.innerEntryName = file.innerEntryName;
        this.archiveController = file.archiveController;
        if (!$assertionsDisabled && !this.assertInvariants(file.archiveController != null)) {
            throw new AssertionError();
        }
    }

    private static final boolean assertParams(File file, java.io.File file2, File file3) throws AssertionError {
        if (!$assertionsDisabled && file2 == null) {
            throw new AssertionError((Object)"delegate is null!");
        }
        if (!$assertionsDisabled && file2 instanceof File) {
            throw new AssertionError((Object)"delegate must not be a de.schlichtherle.io.File!");
        }
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"blueprint is null!");
        }
        String string = file2.getPath();
        java.io.File file4 = File.normalize(file);
        String string2 = file4.getPath();
        String string3 = file4.getName();
        if (separatorChar != '/') {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
            string3 = string3.toLowerCase();
        }
        if (!(".".equals(string3) || "..".equals(string3) || string2.startsWith("." + separator) || string2.startsWith(".." + separator))) {
            if (!$assertionsDisabled && !string.endsWith(string2)) {
                throw new AssertionError((Object)"delegate and blueprint must identify the same directory!");
            }
            if (file3 != null) {
                if (!$assertionsDisabled && !file3.isArchive()) {
                    throw new AssertionError((Object)"enclArchive must be an archive file!");
                }
                if (!$assertionsDisabled && !File.containsImpl(file3, file2.getParentFile())) {
                    throw new AssertionError((Object)"enclArchive must be an ancestor of delegate!");
                }
            }
        }
        return true;
    }

    private void init(File file) {
        if (!$assertionsDisabled && file != null && !super.getPath().startsWith(file.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.archiveDetector == null) {
            throw new AssertionError();
        }
        this.init(file, this.archiveDetector, 0, super.getPath());
        if (this.innerArchive == this) {
            this.archiveController = ArchiveController.getInstance(this);
        }
    }

    private void init(File file, ArchiveDetector archiveDetector, int n, String string) {
        if (string == null) {
            if (!$assertionsDisabled && this.enclArchive != null) {
                throw new AssertionError();
            }
            this.enclEntryName = null;
            return;
        }
        String[] stringArray = Path.split(string, separatorChar);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string3.length() != 0 && !".".equals(string3)) {
            if ("..".equals(string3)) {
                ++n;
            } else if (n > 0) {
                --n;
            } else {
                int n2;
                if (file != null) {
                    int n3;
                    n2 = string.length();
                    if (n2 == (n3 = file.getPath().length())) {
                        if (!$assertionsDisabled && this.enclEntryName == null) {
                            throw new AssertionError();
                        }
                        this.enclArchive = file.innerArchive;
                        if (!file.isArchive()) {
                            this.enclEntryName = file.isEntry() ? file.enclEntryName + "/" + this.enclEntryName : null;
                        }
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                            this.innerEntryName = this.enclEntryName;
                        }
                        return;
                    }
                    if (n2 < n3) {
                        archiveDetector = file.archiveDetector;
                        file = file.enclArchive;
                    }
                }
                int n4 = n2 = archiveDetector.getArchiveDriver(string) != null ? 1 : 0;
                if (this.enclEntryName != null) {
                    if (n2 != 0) {
                        this.enclArchive = archiveDetector.createFile(string);
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                            this.innerEntryName = this.enclEntryName;
                        }
                        return;
                    }
                    this.enclEntryName = string3 + "/" + this.enclEntryName;
                } else {
                    if (n2 != 0) {
                        this.innerArchive = this;
                        this.innerEntryName = "";
                    }
                    this.enclEntryName = string3;
                }
            }
        }
        this.init(file, archiveDetector, n, string2);
    }

    private void init(URI uRI) {
        if (!$assertionsDisabled && uRI == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.archiveDetector == null) {
            throw new AssertionError();
        }
        this.init(uRI, 0, Path.cutTrailingSeparator(uRI.getSchemeSpecificPart(), '/'));
        if (this.innerArchive == this) {
            this.archiveController = ArchiveController.getInstance(this);
        }
    }

    private void init(URI uRI, int n, String string) {
        String string2 = uRI.getScheme();
        if (string == null || !"jar".equalsIgnoreCase(string2)) {
            if (!$assertionsDisabled && this.enclArchive != null) {
                throw new AssertionError();
            }
            this.enclEntryName = null;
            return;
        }
        String[] stringArray = Path.split(string, '/');
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (string4.length() != 0 && !".".equals(string4)) {
            if ("..".equals(string4)) {
                ++n;
            } else if (n > 0) {
                --n;
            } else {
                boolean bl;
                int n2 = string4.length() - 1;
                boolean bl2 = bl = string4.charAt(n2) == '!';
                if (this.enclEntryName != null) {
                    if (bl) {
                        this.enclArchive = this.archiveDetector.createFile(this.createURI(string2, string));
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                            this.innerEntryName = this.enclEntryName;
                        }
                        return;
                    }
                    this.enclEntryName = string4 + "/" + this.enclEntryName;
                } else if (bl) {
                    this.innerArchive = this;
                    this.innerEntryName = "";
                    int n3 = string3.indexOf(58);
                    if (!$assertionsDisabled && n3 < 0) {
                        throw new AssertionError();
                    }
                    string2 = string3.substring(0, n3);
                    if (!$assertionsDisabled && !string2.matches("[a-zA-Z]+")) {
                        throw new AssertionError();
                    }
                    if (n3 == string3.length() - 1) {
                        return;
                    }
                    uRI = this.createURI(string3.substring(0, n3), string3.substring(n3 + 1));
                    this.enclEntryName = string4.substring(0, n2);
                    string3 = uRI.getSchemeSpecificPart();
                } else {
                    this.enclEntryName = string4;
                }
            }
        }
        this.init(uRI, n, string3);
    }

    private URI createURI(String string, String string2) throws IllegalArgumentException {
        try {
            return new URI(string, string2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(uRISyntaxException.toString());
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    private boolean assertInvariants(boolean bl) throws AssertionError {
        if (!$assertionsDisabled && this.delegate == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.delegate instanceof File) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.archiveDetector == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.innerArchive != null != (this.innerEntryName != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.enclArchive != null != (this.enclEntryName != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((this.innerArchive == this && this.innerArchive != this.enclArchive && this.innerEntryName == "" && this.innerEntryName != this.enclEntryName && (bl ? this.archiveController != null : this.archiveController == null)) ^ (this.innerArchive == this.enclArchive && this.innerEntryName == this.enclEntryName && this.archiveController == null))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.enclArchive != null && (!File.containsImpl(this.enclArchive, this.delegate.getParentFile()) || this.enclEntryName.length() <= 0 || separatorChar != '/' && this.enclEntryName.indexOf(separatorChar) != -1)) {
            throw new AssertionError();
        }
        return true;
    }

    public Object clone() {
        return this.archiveDetector.createFile(this);
    }

    public java.io.File getParentFile() {
        java.io.File file = this.delegate.getParentFile();
        if (file == null) {
            return null;
        }
        if (!$assertionsDisabled && !super.getName().equals(this.delegate.getName())) {
            throw new AssertionError();
        }
        if (this.enclArchive != null && this.enclArchive.getPath().length() == file.getPath().length()) {
            if (!$assertionsDisabled && !this.enclArchive.getPath().equals(file.getPath())) {
                throw new AssertionError();
            }
            return this.enclArchive;
        }
        return this.archiveDetector.createFile(file, this.enclArchive);
    }

    public File getNonArchivedParentFile() {
        File file = this.enclArchive;
        return file != null ? file.getNonArchivedParentFile() : (File)this.getParentFile();
    }

    public java.io.File getAbsoluteFile() {
        File file = this.enclArchive;
        if (file != null) {
            file = (File)file.getAbsoluteFile();
        }
        return this.archiveDetector.createFile(this, this.delegate.getAbsoluteFile(), file);
    }

    public File getNormalizedAbsoluteFile() {
        File file = this.enclArchive;
        if (file != null) {
            file = file.getNormalizedAbsoluteFile();
        }
        return this.archiveDetector.createFile(this, File.normalize(this.delegate.getAbsoluteFile()), file);
    }

    public String getNormalizedAbsolutePath() {
        return Path.normalize(this.getAbsolutePath(), separatorChar);
    }

    public File getNormalizedFile() {
        java.io.File file = File.normalize(this);
        if (file == this) {
            return this;
        }
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && file instanceof File) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && File.normalize(this.enclArchive) != this.enclArchive) {
            throw new AssertionError();
        }
        return this.archiveDetector.createFile(this, file, this.enclArchive);
    }

    public String getNormalizedPath() {
        return Path.normalize(this.getPath(), separatorChar);
    }

    public java.io.File getCanonicalFile() throws IOException {
        File file = this.enclArchive;
        if (file != null) {
            file = (File)file.getCanonicalFile();
        }
        return this.archiveDetector.createFile(this, this.delegate.getCanonicalFile(), file);
    }

    public final File getCanOrAbsFile() {
        File file = this.enclArchive;
        if (file != null) {
            file = file.getCanOrAbsFile();
        }
        return this.archiveDetector.createFile(this, File.getCanOrAbsFile(this.delegate), file);
    }

    private static java.io.File getCanOrAbsFile(java.io.File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            java.io.File file2 = file.getParentFile();
            return File.normalize(file2 != null ? new java.io.File(File.getCanOrAbsFile(file2), file.getName()) : file.getAbsoluteFile());
        }
    }

    public String getCanOrAbsPath() {
        return this.getCanOrAbsFile().getPath();
    }

    public final boolean isArchive() {
        return this.innerArchive == this;
    }

    public final boolean isEntry() {
        return this.enclEntryName != null;
    }

    public final File getInnerArchive() {
        return this.innerArchive;
    }

    public final String getInnerEntryName() {
        return this.innerEntryName;
    }

    public final File getEnclArchive() {
        return this.enclArchive;
    }

    public final String getEnclEntryName() {
        return this.enclEntryName;
    }

    public final ArchiveDetector getArchiveDetector() {
        return this.archiveDetector;
    }

    public final java.io.File getDelegate() {
        return this.delegate;
    }

    final ArchiveController getArchiveController() {
        return this.archiveController;
    }

    public boolean isParentOf(java.io.File file) {
        File file2 = this.getCanOrAbsFile();
        try {
            return File.containsImpl(file2, file.getCanonicalFile().getParentFile());
        }
        catch (IOException iOException) {
            return File.containsImpl(file2, File.normalize(file.getAbsoluteFile()).getParentFile());
        }
    }

    public boolean contains(java.io.File file) {
        return File.contains(this, file);
    }

    public static boolean contains(java.io.File file, java.io.File file2) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = File.normalize(file.getAbsoluteFile());
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            file2 = File.normalize(file2.getAbsoluteFile());
        }
        return File.containsImpl(file, file2);
    }

    private static boolean containsImpl(java.io.File file, java.io.File file2) {
        int n;
        if (file2 == null) {
            return false;
        }
        String string = file.getPath();
        String string2 = file2.getPath();
        if (separatorChar != '/') {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        int n2 = string.length();
        if (n2 == (n = string2.length())) {
            return true;
        }
        if (n2 < n) {
            return string2.charAt(n2) == separatorChar;
        }
        return false;
    }

    public boolean isFileSystemRoot() {
        File file = this.getCanOrAbsFile();
        return roots.contains(file) || File.isUNC(file.getPath());
    }

    public boolean isUNC() {
        return File.isUNC(this.getCanOrAbsFile().getPath());
    }

    protected static final boolean isUNC(String string) {
        return string.startsWith(uncPrefix) && string.indexOf(separatorChar, 2) > 2;
    }

    public int hashCode() {
        File file = this.enclArchive;
        if (file != null) {
            return file.hashCode() + this.enclEntryName.hashCode();
        }
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof File) {
            return this.compareTo((File)object) == 0;
        }
        return super.equals(object);
    }

    public int compareTo(java.io.File file) {
        File file2;
        if (this == file) {
            return 0;
        }
        if (!(file instanceof File)) {
            return super.compareTo(file);
        }
        File file3 = (File)file;
        File file4 = this.enclArchive;
        if (file4 != null && (file2 = file3.enclArchive) != null) {
            int n = file4.compareTo(file2);
            if (n == 0) {
                n = this.enclEntryName.compareTo(file3.enclEntryName);
            }
            return n;
        }
        return super.compareTo(file);
    }

    public File getTopLevelArchive() {
        File file = this.enclArchive;
        return file != null ? file.getTopLevelArchive() : this.innerArchive;
    }

    public String getAbsolutePath() {
        return this.delegate.getAbsolutePath();
    }

    public String getCanonicalPath() throws IOException {
        return this.delegate.getCanonicalPath();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getParent() {
        return this.delegate.getParent();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    public boolean isHidden() {
        return this.delegate.isHidden();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public URI toURI() {
        return this.delegate.toURI();
    }

    public URL toURL() throws MalformedURLException {
        return this.delegate.toURL();
    }

    public boolean exists() {
        if (this.enclArchive == null) {
            return this.delegate.exists();
        }
        return this.exists(this.enclArchive.getArchiveController(), this.enclEntryName);
    }

    private boolean exists(ArchiveController archiveController, String string) {
        try {
            return archiveController.exists(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.exists(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.exists();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isFile() {
        if (this.innerArchive == null) {
            return this.delegate.isFile();
        }
        return this.isFile(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private boolean isFile(ArchiveController archiveController, String string) {
        try {
            return archiveController.isFile(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            if (this.isArchive() && falsePositiveEntryException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.isFile(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            if (this.isArchive() && falsePositiveNativeException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.delegate.isFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isDirectory() {
        if (this.innerArchive == null) {
            return this.delegate.isDirectory();
        }
        return this.isDirectory(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private boolean isDirectory(ArchiveController archiveController, String string) {
        try {
            return archiveController.isDirectory(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.isDirectory(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.isDirectory();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Icon getOpenIcon() {
        if (this.innerArchive == null) {
            return null;
        }
        return this.getOpenIcon(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private Icon getOpenIcon(ArchiveController archiveController, String string) {
        try {
            return archiveController.getOpenIcon(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.getOpenIcon(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Icon getClosedIcon() {
        if (this.innerArchive == null) {
            return null;
        }
        return this.getClosedIcon(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private Icon getClosedIcon(ArchiveController archiveController, String string) {
        try {
            return archiveController.getClosedIcon(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.getOpenIcon(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean canRead() {
        if (this.innerArchive == null) {
            return this.delegate.canRead();
        }
        return this.canRead(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private boolean canRead(ArchiveController archiveController, String string) {
        try {
            return archiveController.canRead(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.canRead(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.canRead();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean canWrite() {
        if (this.innerArchive == null) {
            return this.delegate.canWrite();
        }
        return this.canWrite(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private boolean canWrite(ArchiveController archiveController, String string) {
        try {
            return archiveController.canWrite(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.canWrite(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.canWrite();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean setReadOnly() {
        if (this.innerArchive == null) {
            return this.delegate.setReadOnly();
        }
        return this.setReadOnly(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private boolean setReadOnly(ArchiveController archiveController, String string) {
        try {
            return archiveController.setReadOnly(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.setReadOnly(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.setReadOnly();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public long length() {
        if (this.innerArchive == null) {
            return this.delegate.length();
        }
        return this.length(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private long length(ArchiveController archiveController, String string) {
        try {
            return archiveController.length(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.length(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public long lastModified() {
        if (this.innerArchive == null) {
            return this.delegate.lastModified();
        }
        return this.lastModified(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private long lastModified(ArchiveController archiveController, String string) {
        try {
            return archiveController.lastModified(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.lastModified(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.lastModified();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public boolean setLastModified(long l) {
        if (this.innerArchive == null) {
            return this.delegate.setLastModified(l);
        }
        return this.setLastModified(this.innerArchive.getArchiveController(), this.innerEntryName, l);
    }

    private boolean setLastModified(ArchiveController archiveController, String string, long l) {
        try {
            return archiveController.setLastModified(string, l);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.setLastModified(archiveController.getEnclController(), archiveController.enclEntryName(string), l);
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.setLastModified(l);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String[] list() {
        if (this.innerArchive == null) {
            return this.delegate.list();
        }
        return this.list(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private String[] list(ArchiveController archiveController, String string) {
        try {
            return archiveController.list(string);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.list(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.list();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String[] list(FilenameFilter filenameFilter) {
        if (this.innerArchive == null) {
            return this.delegate.list(filenameFilter);
        }
        return this.list(this.innerArchive.getArchiveController(), this.innerEntryName, filenameFilter);
    }

    private String[] list(ArchiveController archiveController, String string, FilenameFilter filenameFilter) {
        try {
            return archiveController.list(string, filenameFilter, this);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.list(archiveController.getEnclController(), archiveController.enclEntryName(string), filenameFilter);
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.list(filenameFilter);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public java.io.File[] listFiles() {
        return this.listFiles((FilenameFilter)null, (FileFactory)this.archiveDetector);
    }

    public java.io.File[] listFiles(FileFactory fileFactory) {
        return this.listFiles((FilenameFilter)null, fileFactory);
    }

    public java.io.File[] listFiles(FilenameFilter filenameFilter) {
        return this.listFiles(filenameFilter, (FileFactory)this.archiveDetector);
    }

    public java.io.File[] listFiles(FilenameFilter filenameFilter, FileFactory fileFactory) {
        if (this.innerArchive == null) {
            return File.plain2smartFiles(this.delegate.listFiles(filenameFilter), fileFactory);
        }
        return this.listFiles(this.innerArchive.getArchiveController(), this.innerEntryName, filenameFilter, fileFactory);
    }

    private java.io.File[] listFiles(ArchiveController archiveController, String string, FilenameFilter filenameFilter, FileFactory fileFactory) {
        try {
            return archiveController.listFiles(string, filenameFilter, this, fileFactory);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.listFiles(archiveController.getEnclController(), archiveController.enclEntryName(string), filenameFilter, fileFactory);
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return File.plain2smartFiles(this.delegate.listFiles(filenameFilter), fileFactory);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static java.io.File[] plain2smartFiles(java.io.File[] fileArray, FileFactory fileFactory) {
        if (fileArray == null) {
            return null;
        }
        int n = fileArray.length;
        while (0 <= --n) {
            fileArray[n] = fileFactory.createFile(fileArray[n]);
        }
        return fileArray;
    }

    public final java.io.File[] listFiles(FileFilter fileFilter) {
        return this.listFiles(fileFilter, (FileFactory)this.archiveDetector);
    }

    public java.io.File[] listFiles(FileFilter fileFilter, FileFactory fileFactory) {
        if (this.innerArchive == null) {
            return this.delegateListFiles(fileFilter, fileFactory);
        }
        return this.listFiles(this.innerArchive.getArchiveController(), this.innerEntryName, fileFilter, fileFactory);
    }

    private java.io.File[] delegateListFiles(FileFilter fileFilter, FileFactory fileFactory) {
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = this.delegate.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            File file = fileFactory.createFile((java.io.File)this, string);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        java.io.File[] fileArray = new java.io.File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    private java.io.File[] listFiles(ArchiveController archiveController, String string, FileFilter fileFilter, FileFactory fileFactory) {
        try {
            return archiveController.listFiles(string, fileFilter, this, fileFactory);
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.listFiles(archiveController.getEnclController(), archiveController.enclEntryName(string), fileFilter, fileFactory);
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegateListFiles(fileFilter, fileFactory);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean createNewFile() throws IOException {
        if (this.enclArchive == null) {
            return this.delegate.createNewFile();
        }
        return this.createNewFile(this.enclArchive.getArchiveController(), this.enclEntryName);
    }

    private boolean createNewFile(ArchiveController archiveController, String string) throws IOException {
        try {
            return archiveController.createNewFile(string, File.isLenient());
        }
        catch (ArchiveController.FalsePositiveException falsePositiveException) {
            return false;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public boolean mkdir() {
        if (this.innerArchive == null) {
            return this.delegate.mkdir();
        }
        return this.mkdir(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private boolean mkdir(ArchiveController archiveController, String string) {
        try {
            return archiveController.mkdir(string, File.isLenient());
        }
        catch (ArchiveController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.mkdir(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            if (!$assertionsDisabled && this.isArchive()) {
                throw new AssertionError();
            }
            return this.delegate.mkdir();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean mkdirs() {
        if (this.innerArchive == null) {
            return this.delegate.mkdirs();
        }
        File file = (File)this.getParentFile();
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        return this.mkdir();
    }

    public boolean delete() {
        if (this.innerArchive == null) {
            return this.delegate.delete();
        }
        return this.delete(this.innerArchive.getArchiveController(), this.innerEntryName);
    }

    private boolean delete(ArchiveController archiveController, String string) {
        try {
            return archiveController.delete(string);
        }
        catch (ArchiveController.FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            return this.delete(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveFileEntryException falsePositiveFileEntryException) {
            if (this.isArchive() && falsePositiveFileEntryException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.delete(archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            if (this.isArchive() && !this.delegate.isDirectory() && falsePositiveNativeException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.delegate.delete();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean deleteAll() {
        boolean bl = true;
        if (this.isDirectory()) {
            java.io.File[] fileArray = this.listFiles(ArchiveDetector.NULL);
            int n = fileArray.length;
            while (--n >= 0) {
                bl &= ((File)fileArray[n]).deleteAll();
            }
        }
        return bl && this.delete();
    }

    public void deleteOnExit() {
        if (this.innerArchive == null) {
            this.delegate.deleteOnExit();
            return;
        }
        if (this.isArchive()) {
            this.isDirectory();
        }
        ArchiveController.ShutdownHook.deleteOnExit.add(this);
    }

    public final boolean renameTo(java.io.File file) {
        return this.renameTo(file, this.archiveDetector);
    }

    public boolean renameTo(java.io.File file, ArchiveDetector archiveDetector) {
        if (!(this.innerArchive != null || file instanceof File && ((File)file).innerArchive != null)) {
            return this.delegate.renameTo(file);
        }
        return !file.exists() && !File.contains(this, file) && File.rename(this, file, archiveDetector);
    }

    private static boolean rename(java.io.File file, java.io.File file2, ArchiveDetector archiveDetector) {
        boolean bl = true;
        if (file.isDirectory()) {
            file2.mkdir();
            Object[] objectArray = file.list();
            if (file2 instanceof File && ((File)file2).innerArchive != null) {
                Arrays.sort(objectArray);
            }
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                bl &= File.rename(archiveDetector.createFile(file, (String)object), archiveDetector.createFile(file2, (String)object), archiveDetector);
            }
            long l = file.lastModified();
            if (l > 0L || !(file instanceof File) || !((File)file).isEntry()) {
                bl &= file2.setLastModified(l);
            }
        } else if (file.isFile()) {
            try {
                File.cp_p(file, file2);
            }
            catch (IOException iOException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl && file.delete();
    }

    public boolean copyFrom(InputStream inputStream) {
        try {
            FileOutputStream fileOutputStream = this.archiveDetector.createFileOutputStream(this, false);
            try {
                File.cp(inputStream, fileOutputStream);
                return true;
            }
            catch (IOException iOException) {
                if (!this.delete()) {
                    this.archiveDetector.createFileOutputStream(this, false).close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean copyFrom(java.io.File file) {
        try {
            File.cp(file, this);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllFrom(java.io.File file) {
        return File.copyAll(file, this, this.archiveDetector, this.archiveDetector, false);
    }

    public boolean copyAllFrom(java.io.File file, ArchiveDetector archiveDetector) {
        return File.copyAll(file, this, archiveDetector, archiveDetector, false);
    }

    public boolean copyAllFrom(java.io.File file, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) {
        return File.copyAll(file, this, archiveDetector, archiveDetector2, false);
    }

    public boolean copyTo(OutputStream outputStream) {
        try {
            FileInputStream fileInputStream = this.archiveDetector.createFileInputStream(this);
            File.cp(fileInputStream, outputStream);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyTo(java.io.File file) {
        try {
            File.cp(this, file);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllTo(java.io.File file) {
        return File.copyAll(this, file, this.archiveDetector, this.archiveDetector, false);
    }

    public boolean copyAllTo(java.io.File file, ArchiveDetector archiveDetector) {
        return File.copyAll(this, file, archiveDetector, archiveDetector, false);
    }

    public boolean copyAllTo(java.io.File file, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) {
        return File.copyAll(this, file, archiveDetector, archiveDetector2, false);
    }

    public boolean archiveCopyFrom(java.io.File file) {
        try {
            File.cp_p(file, this);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllFrom(java.io.File file) {
        return File.copyAll(file, this, this.archiveDetector, this.archiveDetector, true);
    }

    public boolean archiveCopyAllFrom(java.io.File file, ArchiveDetector archiveDetector) {
        return File.copyAll(file, this, archiveDetector, archiveDetector, true);
    }

    public boolean archiveCopyAllFrom(java.io.File file, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) {
        return File.copyAll(file, this, archiveDetector, archiveDetector2, true);
    }

    public boolean archiveCopyTo(java.io.File file) {
        try {
            File.cp_p(this, file);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllTo(java.io.File file) {
        return File.copyAll(this, file, this.archiveDetector, this.archiveDetector, true);
    }

    public boolean archiveCopyAllTo(java.io.File file, ArchiveDetector archiveDetector) {
        return File.copyAll(this, file, archiveDetector, archiveDetector, true);
    }

    public boolean archiveCopyAllTo(java.io.File file, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) {
        return File.copyAll(this, file, archiveDetector, archiveDetector2, true);
    }

    private static final boolean copyAll(java.io.File file, java.io.File file2, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2, boolean bl) {
        return !File.contains(file, file2) && File.copyAllImpl(file, file2, archiveDetector, archiveDetector2, bl);
    }

    private static boolean copyAllImpl(java.io.File file, java.io.File file2, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2, boolean bl) {
        if (file.isDirectory()) {
            boolean bl2;
            boolean bl3 = bl2 = file2.mkdir() || file2.isDirectory();
            if (bl2) {
                long l;
                Object[] objectArray = file.list();
                if (file2 instanceof File && ((File)file2).innerArchive != null) {
                    Arrays.sort(objectArray);
                }
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object = objectArray[i];
                    bl2 &= File.copyAllImpl(archiveDetector.createFile(file, (String)object), archiveDetector2.createFile(file2, (String)object), archiveDetector, archiveDetector2, bl);
                }
                if (!(!bl || (l = file.lastModified()) <= 0L && file instanceof File && ((File)file).isEntry())) {
                    bl2 &= file2.setLastModified(l);
                }
            }
            return bl2;
        }
        if (file.isFile() && (!file2.exists() || file2.isFile())) {
            try {
                File.cp(file, file2, bl);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public static final void cp_p(java.io.File file, java.io.File file2) throws IOException {
        File.cp(file, file2, true);
    }

    public static final void cp(java.io.File file, java.io.File file2) throws IOException {
        File.cp(file, file2, false);
    }

    private static final void cp(java.io.File file, java.io.File file2, boolean bl) throws IOException {
        try {
            ArchiveController.cp(file, file2, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            file2.delete();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            try {
                File.cat(inputStream, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new InputIOException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean catFrom(InputStream inputStream) {
        try {
            FileOutputStream fileOutputStream = this.archiveDetector.createFileOutputStream(this, false);
            try {
                try {
                    File.cat(inputStream, fileOutputStream);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                this.delete();
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean catTo(OutputStream outputStream) {
        boolean bl;
        FileInputStream fileInputStream = this.archiveDetector.createFileInputStream(this);
        try {
            File.cat(fileInputStream, outputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ((InputStream)fileInputStream).close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cat(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null || outputStream == null) {
            throw new NullPointerException();
        }
        Buffer[] bufferArray = File.allocateBuffers();
        try {
            class Reader
            extends Thread {
                int off;
                int len;
                volatile InputIOException exception;
                private final /* synthetic */ InputStream val$in;
                private final /* synthetic */ Buffer[] val$buffers;

                Reader(InputStream inputStream, Buffer[] bufferArray) {
                    this.val$in = inputStream;
                    this.val$buffers = bufferArray;
                    super("TrueZIP Async Stream Reader");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int n;
                    InputStream inputStream = this.val$in;
                    Buffer[] bufferArray = this.val$buffers;
                    int n2 = this.val$buffers.length;
                    do {
                        Buffer buffer;
                        Object object = this;
                        synchronized (object) {
                            while (this.len >= n2) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                            }
                            buffer = bufferArray[(this.off + this.len) % n2];
                        }
                        object = buffer.buf;
                        try {
                            n = inputStream.read((byte[])object, 0, ((Object)object).length);
                        }
                        catch (IOException iOException) {
                            n = -1;
                            this.exception = new InputIOException(iOException);
                        }
                        if (Thread.interrupted()) {
                            n = -1;
                        }
                        buffer.read = n;
                        Reader reader = this;
                        synchronized (reader) {
                            ++this.len;
                            this.notify();
                        }
                    } while (n != -1);
                }

                private void shutdown() {
                    this.interrupt();
                    while (true) {
                        try {
                            this.join();
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }
            Reader reader = new Reader(inputStream, bufferArray);
            reader.start();
            int n = bufferArray.length;
            while (true) {
                Buffer buffer;
                int n2;
                Object object = reader;
                synchronized (object) {
                    while (reader.len <= 0) {
                        try {
                            reader.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    n2 = reader.off;
                    buffer = bufferArray[n2];
                }
                int n3 = buffer.read;
                if (n3 == -1) break;
                object = buffer.buf;
                try {
                    outputStream.write((byte[])object, 0, n3);
                }
                catch (IOException iOException) {
                    reader.shutdown();
                    throw iOException;
                }
                Reader reader2 = reader;
                synchronized (reader2) {
                    reader.off = (n2 + 1) % n;
                    --reader.len;
                    reader.notify();
                }
            }
            if (reader.exception != null) {
                throw reader.exception;
            }
        }
        finally {
            File.releaseBuffers(bufferArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Buffer[] allocateBuffers() {
        Buffer[] bufferArray = buffersList;
        synchronized (buffersList) {
            Iterator iterator = buffersList.iterator();
            while (iterator.hasNext()) {
                Buffer[] bufferArray2 = (Buffer[])((Reference)iterator.next()).get();
                iterator.remove();
                if (bufferArray2 == null) continue;
                // ** MonitorExit[var0] (shouldn't be in output)
                return bufferArray2;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            bufferArray = new Buffer[4];
            int n = bufferArray.length;
            while (--n >= 0) {
                bufferArray[n] = new Buffer();
            }
            return bufferArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void releaseBuffers(Buffer[] bufferArray) {
        List list = buffersList;
        synchronized (list) {
            buffersList.add(new SoftReference<Buffer[]>(bufferArray));
        }
    }

    static {
        $assertionsDisabled = !File.class.desiredAssertionStatus();
        lenient = true;
        defaultArchiveDetector = ArchiveDetector.DEFAULT;
        roots = new HashSet<java.io.File>(Arrays.asList(File.listRoots()));
        uncPrefix = separator + separator;
        buffersList = new LinkedList();
    }

    private static class Buffer {
        byte[] buf = new byte[65536];
        int read;

        private Buffer() {
        }
    }
}

