/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip.raes;

import de.schlichtherle.crypto.io.raes.KeyManagerRaesParameters;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesReadOnlyFile;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.zip.JarDriver;
import de.schlichtherle.io.archive.zip.Zip32InputArchive;
import de.schlichtherle.io.archive.zip.Zip32OutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipException;
import javax.swing.Icon;
import javax.swing.UIManager;

public abstract class AbstractZip32RaesDriver
extends JarDriver {
    private static final int AUTHENTICATION_TRIGGER = 524288;

    public Icon getOpenIcon(Archive archive) {
        return UIManager.getIcon("FileView.directoryIcon");
    }

    public Icon getClosedIcon(Archive archive) {
        return UIManager.getIcon("FileView.directoryIcon");
    }

    public final InputArchive createInputArchive(Archive archive, ReadOnlyFile readOnlyFile) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        RaesReadOnlyFile raesReadOnlyFile = RaesReadOnlyFile.getInstance(readOnlyFile, this.getRaesParameters(archive));
        if (raesReadOnlyFile.length() < 524288L) {
            raesReadOnlyFile.authenticate();
        }
        return this.createZip32InputArchive(raesReadOnlyFile, this.getEncoding(), this.getPreambled(), this.getPostambled());
    }

    protected abstract Zip32InputArchive createZip32InputArchive(ReadOnlyFile var1, String var2, boolean var3, boolean var4) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException;

    public final OutputArchive createOutputArchive(Archive archive, OutputStream outputStream, InputArchive inputArchive) throws UnsupportedEncodingException, IOException {
        RaesOutputStream raesOutputStream = RaesOutputStream.getInstance(outputStream, this.getRaesParameters(archive));
        return this.createZip32OutputArchive(raesOutputStream, this.getEncoding(), (Zip32InputArchive)inputArchive);
    }

    protected abstract Zip32OutputArchive createZip32OutputArchive(OutputStream var1, String var2, Zip32InputArchive var3) throws NullPointerException, UnsupportedEncodingException, IOException;

    public RaesParameters getRaesParameters(Archive archive) {
        return new KeyManagerRaesParameters(archive.getPath());
    }
}

