/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key;

import de.schlichtherle.key.KeyProvider;
import de.schlichtherle.key.SharedKeyProvider;
import de.schlichtherle.key.passwd.swing.PromptingKeyManager;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class KeyManager {
    private static volatile KeyManager keyManager;
    private static final Map providers;
    private final Map providerTypes = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized KeyManager getInstance() {
        if (keyManager == null) {
            String string = System.getProperty("de.schlichtherle.key.KeyManager");
            if (string != null) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                    keyManager = (KeyManager)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new UndeclaredThrowableException(classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new UndeclaredThrowableException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UndeclaredThrowableException(illegalAccessException);
                }
            } else {
                keyManager = new PromptingKeyManager();
            }
        }
        return keyManager;
    }

    public static void setInstance(KeyManager keyManager) {
        KeyManager.keyManager = keyManager;
    }

    static final synchronized KeyProvider mapKeyProvider(String string, KeyProvider keyProvider) throws NullPointerException {
        if (string == null || keyProvider == null) {
            throw new NullPointerException();
        }
        return providers.put(string, keyProvider);
    }

    static final synchronized KeyProvider unmapKeyProvider(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException();
        }
        return (KeyProvider)providers.remove(string);
    }

    public static synchronized boolean resetKeyProvider(String string) {
        KeyProvider keyProvider = (KeyProvider)providers.get(string);
        if (keyProvider instanceof SharedKeyProvider) {
            SharedKeyProvider sharedKeyProvider = (SharedKeyProvider)keyProvider;
            sharedKeyProvider.reset();
            return true;
        }
        return false;
    }

    public static synchronized boolean resetAndRemoveKeyProvider(String string) {
        KeyProvider keyProvider = (KeyProvider)providers.get(string);
        if (keyProvider instanceof SharedKeyProvider) {
            SharedKeyProvider sharedKeyProvider = (SharedKeyProvider)keyProvider;
            sharedKeyProvider.reset();
            KeyProvider keyProvider2 = sharedKeyProvider.removeFromKeyManager(string);
            if (!$assertionsDisabled && keyProvider != keyProvider2) {
                throw new AssertionError();
            }
            return true;
        }
        if (keyProvider != null) {
            KeyProvider keyProvider3 = KeyManager.unmapKeyProvider(string);
            if (!$assertionsDisabled && keyProvider != keyProvider3) {
                throw new AssertionError();
            }
            return true;
        }
        return false;
    }

    public static void resetKeyProviders() {
        KeyManager.forEachKeyProvider(new KeyProviderCommand(){

            public void run(String string, KeyProvider keyProvider) {
                if (keyProvider instanceof SharedKeyProvider) {
                    ((SharedKeyProvider)keyProvider).reset();
                }
            }
        });
    }

    public static final void resetAndClearKeyProviders() {
        KeyManager.resetAndRemoveKeyProviders();
    }

    public static synchronized void resetAndRemoveKeyProviders() {
        class ResetAndRemoveKeyProvider
        implements KeyProviderCommand {
            IllegalStateException ise = null;
            static final /* synthetic */ boolean $assertionsDisabled;

            ResetAndRemoveKeyProvider() {
            }

            public void run(String string, KeyProvider keyProvider) {
                if (keyProvider instanceof SharedKeyProvider) {
                    SharedKeyProvider sharedKeyProvider = (SharedKeyProvider)keyProvider;
                    sharedKeyProvider.reset();
                    try {
                        sharedKeyProvider.removeFromKeyManager(string);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.ise = illegalStateException;
                    }
                } else {
                    KeyProvider keyProvider2 = KeyManager.unmapKeyProvider(string);
                    if (!$assertionsDisabled && keyProvider != keyProvider2) {
                        throw new AssertionError();
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$de$schlichtherle$key$KeyManager == null ? (class$de$schlichtherle$key$KeyManager = KeyManager.class$("de.schlichtherle.key.KeyManager")) : class$de$schlichtherle$key$KeyManager).desiredAssertionStatus();
            }
        }
        ResetAndRemoveKeyProvider resetAndRemoveKeyProvider = new ResetAndRemoveKeyProvider();
        KeyManager.forEachKeyProvider(resetAndRemoveKeyProvider);
        if (resetAndRemoveKeyProvider.ise != null) {
            throw resetAndRemoveKeyProvider.ise;
        }
    }

    protected static synchronized void forEachKeyProvider(KeyProviderCommand keyProviderCommand) {
        Set set = providers.entrySet();
        int n = set.size();
        Map.Entry[] entryArray = set.toArray(new Map.Entry[n]);
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = entryArray[i];
            String string = (String)entry.getKey();
            KeyProvider keyProvider = (KeyProvider)entry.getValue();
            keyProviderCommand.run(string, keyProvider);
        }
    }

    public static synchronized boolean moveKeyProvider(String string, String string2) throws NullPointerException, IllegalStateException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        KeyProvider keyProvider = (KeyProvider)providers.get(string);
        if (keyProvider == null) {
            return false;
        }
        if (keyProvider instanceof SharedKeyProvider) {
            SharedKeyProvider sharedKeyProvider = (SharedKeyProvider)keyProvider;
            sharedKeyProvider.removeFromKeyManager(string);
            try {
                sharedKeyProvider.addToKeyManager(string2);
            }
            catch (RuntimeException runtimeException) {
                sharedKeyProvider.addToKeyManager(string);
                throw runtimeException;
            }
        } else {
            KeyManager.unmapKeyProvider(string);
            KeyManager.mapKeyProvider(string2, keyProvider);
        }
        return true;
    }

    protected final synchronized void mapKeyProviderType(Class clazz, Class clazz2) {
        if (!KeyProvider.class.isAssignableFrom(clazz) || !clazz.isAssignableFrom(clazz2) || clazz == clazz2) {
            throw new IllegalArgumentException(clazz2.getName() + " must be a subclass or implementation of " + clazz.getName() + "!");
        }
        try {
            clazz2.getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(clazz2.getName() + " (no public nullary constructor)");
            illegalArgumentException.initCause(noSuchMethodException);
            throw illegalArgumentException;
        }
        this.providerTypes.put(clazz, clazz2);
    }

    public abstract KeyProvider getKeyProvider(String var1) throws NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized KeyProvider getKeyProvider(String string, Class clazz) throws NullPointerException, ClassCastException, IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException();
        }
        Class clazz2 = KeyManager.class;
        synchronized (clazz2) {
            KeyProvider keyProvider = (KeyProvider)providers.get(string);
            if (keyProvider == null) {
                Object v = this.providerTypes.get(clazz);
                if (v != null) {
                    clazz = (Class)v;
                }
                try {
                    keyProvider = (KeyProvider)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(clazz.getName());
                    illegalArgumentException.initCause(instantiationException);
                    throw illegalArgumentException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(clazz.getName());
                    illegalArgumentException.initCause(illegalAccessException);
                    throw illegalArgumentException;
                }
                this.setKeyProvider(string, keyProvider);
            }
            return keyProvider;
        }
    }

    public void setKeyProvider(String string, KeyProvider keyProvider) throws NullPointerException, IllegalStateException {
        if (keyProvider instanceof SharedKeyProvider) {
            ((SharedKeyProvider)keyProvider).addToKeyManager(string);
        } else {
            KeyManager.mapKeyProvider(string, keyProvider);
        }
    }

    static {
        $assertionsDisabled = !KeyManager.class.desiredAssertionStatus();
        providers = new HashMap();
    }

    protected static interface KeyProviderCommand {
        public void run(String var1, KeyProvider var2);
    }
}

