/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key;

import de.schlichtherle.key.KeyManager;
import de.schlichtherle.key.KeyProvider;
import de.schlichtherle.key.UnknownKeyException;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class SharedKeyProvider
implements KeyProvider {
    private volatile Object key;

    public SharedKeyProvider() {
        this.reset();
    }

    protected KeyProvider addToKeyManager(String string) throws NullPointerException, IllegalStateException {
        return KeyManager.mapKeyProvider(string, this);
    }

    protected KeyProvider removeFromKeyManager(String string) throws NullPointerException, IllegalStateException {
        return KeyManager.unmapKeyProvider(string);
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object object) {
        this.key = object;
    }

    protected Object cloneKey() {
        Object object = this.getKey();
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(clazz.getComponentType(), n);
            System.arraycopy(object, 0, object2, 0, n);
            return object2;
        }
        if (object instanceof Cloneable) {
            try {
                return object.getClass().getMethod("clone", null).invoke(object, null);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetKey() {
        Object object = this.getKey();
        if (object == null) {
            return;
        }
        this.setKey(null);
        Object object2 = object;
        synchronized (object2) {
            if (object instanceof byte[]) {
                Arrays.fill((byte[])object, (byte)0);
            } else if (object instanceof char[]) {
                Arrays.fill((char[])object, '\u0000');
            } else if (object instanceof short[]) {
                Arrays.fill((short[])object, (short)0);
            } else if (object instanceof int[]) {
                Arrays.fill((int[])object, 0);
            } else if (object instanceof long[]) {
                Arrays.fill((long[])object, 0L);
            } else if (object instanceof float[]) {
                Arrays.fill((float[])object, 0.0f);
            } else if (object instanceof double[]) {
                Arrays.fill((double[])object, 0.0);
            } else if (object instanceof boolean[]) {
                Arrays.fill((boolean[])object, false);
            } else if (object instanceof Object[]) {
                Arrays.fill((Object[])object, null);
            }
        }
    }

    public void reset() {
    }

    public Object getCreateKey() throws UnknownKeyException {
        return this.cloneKey();
    }

    public Object getOpenKey() throws UnknownKeyException {
        return this.cloneKey();
    }

    public abstract void invalidOpenKey();
}

