/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.rof.BufferedReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.util.zip.CRC32Exception;
import de.schlichtherle.util.zip.ZipConstants;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants {
    private static long LONG_MSB;
    private static final int LFH_FILE_NAME_LENGTH_OFFSET = 26;
    private static final int EOCD_NUM_ENTRIES_OFFSET = 10;
    private static final int EOCD_CD_SIZE_OFFSET = 12;
    private static final int EOCD_CD_LOCATION_OFFSET = 16;
    private static final int EOCD_COMMENT_OFFSET = 20;
    private final String encoding;
    private String comment;
    private final Map entries = new HashMap();
    private volatile ReadOnlyFile archive;
    private volatile int openStreams;
    private long preamble;
    private long postamble;
    private OffsetMapper mapper;
    private static final Set allocatedInflaters;
    private static final List releasedInflaters;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipFile(String string) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.encoding = "UTF-8";
        try {
            this.init(null, new File(string), true, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public ZipFile(String string, String string2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.encoding = string2;
        this.init(null, new File(string), true, false);
    }

    public ZipFile(String string, String string2, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.encoding = string2;
        this.init(null, new File(string), bl, bl2);
    }

    public ZipFile(File file) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.encoding = "UTF-8";
        try {
            this.init(null, file, true, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public ZipFile(File file, String string) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.encoding = string;
        this.init(null, file, true, false);
    }

    public ZipFile(File file, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.encoding = string;
        this.init(null, file, bl, bl2);
    }

    public ZipFile(ReadOnlyFile readOnlyFile) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.encoding = "UTF-8";
        try {
            this.init(readOnlyFile, null, true, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public ZipFile(ReadOnlyFile readOnlyFile, String string) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.encoding = string;
        this.init(readOnlyFile, null, true, false);
    }

    public ZipFile(ReadOnlyFile readOnlyFile, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.encoding = string;
        this.init(readOnlyFile, null, bl, bl2);
    }

    private void init(ReadOnlyFile readOnlyFile, File file, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        if (this.encoding == null) {
            throw new NullPointerException("encoding");
        }
        new String(new byte[0], this.encoding);
        if (readOnlyFile == null) {
            if (file == null) {
                throw new NullPointerException();
            }
            readOnlyFile = this.createReadOnlyFile(file);
        } else if (!$assertionsDisabled && file != null) {
            throw new AssertionError();
        }
        this.archive = readOnlyFile;
        try {
            BufferedReadOnlyFile bufferedReadOnlyFile = this.archive instanceof BufferedReadOnlyFile ? (BufferedReadOnlyFile)this.archive : new BufferedReadOnlyFile(this.archive);
            this.loadCentralDirectory(bufferedReadOnlyFile, bl, bl2);
        }
        catch (IOException iOException) {
            if (file != null) {
                readOnlyFile.close();
            }
            throw iOException;
        }
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
    }

    protected ReadOnlyFile createReadOnlyFile(File file) throws FileNotFoundException, IOException {
        return new SimpleReadOnlyFile(file);
    }

    private void loadCentralDirectory(ReadOnlyFile readOnlyFile, boolean bl, boolean bl2) throws ZipException, IOException {
        int n = this.findCentralDirectory(readOnlyFile, bl, bl2);
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
        this.preamble = Long.MAX_VALUE;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[46 - byArray.length];
        while (true) {
            readOnlyFile.readFully(byArray);
            if (ZipFile.readUInt(byArray) != 33639248L) break;
            readOnlyFile.readFully(byArray2);
            int n2 = ZipFile.readUShort(byArray2, 24);
            byte[] byArray3 = new byte[n2];
            readOnlyFile.readFully(byArray3);
            ZipEntry zipEntry = this.createZipEntry(new String(byArray3, this.encoding));
            try {
                byte[] byArray4;
                int n3 = 0;
                int n4 = ZipFile.readUShort(byArray2, n3);
                n3 += 2;
                zipEntry.setPlatform((short)(n4 >> 8 & 0xFF));
                zipEntry.setMethod((short)ZipFile.readUShort(byArray2, n3 += 4));
                zipEntry.setDosTime(ZipFile.readUInt(byArray2, n3 += 2));
                zipEntry.setCrc(ZipFile.readUInt(byArray2, n3 += 4));
                zipEntry.setCompressedSize(ZipFile.readUInt(byArray2, n3 += 4));
                zipEntry.setSize(ZipFile.readUInt(byArray2, n3 += 4));
                n3 += 4;
                int n5 = ZipFile.readUShort(byArray2, n3 += 2);
                int n6 = ZipFile.readUShort(byArray2, n3 += 2);
                n3 += 2;
                n3 += 2;
                n3 += 2;
                long l = this.mapper.location(ZipFile.readUInt(byArray2, n3 += 4));
                zipEntry.offset = l | LONG_MSB;
                if (l < this.preamble) {
                    this.preamble = l;
                }
                this.entries.put(zipEntry.getName(), zipEntry);
                if (n5 > 0) {
                    byArray4 = new byte[n5];
                    readOnlyFile.readFully(byArray4);
                    zipEntry.setExtra(byArray4);
                }
                if (n6 > 0) {
                    byArray4 = new byte[n6];
                    readOnlyFile.readFully(byArray4);
                    zipEntry.setComment(new String(byArray4, this.encoding));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ZipException zipException = new ZipException(zipEntry.getName());
                zipException.initCause(illegalArgumentException);
                throw zipException;
            }
            --n;
        }
        if (n % 65536 != 0) {
            throw new ZipException("Not a ZIP compatible file: Expected " + Math.abs(n) + (n > 0 ? " more" : " less") + " entries in the Central Directory!");
        }
        if (this.preamble == Long.MAX_VALUE) {
            this.preamble = 0L;
        }
    }

    private int findCentralDirectory(ReadOnlyFile readOnlyFile, boolean bl, boolean bl2) throws ZipException, IOException {
        long l;
        byte[] byArray = new byte[4];
        if (!bl) {
            readOnlyFile.seek(0L);
            readOnlyFile.readFully(byArray);
            l = ZipFile.readUInt(byArray);
            boolean bl3 = bl = l == 67324752L || l == 101010256L;
        }
        if (bl) {
            l = readOnlyFile.length();
            long l2 = l - 22L;
            long l3 = !bl2 && l2 >= 65535L ? l2 - 65535L : 0L;
            for (long i = l2; i >= l3; --i) {
                readOnlyFile.seek(i);
                readOnlyFile.readFully(byArray);
                if (ZipFile.readUInt(byArray) != 101010256L) continue;
                byte[] byArray2 = new byte[22 - byArray.length];
                readOnlyFile.readFully(byArray2);
                int n = ZipFile.readUShort(byArray2, 10 - byArray.length);
                long l4 = ZipFile.readUInt(byArray2, 12 - byArray.length);
                long l5 = ZipFile.readUInt(byArray2, 16 - byArray.length);
                int n2 = ZipFile.readUShort(byArray2, 20 - byArray.length);
                if (n2 > 0) {
                    byte[] byArray3 = new byte[n2];
                    readOnlyFile.readFully(byArray3);
                    this.setComment(new String(byArray3, this.encoding));
                }
                this.postamble = l - readOnlyFile.getFilePointer();
                long l6 = i - l4;
                readOnlyFile.seek(l6);
                this.mapper = (l6 -= l5) != 0L ? new IrregularOffsetMapper(l6) : new OffsetMapper();
                return n;
            }
        }
        throw new ZipException("Not a ZIP compatible file: End Of Central Directory signature is missing!");
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    public String getComment() {
        return this.comment;
    }

    private void setComment(String string) {
        this.comment = string;
    }

    public synchronized boolean busy() {
        return this.openStreams > 0;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries.values());
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.entries.get(string);
    }

    public int size() {
        return this.entries.size();
    }

    public long length() throws IOException {
        return this.archive.length();
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    public InputStream getPreambleInputStream() throws IOException {
        return new BoundedInputStream(0L, this.preamble);
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    public InputStream getPostambleInputStream() throws IOException {
        return new BoundedInputStream(this.archive.length() - this.postamble, this.postamble);
    }

    public boolean offsetsConsiderPreamble() {
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
        return this.mapper.location(0L) == 0L;
    }

    public final InputStream getCheckedInputStream(ZipEntry zipEntry) throws IOException {
        return this.getCheckedInputStream(zipEntry.getName());
    }

    public InputStream getCheckedInputStream(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        ZipEntry zipEntry = (ZipEntry)this.entries.get(string);
        InputStream inputStream = this.getInputStreamImpl(zipEntry, true);
        if (inputStream == null) {
            return null;
        }
        return new CheckedInputStream(inputStream, zipEntry);
    }

    public final InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.getName(), true);
    }

    public final InputStream getInputStream(ZipEntry zipEntry, boolean bl) throws IOException {
        return this.getInputStream(zipEntry.getName(), bl);
    }

    public final InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, true);
    }

    public synchronized InputStream getInputStream(String string, boolean bl) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        ZipEntry zipEntry = (ZipEntry)this.entries.get(string);
        return this.getInputStreamImpl(zipEntry, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream getInputStreamImpl(ZipEntry zipEntry, boolean bl) throws ZipException, IOException {
        long l;
        Object object;
        long l2;
        this.ensureOpen();
        if (zipEntry == null) {
            return null;
        }
        String string = zipEntry.getName();
        Object object2 = zipEntry;
        synchronized (object2) {
            l2 = zipEntry.offset;
            if (!$assertionsDisabled && l2 == -1L) {
                throw new AssertionError();
            }
            if (l2 < 0L) {
                this.archive.seek(l2 &= LONG_MSB ^ 0xFFFFFFFFFFFFFFFFL);
                object = new byte[30];
                this.archive.readFully((byte[])object);
                l = ZipFile.readUInt(object);
                if (l != 67324752L) {
                    throw new ZipException(string + ": Local File Header signature expected!");
                }
                zipEntry.offset = l2 += (long)(30 + ZipFile.readUShort(object, 26) + ZipFile.readUShort(object, 28));
            }
        }
        object2 = new BoundedInputStream(l2, zipEntry.getCompressedSize());
        switch (zipEntry.getMethod()) {
            case 8: {
                if (bl) {
                    ((BoundedInputStream)object2).addDummy();
                    l = zipEntry.getSize();
                    if (l > 65536L) {
                        l = 65536L;
                    } else if (l < 8192L) {
                        l = 8192L;
                    }
                    object = new PooledInflaterInputStream((InputStream)object2, (int)l);
                    break;
                }
            }
            case 0: {
                object = object2;
                break;
            }
            default: {
                throw new ZipException(string + ": " + zipEntry.getMethod() + ": Unsupported compression method!");
            }
        }
        return new AccountedInputStream((InputStream)object);
    }

    private final void ensureOpen() throws ZipException {
        if (this.archive == null) {
            throw new ZipException("ZipFile has been closed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Inflater allocateInflater() {
        Inflater inflater = null;
        List list = releasedInflaters;
        synchronized (list) {
            Iterator iterator = releasedInflaters.iterator();
            while (iterator.hasNext()) {
                inflater = (Inflater)((Reference)iterator.next()).get();
                iterator.remove();
                if (inflater == null) continue;
                inflater.reset();
                break;
            }
            if (inflater == null) {
                inflater = new Inflater(true);
            }
            allocatedInflaters.add(inflater);
        }
        return inflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseInflater(Inflater inflater) {
        List list = releasedInflaters;
        synchronized (list) {
            releasedInflaters.add(new SoftReference<Inflater>(inflater));
            allocatedInflaters.remove(inflater);
        }
    }

    public synchronized void close() throws IOException {
        if (this.archive != null) {
            ReadOnlyFile readOnlyFile = this.archive;
            this.archive = null;
            readOnlyFile.close();
        }
    }

    private static final int readUShort(byte[] byArray) {
        return ZipFile.readUShort(byArray, 0);
    }

    private static final int readUShort(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    private static final long readUInt(byte[] byArray) {
        return ZipFile.readUInt(byArray, 0);
    }

    private static final long readUInt(byte[] byArray, int n) {
        n += 3;
        long l = (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        return l |= (long)byArray[n] & 0xFFL;
    }

    static {
        $assertionsDisabled = !ZipFile.class.desiredAssertionStatus();
        LONG_MSB = Long.MIN_VALUE;
        allocatedInflaters = new HashSet();
        releasedInflaters = new LinkedList();
    }

    private static class IrregularOffsetMapper
    extends OffsetMapper {
        final long start;

        public IrregularOffsetMapper(long l) {
            this.start = l;
        }

        public long location(long l) {
            return this.start + l;
        }
    }

    private static class OffsetMapper {
        private OffsetMapper() {
        }

        public long location(long l) {
            return l;
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long fp;
        private boolean addDummyByte;
        static final /* synthetic */ boolean $assertionsDisabled;

        BoundedInputStream(long l, long l2) {
            if (!$assertionsDisabled && l < 0L) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && l2 < 0L) {
                throw new AssertionError();
            }
            this.remaining = l2;
            this.fp = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            int n;
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpen();
                ZipFile.this.archive.seek(this.fp);
                n = ZipFile.this.archive.read();
            }
            if (n >= 0) {
                ++this.fp;
                --this.remaining;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 <= 0) {
                return 0;
            }
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    byArray[n] = 0;
                    return 1;
                }
                return -1;
            }
            if ((long)n2 > this.remaining) {
                n2 = (int)this.remaining;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpen();
                ZipFile.this.archive.seek(this.fp);
                n3 = ZipFile.this.archive.read(byArray, n, n2);
            }
            if (n3 > 0) {
                this.fp += (long)n3;
                this.remaining -= (long)n3;
            }
            return n3;
        }

        void addDummy() {
            this.addDummyByte = true;
        }

        public int available() {
            long l = this.remaining;
            if (this.addDummyByte) {
                ++l;
            }
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$util$zip$ZipFile == null ? (class$de$schlichtherle$util$zip$ZipFile = ZipFile.class$("de.schlichtherle.util.zip.ZipFile")) : class$de$schlichtherle$util$zip$ZipFile).desiredAssertionStatus();
        }
    }

    private class AccountedInputStream
    extends FilterInputStream {
        private boolean closed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AccountedInputStream(InputStream inputStream) {
            super(inputStream);
            ZipFile zipFile2 = ZipFile.this;
            synchronized (zipFile2) {
                ZipFile.this.openStreams++;
            }
        }

        public int read(byte[] byArray) throws IOException {
            return this.in.read(byArray, 0, byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                if (!this.closed) {
                    this.closed = true;
                    ZipFile.this.openStreams--;
                    super.close();
                }
            }
        }

        protected void finalize() throws IOException {
            this.close();
        }
    }

    private static class PooledInflaterInputStream
    extends InflaterInputStream {
        private boolean closed;

        public PooledInflaterInputStream(InputStream inputStream, int n) {
            super(inputStream, ZipFile.allocateInflater(), n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                try {
                    super.close();
                }
                finally {
                    ZipFile.releaseInflater(this.inf);
                }
            }
        }
    }

    private static class CheckedInputStream
    extends FilterInputStream {
        private final CRC32 crc = new CRC32();
        private final ZipEntry entry;

        public CheckedInputStream(InputStream inputStream, ZipEntry zipEntry) {
            super(inputStream);
            this.entry = zipEntry;
        }

        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                this.crc.update(n);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.crc.update(byArray, n, n3);
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            int n;
            long l2;
            if (l <= 0L || this.available() <= 0) {
                return 0L;
            }
            int n2 = (int)Math.min(65536L, l2);
            byte[] byArray = new byte[n2];
            for (l2 = l; l2 > 0L && (n = super.read(byArray, 0, n2 = (int)Math.min(65536L, l2))) != -1; l2 -= (long)n) {
                this.crc.update(byArray, 0, n);
            }
            return l - l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.skip(Long.MAX_VALUE);
            }
            finally {
                super.close();
            }
            long l = this.entry.getCrc();
            long l2 = this.crc.getValue();
            if (l != l2) {
                throw new CRC32Exception(this.entry.getName(), l, l2);
            }
        }
    }
}

