/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import java.util.Iterator;
import java.util.Map;
import jode.GlobalOptions;
import jode.obfuscator.IdentifierMatcher;
import jode.obfuscator.Main;
import jode.obfuscator.Renamer;

public abstract class Identifier {
    static int serialnr = 0;
    private Identifier right = null;
    private Identifier left = null;
    private boolean reachable = false;
    private boolean preserved = false;
    private String alias = null;
    private boolean wasAliased = false;

    public final boolean isReachable() {
        return this.reachable;
    }

    public final boolean isPreserved() {
        return this.preserved;
    }

    protected void setSinglePreserved() {
    }

    protected void setSingleReachable() {
        if (this.getParent() != null) {
            this.getParent().setReachable();
        }
    }

    public void setReachable() {
        if (!this.reachable) {
            this.reachable = true;
            this.setSingleReachable();
        }
    }

    public void setPreserved() {
        if (!this.preserved) {
            this.preserved = true;
            Identifier identifier = this;
            while (identifier != null) {
                identifier.setSinglePreserved();
                identifier = identifier.left;
            }
            identifier = this.right;
            while (identifier != null) {
                identifier.setSinglePreserved();
                identifier = identifier.right;
            }
        }
    }

    public Identifier getRepresentative() {
        Identifier identifier = this;
        while (identifier.left != null) {
            identifier = identifier.left;
        }
        return identifier;
    }

    public final boolean isRepresentative() {
        return this.left == null;
    }

    public final boolean wasAliased() {
        return this.getRepresentative().wasAliased;
    }

    public final void setAlias(String string) {
        if (string != null) {
            Identifier identifier = this.getRepresentative();
            identifier.wasAliased = true;
            identifier.alias = string;
        }
    }

    public final String getAlias() {
        return this.getRepresentative().alias;
    }

    /*
     * Unable to fully structure code
     */
    public void addShadow(Identifier var1_1) {
        if (this.isPreserved() && !var1_1.isPreserved()) {
            var1_1.setPreserved();
        } else if (!this.isPreserved() && var1_1.isPreserved()) {
            this.setPreserved();
        }
        var2_2 = this;
        while (var2_2.right != null) {
            var2_2 = var2_2.right;
        }
        var3_3 = var1_1;
        while (var3_3.right != null) {
            var3_3 = var3_3.right;
        }
        if (var3_3 != var2_2) ** GOTO lbl17
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.left;
lbl17:
            // 2 sources

            ** while (var1_1.left != null)
        }
lbl18:
        // 1 sources

        var2_2.right = var1_1;
        var1_1.left = var2_2;
    }

    public void buildTable(Renamer renamer) {
        Object object;
        if (!this.isReachable() && (Main.stripping & 1) != 0) {
            return;
        }
        if (this.isPreserved()) {
            if (GlobalOptions.verboseLevel > 4) {
                GlobalOptions.err.println(this.toString() + " is preserved");
            }
        } else {
            object = this.getRepresentative();
            if (!((Identifier)object).wasAliased) {
                String string;
                ((Identifier)object).wasAliased = true;
                ((Identifier)object).alias = "";
                Iterator iterator = renamer.generateNames(this);
                block0: while (true) {
                    string = (String)iterator.next();
                    Object object2 = object;
                    while (object2 != null) {
                        if (((Identifier)object2).conflicting(string)) continue block0;
                        object2 = ((Identifier)object2).right;
                    }
                    break;
                }
                this.setAlias(string.toString());
            }
        }
        object = this.getChilds();
        while (object.hasNext()) {
            ((Identifier)object.next()).buildTable(renamer);
        }
    }

    public void writeTable(Map map, boolean bl) {
        Object object;
        if (!this.isReachable() && (Main.stripping & 1) != 0) {
            return;
        }
        if (this.getAlias().length() != 0) {
            object = this.getName();
            Identifier identifier = this.getParent();
            while (identifier != null && identifier.getAlias().length() == 0) {
                if (identifier.getName().length() > 0) {
                    object = identifier.getName() + "." + (String)object;
                }
                identifier = identifier.getParent();
            }
            if (bl) {
                map.put(this.getFullAlias(), object);
            } else {
                map.put(this.getFullName(), this.getAlias());
            }
        }
        object = this.getChilds();
        while (object.hasNext()) {
            ((Identifier)object.next()).writeTable(map, bl);
        }
    }

    public void readTable(Map map) {
        Object object;
        Identifier identifier = this.getRepresentative();
        if (!identifier.wasAliased && (object = (String)map.get(this.getFullName())) != null) {
            identifier.wasAliased = true;
            identifier.setAlias((String)object);
        }
        object = this.getChilds();
        while (object.hasNext()) {
            ((Identifier)object.next()).readTable(map);
        }
    }

    public void applyPreserveRule(IdentifierMatcher identifierMatcher) {
        Object object;
        if (identifierMatcher.matches(this)) {
            System.err.println("preserving: " + this);
            this.setReachable();
            object = this;
            while (object != null) {
                ((Identifier)object).setPreserved();
                object = ((Identifier)object).getParent();
            }
        }
        object = this.getChilds();
        while (object.hasNext()) {
            ((Identifier)object.next()).applyPreserveRule(identifierMatcher);
        }
    }

    public abstract Iterator getChilds();

    public abstract Identifier getParent();

    public abstract String getName();

    public abstract String getType();

    public abstract String getFullName();

    public abstract String getFullAlias();

    public abstract boolean conflicting(String var1);

    public void analyze() {
    }

    public Identifier(String string) {
        this.alias = string;
    }
}

